package com.ulcjava.base.application;


	/**
	* The <code>ClientContext</code> class gives an ULC application access to the
	* environment of the UI Engine (ULC
	* client).
<p>
</p>
<b>Features</b>
<ul>
<li>Provides methods to get Swing's
	* UIDefaults for component attributes such as foreground color, background
	* color, font, opaque, border,
etc.
<li>Provides methods for choosing, loading
	* and storing files and for specifying file transfer mode
<li>Provides method
	* toopen a browser on the client
<li>Provides methods to get and set event
	* delivery modes for various event categories
<li>Provides methods to get
	* information about the client environment such as host, IP address, locale,
	* look and feel, system properties,
screen attributes, time zone,
	* etc.
<li>Provides method to send a message to the ULC client
<li>Provides
	* method to access user defined parameters specified on the ULC
	* client
</ul>
<p></p>
<b>Examples</b>
<p>
</p>
To get default visual
	* attributesas defined in Swing's UIDefaults table, see the following
	* example:

<pre>
Color defaultLabelBackground =
	* ClientContext.getColor("Label.background");
Color defaultLabelForeground =
	* ClientContext.getColor("Label.foreground");
Font defaultLabelFont =
	* ClientContext.getFont("Label.font");
</pre>
<p>
</p>
To find out keys for
	* component attributes as specified in Swing's UIDefaults you could invoke the
	* following method from ULC's UI
launcher:

<pre>
public static void
	* printUIDefaults() {
UIDefaults uid = UIManager.getDefaults();
Enumeration e =
	* uid.keys();
while (e.hasMoreElements()) {
Object key =
	* e.nextElement();
Objectvalue = uid.get(key);
System.out.println(key + " => "
	* +value);
}
}
</pre>
	*
	* @ulc.application		
	**/
 public class ClientContext extends java.lang.Object
{

	/**
	* The mode for synchronous event delivery.
	*
	* @see		#setEventDeliveryMode(ULCProxy, String, int)
	* @see		#getEventDeliveryMode(ULCProxy, String)
	* @see		#setModelUpdateMode
	* @see		#getModelUpdateMode
	**/
	 public  final  static int SYNCHRONOUS_MODE = 0;

	/**
	* The mode for asynchronous event delivery.
	*
	* @see		#setEventDeliveryMode(ULCProxy, String, int)
	* @see		#getEventDeliveryMode(ULCProxy, String)
	* @see		#setModelUpdateMode
	* @see		#getModelUpdateMode
	**/
	 public  final  static int ASYNCHRONOUS_MODE = 0;

	/**
	* The mode for deferred event delivery.
	*
	* @see		#setEventDeliveryMode(ULCProxy, String, int)
	* @see		#getEventDeliveryMode(ULCProxy, String)
	* @see		#setModelUpdateMode
	* @see		#getModelUpdateMode
	**/
	 public  final  static int DEFERRED_MODE = 0;

	/**
	* The code that denotes that the client environment is not set properly and
	* therefore undefined
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int UNDEFINED = 0;

	/**
	* The code that denotes the application is launched with an appletLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int APPLET = 0;

	/**
	* The code that denotes the application is launched with a jnlpLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int JNLP = 0;

	/**
	* The code that denotes the application is launched with an standaloneLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int STANDALONE = 0;

	/**
	* The code that denotes the application is running with the development runner
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int DEVELOPMENT = 0;

	/**
	* The code that denotes the application is running in the local container
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int LOCAL = 0;

	 private ClientContext()
	{
		 super();
	}


	/**
	* Emits an audio beep.
	*
	**/
	 public  static void beep()
	{
	}


	/**
	* Shows the document specified by the
	* <code>urlString</code>.
<p>
</p>
<b>Note:</b> This service can only be used
	* ifthe (client side) launcher implementation installs an IBrowserService
	* implementation.
	*
	* @param urlString 		 a String indicating the URL of the document
	**/
	 public  static void showDocument(java.lang.String urlString)
	{
	}


	/**
	* Shows the document specified by the <code>urlString</code> in the specified
	* <code>target</code>.
<p>
</p>
The <code>target</code> argument indicates in
	* which HTML frame the document is to be displayed. The target argument is
	* interpreted as
follows:
<ul>
<li><code>"_self"</code>: Show in the window and
	* frame that contains the UI engine.
<li><code>"_parent"</code>: Show in the UI
	* engine's parent frame. If the UI engine's frame has no parent frame, acts the
	* same as
"_self".
<li><code>"_top"</code>: Show in the top-level frame of the
	* UI engine's window. If the UI engine's frame is the top-level frame, acts
the
	* same as "_self".
<li><code>"_blank"</code>: Show in a new, unnamed top-level
	* window.
<li><code>name</code>: Show in the frame or window named
	* <code>name</code>. If a target named <code>name</code> does not
	* already
exist,a new top-level window with the specified name is created, and
	* the document is shown there.
</ul>
<p>
</p>
The client environment is free to
	* ignore the <code>target</code> parameter.
<p>
</p>
<b>Note:</b> This service
	* can only be used if the (client side) launcher implementation installs an
	* IBrowserService implementation.
	*
	* @param urlString 		 the URL string of the document
	* @param target 		 the target where the document has to be displayed in
	**/
	 public  static void showDocument(java.lang.String urlString, java.lang.String target)
	{
	}


	/**
	* Sends a message to the UI engine. Handling of this message depends on the
	* configuration of the UI engine.
<p>
</p>
<b>Note:</b> This service can only
	* beused if the (client side) launcher implementation installs an
	* IMessageService implementation.
	*
	* @param msg 		 the message to be sent
	**/
	 public  static void sendMessage(java.lang.String msg)
	{
	}


	/**
	* Asks the user to choose one or more files. The paths of the file is specified
	* in the file choose handler. After the action has been
finished on the client
	* side the corresponding hooks in the file choose handler are
	* invoked.
<p>
</p>
<b>Note:</b>By default, the file name transfer is done
	* synchronously (i.e., the user interface will be blocked while the handler
	* is
being called), use <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an
	* <code>IFileService</code>
implementation.
<p>
</p>
<b>Note:</b>This method
	* depends on the type of <code>IFileService</code> implementation installed on
	* the client side (e.g. the
<code>JnlpFileService</code> does not support this
	* operation as this is not supported by JNLP).
	*
	* @param handler 		 the file choose handler
	* @param config 		 the configuration of the file chooser dialog
	* @param parent 		 the parent component of the file chooser dialog
	* @see		#setFileTransferMode(int)
	**/
	 public  static void chooseFile(com.ulcjava.base.application.util.IFileChooseHandler handler, com.ulcjava.base.shared.FileChooserConfig config, com.ulcjava.base.application.ULCComponent parent)
	{
	}


	/**
	* Asks the user to store a file. The content of the file is specified in the
	* filestore handler. After the action has been finished on
the client side the
	* corresponding hooks in the file store handler are
	* invoked.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file
	* is
downloaded and the <code>IFileStoreHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService
	* implementation.
<p>
</p><b>Note:</b>This method depends on the type of
	* <code>IFileService</code> implementation installed on the client side (e.g.
	* the
<code>JnlpFileService</code> ignores the <code>parent</code> parameter as
	* this is not supported by JNLP).
<p>
</p>
<b>Note:</b> This service only
	* supports the FileChooserConfig.FILES_ONLY file selection mode.
	*
	* @param handler 		 the file store handler
	* @param config 		 the configuration of the file chooser dialog
	* @param parent 		 the parent component of the file chooser dialog
	* @throws		Exception if an error occurs during file preparation
	* @see		#setFileTransferMode(int)
	**/
	 public  static void storeFile(com.ulcjava.base.application.util.IFileStoreHandler handler, com.ulcjava.base.shared.FileChooserConfig config, com.ulcjava.base.application.ULCComponent parent)throws java.lang.Exception
	{
	}


	/**
	* Asks the user to store a file. The content of the file is specified in the
	* filestore handler. After the action has been finished on
the client side the
	* corresponding hooks in the file store handler are invoked.
<p>
</p>
If the
	* file to be stored exceeds the specified <code>maximumFileSize</code>, the
	* filewill not be uploaded and the
<code>IFileLoadHandler.onFailure</code>
	* method will be called.
<p>
</p>
<b>Note:</b>By default, the file transfer is
	* done synchronously (i.e., the user interface will be blocked while the file
	* isdownloaded and the <code>IFileStoreHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService
	* implementation.
<p>
</p><b>Note:</b>This method depends on the type of
	* <code>IFileService</code> implementation installed on the client side (e.g.
	* the
<code>JnlpFileService</code> ignores the <code>parent</code> parameter as
	* this is not supported by JNLP).
<p>
</p>
<b>Note:</b> This service only
	* supports the FileChooserConfig.FILES_ONLY file selection mode.
	*
	* @param handler 		 the file store handler
	* @param config 		 the configuration of the file chooser dialog
	* @param parent 		 the parent component of the file chooser dialog
	* @param maximumFileSize 		 the maximum file size in bytes
	* @throws		Exception if an error occurs during file preparation
	* @see		#setFileTransferMode(int)
	**/
	 public  static void storeFile(com.ulcjava.base.application.util.IFileStoreHandler handler, com.ulcjava.base.shared.FileChooserConfig config, com.ulcjava.base.application.ULCComponent parent, long maximumFileSize)throws java.lang.Exception
	{
	}


	/**
	* Stores a file under a file path. The content of the file is specified in the
	* file store handler. After the action has been finished
on the client side the
	* corresponding hooks in the file store handler are
	* invoked.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file
	* is
downloaded and the <code>IFileStoreHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService implementation.
	*
	* @param handler 		 the file store handler
	* @param clientFilePath 		 the file path under which the file is stored
	* @throws		Exception if an error occurs during file preparation
	* @see		#setFileTransferMode(int)
	**/
	 public  static void storeFile(com.ulcjava.base.application.util.IFileStoreHandler handler, java.lang.String clientFilePath)throws java.lang.Exception
	{
	}


	/**
	* Stores a file under a file path. The content of the file is specified in the
	* file store handler. After the action has been finished
on the client side the
	* corresponding hooks in the file store handler are invoked.
<p>
</p>
If the
	* file to be stored exceeds the specified <code>maximumFileSize</code>, the
	* filewill not be uploaded and the
<code>IFileLoadHandler.onFailure</code>
	* method will be called.
<p>
</p>
<b>Note:</b>By default, the file transfer is
	* done synchronously (i.e., the user interface will be blocked while the file
	* isdownloaded and the <code>IFileStoreHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService implementation.
	*
	* @param handler 		 the file store handler
	* @param clientFilePath 		 the file path under which the file is stored
	* @param maximumFileSize 		 the maximum file size in bytes
	* @throws		Exception if an error occurs during file preparation
	* @see		#setFileTransferMode(int)
	**/
	 public  static void storeFile(com.ulcjava.base.application.util.IFileStoreHandler handler, java.lang.String clientFilePath, long maximumFileSize)throws java.lang.Exception
	{
	}


	/**
	* Asks the user to select one or more files to be loaded and transfers them to
	* the server. After the action has been finished on the
client side the
	* corresponding hooks in the file load handler are
	* invoked.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file is
	* uploaded
and the <code>IFileLoadHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService
	* implementation.
<p>
</p><b>Note:</b>This method depends on the type of
	* <code>IFileService</code> implementation installed on the client side (e.g.
	* the
<code>JnlpFileService</code> ignores the <code>parent</code> parameter as
	* this is not supported by JNLP).
<p>
</p>
<b>Note:</b> This service only
	* supports the FileChooserConfig.FILES_ONLY file selection mode.
	*
	* @param handler 		 the file load handler
	* @param config 		 the configuration of the file chooser dialog
	* @param parent 		 the parent component of the file chooser dialog
	* @see		#setFileTransferMode(int)
	**/
	 public  static void loadFile(com.ulcjava.base.application.util.IFileLoadHandler handler, com.ulcjava.base.shared.FileChooserConfig config, com.ulcjava.base.application.ULCComponent parent)
	{
	}


	/**
	* Asks the user to select one or more files to be loaded and transfer them to
	* theserver. After the action has been finished on the
client side the
	* corresponding hooks in the file load handler are invoked.
<p>
</p>
If the
	* selected file exceeds the specified <code>maximumFileSize</code>, the file
	* will not be uploaded and the
<code>IFileLoadHandler.onFailure</code> method
	* will be called.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file is
	* uploaded
and the <code>IFileLoadHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService
	* implementation.
<p>
</p><b>Note:</b>This method depends on the type of
	* <code>IFileService</code> implementation installed on the client side (e.g.
	* the
<code>JnlpFileService</code> ignores the <code>parent</code> parameter as
	* this is not supported by JNLP).
<p>
</p>
<b>Note:</b> This service only
	* supports the FileChooserConfig.FILES_ONLY file selection mode.
	*
	* @param handler 		 the file load handler
	* @param config 		 the configuration of the file chooser dialog
	* @param parent 		 the parent component of the file chooser dialog
	* @param maximumFileSize 		 the maximum file size in bytes
	* @see		#setFileTransferMode(int)
	**/
	 public  static void loadFile(com.ulcjava.base.application.util.IFileLoadHandler handler, com.ulcjava.base.shared.FileChooserConfig config, com.ulcjava.base.application.ULCComponent parent, long maximumFileSize)
	{
	}


	/**
	* Loads a file from a file path. After the action has been finished on the
	* clientside the corresponding hooks in the file load handler
are
	* invoked.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file is
	* uploaded
and the <code>IFileLoadHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService implementation.
	*
	* @param handler 		 the file load handler
	* @param clientFilePath 		 the file path under which the file is stored
	* @see		#setFileTransferMode(int)
	**/
	 public  static void loadFile(com.ulcjava.base.application.util.IFileLoadHandler handler, java.lang.String clientFilePath)
	{
	}


	/**
	* Loads a file from a file path. After the action has been finished on the
	* clientside the corresponding hooks in the file load handler
are
	* invoked.
<p>
</p>
If the file exceeds the specified
	* <code>maximumFileSize</code>, the file will not be uploaded and
	* the
<code>IFileLoadHandler.onFailure</code> method will be
	* called.
<p>
</p>
<b>Note:</b>By default, the file transfer is done
	* synchronously (i.e., the user interface will be blocked while the file is
	* uploaded
and the <code>IFileLoadHandler</code> is being called), use
	* <code>setFileTransferMode(int)</code> to change the
	* mode.
<p>
</p>
<b>Note:</b> This service can only be used if the (client
	* side)launcher implementation installs an IFileService implementation.
	*
	* @param handler 		 the file load handler
	* @param clientFilePath 		 the file path under which the file is stored
	* @param maximumFileSize 		 the maximum file size, in bytes
	* @see		#setFileTransferMode(int)
	**/
	 public  static void loadFile(com.ulcjava.base.application.util.IFileLoadHandler handler, java.lang.String clientFilePath, long maximumFileSize)
	{
	}


	/**
	* Returns an array containing the names of all user parameters.
	*
	* @return		an array containing the names of all user parameters
	**/
	 public  static java.lang.String[] getUserParameterNames()
	{
		return null;
	}


	/**
	* Returns a user parameter identified by a key.
	*
	* @param key 		 the key which identifies the user parameter
	* @return		a user parameter
	**/
	 public  static java.lang.String getUserParameter(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns an array containing the names of all font families only when the array
	* has been initialized on the client. By default the
array is empty. This has
	* been done for the sake of performance to reduce the amount data sent by the
	* client to the server at the time
of starting the application. The array can
	* beinitialized on the client in the launcher as
	* follows:
<p>
</p>

<pre>
ClientEnvironmentAdapter.getClientInfo().setAvailableF
	* ontFamilyNames(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFon
	* tFamilyNames());
</pre>
	*
	* @return		an array containing the names of all font families
	* @see		com.ulcjava.base.application.util.Font
	**/
	 public  static java.lang.String[] getAvailableFontFamilyNames()
	{
		return null;
	}


	/**
	* Returns the client locale.
	*
	* @return		the client locale
	**/
	 public  static java.util.Locale getLocale()
	{
		return null;
	}


	/**
	* Sets the client locale.
	*
	* @throws		SecurityException if a security manager exists and its <code>checkPermission</code> method doesn't allow the operation.
	* @param locale 		 the locale to set
	**/
	 public  static void setLocale(java.util.Locale locale)
	{
	}


	/**
	* Returns the time zone.
	*
	* @return		the time zone
	**/
	 public  static java.util.TimeZone getTimeZone()
	{
		return null;
	}


	/**
	* Returns the screen height in pixels.
	*
	* @return		the screen height in pixels
	**/
	 public  static int getScreenHeight()
	{
		return 0;
	}


	/**
	* Returns the screen resolution in dots-per-inch.
	*
	* @return		the screen resolution in dots-per-inch
	**/
	 public  static int getScreenResolution()
	{
		return 0;
	}


	/**
	* Returns the menu shortcut key mask of the client platform
	*
	* @return		the menu shortcut key mask
	**/
	 public  static int getMenuShortcutKeyMask()
	{
		return 0;
	}


	/**
	* Returns the screen width in pixels.
	*
	* @return		the screen width in pixels
	**/
	 public  static int getScreenWidth()
	{
		return 0;
	}


	/**
	* Returns an array containing the names of all client system
	* properties.
<p>
</p><b>Note:</b> The available client system properties
	* dependon the launcher implementation.
	*
	* @return		an array containing the names of all client system properties
	* @see		com.ulcjava.base.application.util.Font
	**/
	 public  static java.lang.String[] getSystemPropertyNames()
	{
		return null;
	}


	/**
	* Returns a client system property identified by a key.
<p>
</p>
<b>Note:</b>
	* Theavailable client system properties depend on the launcher implementation.
	*
	* @param key 		 the key which identifies the system property
	* @return		a client system property
	**/
	 public  static java.lang.String getSystemProperty(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the raw IP address string "%d&#46%d&#46%d&#46%d".
	*
	* @return		the raw IP address string "%d.%d.%d.%d"
	**/
	 public  static java.lang.String getAddress()
	{
		return null;
	}


	/**
	* Returns the host name.
	*
	* @return		the host name
	**/
	 public  static java.lang.String getHost()
	{
		return null;
	}


	/**
	* Returns the current look and feel.
	*
	* @return		the current look and feel
	**/
	 public  static java.lang.String getLookAndFeelName()
	{
		return null;
	}


	/**
	* Returns true if the current look and feel supports window decorations, false
	* otherwise.
	*
	* @return		true if the current look and feel supports window decorations, false otherwise
	**/
	 public  static boolean getLookAndFeelSupportsWindowDecorations()
	{
		return false;
	}


	/**
	* Sets the delivery mode for the given event category.
	*
	* @param proxy 		 the proxy
	* @param eventCategory 		 the event category
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#getEventDeliveryMode(ULCProxy, int)
	* @deprecated		Use {@link #setEventDeliveryMode(ULCProxy, String, int)} instead.
	* @ulc.application		
	**/
	 public  static void setEventDeliveryMode(com.ulcjava.base.application.ULCProxy proxy, int eventCategory, int mode)
	{
	}


	/**
	* Sets the delivery mode for the given event category.
	*
	* @param proxy 		 the proxy
	* @param eventCategory 		 the name of the event category
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#getEventDeliveryMode(ULCProxy, String)
	* @ulc.application		
	**/
	 public  static void setEventDeliveryMode(com.ulcjava.base.application.ULCProxy proxy, java.lang.String eventCategory, int mode)
	{
	}


	/**
	* Sets the delivery mode for keyboard actions on the given component.
	*
	* @param component 		 the component
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#getKeyboardActionDeliveryMode
	**/
	 public  static void setKeyboardActionDeliveryMode(com.ulcjava.base.application.ULCComponent component, int mode)
	{
	}


	/**
	* Sets the update mode for the given model. For models the default update mode
	* isDEFERRED_MODE.
	*
	* @param model 		 the model
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#getModelUpdateMode(ITreeModel)
	**/
	 public  static void setModelUpdateMode(com.ulcjava.base.application.tree.ITreeModel model, int mode)
	{
	}


	/**
	* Sets the update mode for the given model. For models the default update mode
	* isDEFERRED_MODE.
	*
	* @param model 		 the model
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#getModelUpdateMode(ITableTreeModel)
	**/
	 public  static void setModelUpdateMode(com.ulcjava.base.application.tabletree.ITableTreeModel model, int mode)
	{
	}


	/**
	* Sets the update mode for the given model. For models the default update mode
	* isDEFERRED_MODE.
	*
	* @param model 		 the model
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#getModelUpdateMode(ITableModel)
	**/
	 public  static void setModelUpdateMode(com.ulcjava.base.application.table.ITableModel model, int mode)
	{
	}


	/**
	* Sets the update mode for the given IComboboxModel. For models the default
	* update mode is DEFERRED_MODE.
	*
	* @param model 		 the IComboBoxModel
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#getModelUpdateMode(IComboBoxModel)
	**/
	 public  static void setModelUpdateMode(com.ulcjava.base.application.IComboBoxModel model, int mode)
	{
	}


	/**
	* Sets the update mode for the given IListModel. For models the default update
	* mode is DEFERRED_MODE.
	*
	* @param model 		 the IListModel
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#getModelUpdateMode(IListModel)
	**/
	 public  static void setModelUpdateMode(com.ulcjava.base.application.IListModel model, int mode)
	{
	}


	/**
	* Sets the delivery mode for all following file transfer operations for the
	* current session.
	*
	* @param mode 		 one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#getFileTransferMode
	**/
	 public  static void setFileTransferMode(int mode)
	{
	}


	/**
	* Returns the delivery mode for the given event category.
	*
	* @param proxy 		 the proxy
	* @param eventCategory 		 the event category
	* @return		the event delivery mode for the given event category, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#setEventDeliveryMode(ULCProxy, int, int)
	* @deprecated		Use {@link #getEventDeliveryMode(ULCProxy, String)} instead.
	**/
	 public  static int getEventDeliveryMode(com.ulcjava.base.application.ULCProxy proxy, int eventCategory)
	{
		return 0;
	}


	/**
	* Returns the delivery mode for the given event category.
	*
	* @param proxy 		 the proxy
	* @param eventCategory 		 the event category
	* @return		the event delivery mode for the given event category, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#setEventDeliveryMode(ULCProxy, String, int)
	**/
	 public  static int getEventDeliveryMode(com.ulcjava.base.application.ULCProxy proxy, java.lang.String eventCategory)
	{
		return 0;
	}


	/**
	* Returns the delivery mode for keyboard actions for the given component.
	*
	* @param component 		 the component
	* @return		the event delivery mode for the given event category, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#setKeyboardActionDeliveryMode
	**/
	 public  static int getKeyboardActionDeliveryMode(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the update mode for the given model. For models the default update
	* modeis DEFERRED_MODE.
	*
	* @param model 		 the model
	* @return		the update mode for the given model, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#setModelUpdateMode(ITreeModel, int)
	**/
	 public  static int getModelUpdateMode(com.ulcjava.base.application.tree.ITreeModel model)
	{
		return 0;
	}


	/**
	* Returns the update mode for the given model. For models the default update
	* modeis DEFERRED_MODE.
	*
	* @param model 		 the model
	* @return		the update mode for the given model, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#setModelUpdateMode(ITableTreeModel, int)
	**/
	 public  static int getModelUpdateMode(com.ulcjava.base.application.tabletree.ITableTreeModel model)
	{
		return 0;
	}


	/**
	* Returns the update mode for the given model. For models the default update
	* modeis DEFERRED_MODE.
	*
	* @param model 		 the model
	* @return		the update mode for the given model, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#setModelUpdateMode(IComboBoxModel, int)
	**/
	 public  static int getModelUpdateMode(com.ulcjava.base.application.IComboBoxModel model)
	{
		return 0;
	}


	/**
	* Returns the update mode for the given model. For models the default update
	* modeis DEFERRED_MODE.
	*
	* @param model 		 the model
	* @return		the update mode for the given model, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#setModelUpdateMode(IListModel, int)
	**/
	 public  static int getModelUpdateMode(com.ulcjava.base.application.IListModel model)
	{
		return 0;
	}


	/**
	* Returns the update mode for the given model.
	*
	* @param model 		 the model
	* @return		the update mode for the given model, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
<li>DEFERRED_MODE
</ul>
	* @see		#setModelUpdateMode(ITableModel, int)
	**/
	 public  static int getModelUpdateMode(com.ulcjava.base.application.table.ITableModel model)
	{
		return 0;
	}


	/**
	* Returns the delivery mode for file transfers for the current session.
	*
	* @return		the file transfer mode, one of the following values:
<ul>
<li>ASYNCHRONOUS_MODE
<li>SYNCHRONOUS_MODE
</ul>
	* @see		#setFileTransferMode
	**/
	 public  static int getFileTransferMode()
	{
		return 0;
	}


	/**
	* Returns the font for the specified key as defined in Swing's UIDefaults table.
	* For instance Label.font, Button.font, etc. If the
value of key is a
	* <code>Font</code> return it, otherwise return <code>null</code>.
	*
	* @param key 		 the key of the font
	* @return		the font for the specified key as defined in Swing's UIDefaults table, or <code>null</code>
	**/
	 public  static com.ulcjava.base.application.util.Font getFont(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the color for the specified key as defined in Swing's UIDefaults
	* table.For instance Label.background, Button.foreground,
etc. If the value of
	* key is a <code>Color</code> return it, otherwise return <code>null</code>.
	*
	* @param key 		 the key of the color
	* @return		the color for the specified key as defined in Swing's UIDefaults table, or <code>null</code>
	**/
	 public  static com.ulcjava.base.application.util.Color getColor(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the insets for the specified key as defined in Swing's UIDefaults
	* table. For instance CheckBox.margin, TextArea.margin, etc.
If the value of
	* keyis an <code>Insets</code> return it, otherwise return <code>null</code>.
	*
	* @param key 		 the key of the insets
	* @return		the insets for the specified key as defined in Swing's UIDefaults table, or <code>null</code>
	**/
	 public  static com.ulcjava.base.application.util.Insets getInsets(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the int for the specified key from the defaults table. If the value of
	* key is an <code>Integer</code> return its integer
value, otherwise return 0.
	*
	* @param key 		 the key of the int
	* @return		the integer for the specified key from the ui defaults table, or 0
	**/
	 public  static int getInt(java.lang.String key)
	{
		return 0;
	}


	/**
	* Returns the char for the specified key from the defaults table. If the value
	* ofkey is an <code>Character</code> return its char
value, otherwise return 0.
	*
	* @param key 		 the key of the char
	* @return		the char for the specified key from the ui defaults table, or 0
	**/
	 public  static char getChar(java.lang.String key)
	{
		return 'a';
	}


	/**
	* Returns the Boolean for the specified key from the defaults table. If the
	* valueof key is a <code>Boolean</code> return it, otherwise
return false.
	*
	* @param key 		 the key of the Boolean
	* @return		the Boolean for the specified key from the ui defaults table, or false
	**/
	 public  static boolean getBoolean(java.lang.String key)
	{
		return false;
	}


	/**
	* Returns the String for the specified key from the defaults table. If the value
	* of key is a <code>String</code> return it, otherwise
return <code>null</code>.
	*
	* @param key 		 the key of the String
	* @return		the String for the specified key from the ui defaults table, or <code>null</code>
	**/
	 public  static java.lang.String getString(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the system color for the specified key. If the key is a valid
	* identifier for the defined system colors, the
	* appropriate
<code>SystemColor</code> instance representing the system color
	* will be returned.
	*
	* @param key 		 the key of the system color
	* @return		the system color for the specified key
	**/
	 public  static com.ulcjava.base.application.util.SystemColor getSystemColor(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the border for the specified key as defined in Swing's UIDefaults
	* table. For instance TextField.border, Button.border, etc.
If the value of key
	* is a valid <code>Border</code> return it, otherwise throws an
	* <code>IllegalArgumentException</code>.
	*
	* @param key 		 the key of the border
	* @return		<code>ULCAbstractBorder</code> the border for the specified key
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder getBorder(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns the default value on the client for opaque property of the component
	* specified by the key. For instance, Button.isOpaque,
Label.isOpaque, etc.
	*
	* @param key 		 the key of the Boolean
	* @return		true if isOpaque for the component is true on the client LAF, otherwise false
	**/
	 public  static boolean getOpaque(java.lang.String key)
	{
		return false;
	}


	/**
	* Returns the code denoting the client environment type.
	*
	* @return		the code denoting the client environment type
	* @see		com.ulcjava.base.shared.ClientEnvironmentConstants
	**/
	 public  static int getClientEnvironmentType()
	{
		return 0;
	}


}