package com.ulcjava.base.application;


	/**
	* The <code>DefaultComboBoxCellRenderer</code> provides a default implementation
	* of the <code>IComboBoxCellRenderer</code>
	* interface.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultComboBoxCellRenderer</code> extends <code>ULCLabel</code> and
	* returns itself as the rendering component. All
<code>ULCLabel</code>
	* properties are hence directly available to configure the
	* renderer.
</ul>
<b>Examples</b>
<p>
The following code snippet shows how to
	* configure and install a <code>DefaultComboBoxCellRenderer</code> on a
	* <code>ULCComboBox</code>.
The snippet uses an <code>IDataType</code> to
	* formatthe combo box's list items.

<pre>
Double[] values =
	* getAvailableValues();
ULCComboBox comboBox = new
	* ULCComboBox(values);
DefaultComboBoxCellRenderer renderer = new
	* DefaultComboBoxCellRenderer();
ULCNumberDataType dataType = new
	* ULCNumberDataType();
dataType.setFormattingPolicy(ULCNumberDataType.JAVA_TEXT_F
	* ORMATTING);
renderer.setDataType(dataType);
comboBox.setRenderer(renderer);
</pr
	* e>
	*
	* @ulc.application		
	* @see		ULCComboBox
	* @see		IComboBoxCellRenderer
	**/
 public class DefaultComboBoxCellRenderer extends com.ulcjava.base.application.ULCLabel implements com.ulcjava.base.application.IComboBoxCellRenderer
{


	/**
	* Creates a default combobox cell renderer.
	*
	**/
	 public DefaultComboBoxCellRenderer()
	{
		 super();
	}

	 public void setForeground(com.ulcjava.base.application.util.Color foreground)
	{
	}

	 public void setBackground(com.ulcjava.base.application.util.Color background)
	{
	}

	 public void setFont(com.ulcjava.base.application.util.Font font)
	{
	}

	 public com.ulcjava.base.application.IRendererComponent getComboBoxCellRendererComponent(com.ulcjava.base.application.ULCComboBox comboBox, java.lang.Object value, boolean isSelected, int row)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class DefaultComboBoxCellRendererDispatcher extends ULCLabelDispatcher
{


}
}