package com.ulcjava.base.application;


	/**
	* The <code>DefaultComboBoxModel</code> class provides a default implementation
	* for <code>IComboBoxModels</code>. The convenience
constructors of
	* <code>ULCComboBox</code> use this combo box model implementation
	* implicitly.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultComboBoxModel</code>class provides constructors to create a
	* combobox model given an array or a
<code>List</code> of items.
<li>The
	* <code>DefaultComboBoxModel</code> provides methods to insert and remove items
	* from the list and fires the corresponding
<code>ListDataEvents</code>
	* automatically.
</ul>
<b>Examples</b>
<p>
The following code snippet shows two
	* different ways of implementing a combo box. Both result in creating a combo
	* box that uses a
<code>DefaultComboBoxModel</code>.

<pre>
final String[]
	* values = new String[] {&quot;A&quot;, &quot;B&quot;, &quot;C&quot;,
	* &quot;D&quot;, &quot;E&quot;};
ULCComboBox first = new ULCComboBox(new
	* DefaultComboBoxModel(values));
ULCComboBox second = new
	* ULCComboBox(values);
</pre>

The following code snippet shows how to insert
	* orremove items from a <code>DefaultComboBoxModel</code>. Note
	* that
<code>ULCComboBox</code> offers convenience methods to add and remove
	* items from the model (if an <code>IMutableComboBoxModel</code>
is
	* installed).<pre>
DefaultComboBoxModel model = new
	* DefaultComboBoxModel(values);
ULCComboBox comboBox = new
	* ULCComboBox(model);
model.insertElementAt(&quot;AA&quot;,
	* 1);
model.removeElementAt(3);
</pre>
	*
	* @ulc.application		
	* @see		ULCComboBox
	* @see		IComboBoxModel
	**/
 public class DefaultComboBoxModel extends com.ulcjava.base.application.AbstractListModel implements com.ulcjava.base.application.IMutableComboBoxModel
{


	/**
	* Constructs an empty DefaultComboBoxModel.
	*
	**/
	 public DefaultComboBoxModel()
	{
		 super();
	}


	/**
	* Constructs a DefaultComboBoxModel object initialized with a list.
	*
	* @param items 		 a list of objects
	**/
	 public DefaultComboBoxModel(java.util.List items)
	{
		 super();
	}


	/**
	* Constructs a DefaultComboBoxModel object initialized with an array of objects.
	*
	* @param items 		 an array of objects
	**/
	 public DefaultComboBoxModel(java.lang.Object[] items)
	{
		 super();
	}

	 public void addElement(java.lang.Object item)
	{
	}

	 public java.lang.Object getElementAt(int index)
	{
		return null;
	}


	/**
	* Returns the position of the specified item in the list.
	*
	* @param		item
	* @return		an int representing the index position
	**/
	 public int getIndexOf(java.lang.Object item)
	{
		return 0;
	}

	 public java.lang.Object getSelectedItem()
	{
		return null;
	}

	 public int getSize()
	{
		return 0;
	}

	 public void insertElementAt(java.lang.Object item, int index)
	{
	}


	/**
	* Removes all items in the list.
	*
	**/
	 public void removeAllElements()
	{
	}

	 public void removeElement(java.lang.Object item)
	{
	}

	 public void removeElementAt(int index)
	{
	}

	 public void setSelectedItem(java.lang.Object item)
	{
	}


}