package com.ulcjava.base.application;


	/**
	* The <code>DefaultListCellRenderer</code> provides a default implementation for
	* the <code>IListCellRenderer</code>. It provides the
same rendering behavior
	* asa list without a custom cell renderer and can be used for simple rendering
	* requirements..
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultListCellRenderer</code> uses a <code>ULCLabel</code> as the
	* rendering component.</li>
<li>Unchanged, it provides the same rendering
	* behavior as a list without a custom cell renderer.</li>
<li>The
	* <code>DefaultListCellRenderer</code> provides convenience methods to set a
	* cell's background color, foreground color,
	* and
font.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example creates a
	* list with a default cell renderer which configures the list's font style to
	* beitalic:

<pre>
ULCList list = new ULCList(new
	* MyListModel());
DefaultListCellRenderer boldRenderer = new
	* DefaultListCellRenderer();
Font currentFont = list.getFont();
Font newFont =
	* new Font(currentFont.getName(), Font.ITALIC,
	* currentFont
.getSize());
boldRenderer.setFont(newFont);
list.setCellRenderer(bo
	* ldRenderer);
</pre>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		IListCellRenderer
	**/
 public class DefaultListCellRenderer extends com.ulcjava.base.application.ULCLabel implements com.ulcjava.base.application.IListCellRenderer
{


	/**
	* Creates a default list cell renderer.
	*
	**/
	 public DefaultListCellRenderer()
	{
		 super();
	}


	/**
	* Sets the foreground color of unselected cells.
	*
	* @param foreground 		 the unselected cells' foreground color
	**/
	 public void setForeground(com.ulcjava.base.application.util.Color foreground)
	{
	}


	/**
	* Sets the background color of unselected cells.
	*
	* @param background 		 the unselected cells' background color
	**/
	 public void setBackground(com.ulcjava.base.application.util.Color background)
	{
	}


	/**
	* Sets the font of cells.
	*
	* @param font 		 the cells' font
	**/
	 public void setFont(com.ulcjava.base.application.util.Font font)
	{
	}

	 public com.ulcjava.base.application.IRendererComponent getListCellRendererComponent(com.ulcjava.base.application.ULCList list, java.lang.Object value, boolean isSelected, boolean hasFocus, int row)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class DefaultListCellRendererDispatcher extends ULCLabelDispatcher
{


}
}