package com.ulcjava.base.application;


	/**
	* The <code>IAction</code> interface provides a useful extension to the
	* <code>IActionListener</code> interface in cases where the same
functionality
	* may be accessed by several controls.
<p>
</p>
In addition to the
	* <code>actionPerformed</code> method defined by the
	* <code>IActionListener</code> interface, this interface allows
the application
	* to define:
<ul>
<li>One or more text strings that describe the action. These
	* strings can be used, for example, to display the tooltip text for a button
or
	* to set the text in a menu item.
<li>One or more icons that visualizes the
	* action. These icons can be used, for example, for the icon in a menu or
	* button.
<li>The enabled/disabled state of the functionality. Instead of
	* havingto separately disable the menu item and the toolbar button,
	* the
application can disable the action that implements this interface. All
	* components which are registered as listeners for the state change
then
	* disableevent generation and update the visual state accordingly.
</ul>
The
	* properties of the action are stored as key value pairs. The keys are defined
	* in <code>IAction</code>.
<p>
</p>
The <code>AbstractAction</code> class
	* provides a default implementation of this interface.
	*
	* @ulc.application		
	* @see		AbstractAction
	**/
 public interface IAction extends com.ulcjava.base.application.event.IActionListener
{

	/**
	* The key for the name property, used for texts.
	*
	**/
	 public  final  static java.lang.String NAME = null;

	/**
	* The key used for the short description property, used for tooltip texts.
	*
	**/
	 public  final  static java.lang.String SHORT_DESCRIPTION = null;

	/**
	* The key used for the longer description, could be used for context-sensitive
	* help.
	*
	**/
	 public  final  static java.lang.String LONG_DESCRIPTION = null;

	/**
	* The key used for the small icon (a <code>ULCIcon</code>), used for icons in
	* menus and buttons.
	*
	**/
	 public  final  static java.lang.String SMALL_ICON = null;

	/**
	* The key used to determine the command for action events that will be created
	* when an <code>IAction</code> is executed.
	*
	**/
	 public  final  static java.lang.String ACTION_COMMAND_KEY = null;

	/**
	* The key used for storing a <code>KeyStroke</code> to be used as the
	* acceleratorfor the action.
	*
	**/
	 public  final  static java.lang.String ACCELERATOR_KEY = null;

	/**
	* The key used for storing a <code>KeyEvent</code> to be used as the mnemonic
	* forthe action.
	*
	**/
	 public  final  static java.lang.String MNEMONIC_KEY = null;


	/**
	* Returns the value associated with the provided key. If there is no value
	* associated with the key, null is returned.
	*
	* @param key 		 the key identifying the requested value
	* @return		the value associated with the key or null, if no value is associated with the key
	**/
	 public java.lang.Object getValue(java.lang.String key);

	/**
	* Sets the value associated with the specified key. If for the key provided a
	* value is already set, the value is overwritten. Changes
to the value are
	* propagated to the registered <code>PropertyChangesListener</code> instances.
	*
	* @param key 		 the key identifiying the stored object
	* @param value 		 the value associated with the key
	**/
	 public void putValue(java.lang.String key, java.lang.Object value);

	/**
	* Enables or disables the action. Changes to the enable property are propagated
	* to the registered <code>PropertyChangeListener</code>
instances. This, any
	* associated component gets enabled/disabled according to the enabled state set
	* for the action.
	*
	* @param enabled 		 true to enable the action, false to disable the action
	**/
	 public void setEnabled(boolean enabled);

	/**
	* Returns whether the action is enabled or not.
	*
	* @return		true, if the action is enabled, false otherwise
	**/
	 public boolean isEnabled();

	/**
	* Sets the component or model that will enable/disable this action.
	*
	* @param enabler 		 the component or model that will enable/disable this action
	**/
	 public void setEnabler(com.ulcjava.base.application.enabler.IEnabler enabler);

	/**
	* Gets the component that will enable/disable this action.
	*
	* @return		IEnabler The component that will enable/disable this action.
	**/
	 public com.ulcjava.base.application.enabler.IEnabler getEnabler();

	/**
	* Registers a <code>PropertyChangeListener</code> instance with this action.
	* Thislistener gets notified on action property value
changes.
	*
	* @param listener 		 the <code>PropertyChangeListener</code> to be registered
	**/
	 public void addPropertyChangeListener(java.beans.PropertyChangeListener listener);

	/**
	* Unregisters a <code>PropertyChangeListener</code> instance from this action.
	*
	* @param listener 		 the <code>PropertyChangeListener</code> to be unregistered
	**/
	 public void removePropertyChangeListener(java.beans.PropertyChangeListener listener);

}