package com.ulcjava.base.application;


	/**
	* The <code>IComboBoxModel</code> interface extends the <code>IListModel</code>
	* interface. The <code>ULCComboBox</code> uses the
methods defined by the
	* <code>IListModel</code> to display the list of items to choose from. It adds
	* methods to track the currently
selected item, i.e., the item the user chose
	* from the list or the new entry typed in. An application can implement
	* arbitrary prefetching
and caching mechanisms for performance reasons.
	* <code>AbstractListModel</code> provides a base class that can be used to
	* implement an
<code>IComboBoxModel</code>. Typically however, an application
	* uses the <code>DefaultComboBoxModel</code> instead of implementing a
custom
	* model.
<p>
<b>Features</b>
<ul>
<li>An <code>IComboBoxModel</code>
	* encapsulates a list of items to choose from and the currently selected
	* item.
<li>A combo box model can fire <code>ListDataEvents</code> indicating
	* that items have been changed, inserted or deleted. These events
will trigger
	* the UI Engine to refresh the corresponding values.
<li>A combo box model must
	* fire a <code>ListDataEvent</code> (with type <code>CONTENTS_CHANGED</code>,
	* start and end index -1)
whenever the current selection changes.
<li>Combo box
	* models can be shared across multiple widgets.
<li>A combo box model can be
	* used as an <code>IHasChangedSource</code>.
<li>The default update mode for
	* <code>IComboBoxModel</code> is
	* <code>UlcEventConstants.DEFERRED_MODE</code>.
</ul>
<b>Examples</b>
<p>
The
	* following sample implementation of the <code>IComboBoxModel</code> interface
	* uses <code>AbstractListModel</code> as the base
class. The sample model
	* provides a list of integer values in the range from a minimum value to a
	* maximum value. Note that the model
implementation needs to notify listeners
	* about changes in the selection state, i.e., it must fire a
	* <code>ListDataEvent</code> with
type <code>CONTENTS_CHANGED</code> and start
	* and end row -1. In this case, this can easily be achieved by
	* calling
<code>fireContentsChanged()</code> of <code>AbstractListModel</code>
	* with appropriate arguments.

<pre>
private static class SampleComboBoxModel
	* extends AbstractListModel
implements IComboBoxModel {
private int
	* fMinValue;
private int fMaxValue;
private Object fSelectedItem;

public
	* SampleComboBoxModel(int minValue, int maxValue) {
fMinValue =
	* minValue;
fMaxValue = maxValue;
fSelectedItem = new
	* Integer(minValue);
}

public int getSize() {
return fMaxValue - fMinValue +
	* 1;}

public Object getElementAt(int index) {
return new Integer(fMinValue +
	* index);
}

public void setSelectedItem(Object item) {
fSelectedItem =
	* item;
fireContentsChanged(this, -1, -1);
}

public Object getSelectedItem()
	* {
return fSelectedItem;
}
}
</pre>
	*
	* @ulc.application		
	* @see		ULCComboBox
	* @see		IListModel
	* @see		AbstractListModel
	* @see		DefaultComboBoxModel
	**/
 public interface IComboBoxModel extends com.ulcjava.base.application.IListModel, com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Set the selected item.
<p>
</p>
The model must fire a ListDataEvent(this,
	* ListDataEvent.CONTENTS_CHANGED, -1, -1) if the selection has actually changed.
	*
	* @param item 		 the item to be selected
	**/
	 public void setSelectedItem(java.lang.Object item);

	/**
	* Return the selected item.
	*
	* @return		the selected item
	**/
	 public java.lang.Object getSelectedItem();

}