package com.ulcjava.base.application;


	/**
	* The <code>IListModel</code> interface is used by the <code>ULCList</code> to
	* get data to be displayed in the list. It also manages
notification about the
	* changes to the list data via
	* <code>ListDataEvent</code>s.
<p>
</p>
<b>Features</b>
<ul>
<li>Provides
	* information about the size of the list and allows retrieval of elements by
	* their index.</li>
<li>Keeps track of the listeners of the model, added and
	* removed via <code>addListDataListener()</code>
	* and
<code>removeListDataListener()</code>. A working implementation should
	* keep a collection of listeners and, if the model is mutable,
provide methods
	* allowing notification of the listeners when changes are made to the
	* model.</li>
<li>In most cases, developers will extend
	* <code>AbstractListModel</code> instead of implementing all methods of
	* the
<code>IListModel</code> interface.</li>
<li>The default update mode for
	* <code>IListModel</code> is
	* <code>UlcEventConstants.DEFERRED_MODE</code>.
</ul><p>
</p>
<b>Examples</b>
<p>
	* </p>
This is a very simple model which allows to insert rows:

<pre>
public
	* class MyListModel implements IListModel {
List fListeners;
Vector
	* fData;

public MyListModel() {
fData = new Vector();
for (int i = 0; i &lt;
	* 10; i++) {
fData.add(new Integer(i));
}
fListeners = new
	* ArrayList();
}

public int getSize() {
return fData.size();
}

public Object
	* getElementAt(int index) {
return fData.elementAt(index);
}

public void
	* addListDataListener(IListDataListener listener)
	* {
fListeners.add(listener);
}public void
	* removeListDataListener(IListDataListener listener)
	* {
fListeners.remove(listener);
}

public void insertValueAt(Object value, int
	* index) {
fData.insertElementAt(value, index);
ListDataEvent event = new
	* ListDataEvent(this,
ListDataEvent.INTERVAL_ADDED, index, index);
Iterator
	* iterator = fListeners.iterator();
while (iterator.hasNext())
	* {
IListDataListener iListDataListener =
	* (IListDataListener)iterator
.next();
iListDataListener.intervalAdded(event);
}
	* }
}
</pre>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		com.ulcjava.base.application.event.IListDataListener
	**/
 public interface IListModel
{


	/**
	* Returns the length of the list.
	*
	* @return		the length of the list
	**/
	 public int getSize();

	/**
	* Returns the value at the specified index.
	*
	* @param index 		 the index
	* @return		the value at the specified index
	**/
	 public java.lang.Object getElementAt(int index);

	/**
	* Add a listener to the list that's notified each time a change to the data
	* modeloccurs.
	*
	* @param listener 		 the IListDataListener
	**/
	 public void addListDataListener(com.ulcjava.base.application.event.IListDataListener listener);

	/**
	* Remove a listener from the list that's notified each time a change to the data
	* model occurs.
	*
	* @param listener 		 the IListDataListener
	**/
	 public void removeListDataListener(com.ulcjava.base.application.event.IListDataListener listener);

}