package com.ulcjava.base.application;


	/**
	* The <code>IMutableComboBoxModel</code> interface extends the
	* <code>IComboBoxModel</code> interface. It adds methods to insert and
remove
	* items.
	*
	* @ulc.application		
	* @see		IComboBoxModel
	* @see		DefaultComboBoxModel
	**/
 public interface IMutableComboBoxModel extends com.ulcjava.base.application.IComboBoxModel
{


	/**
	* Adds an item to the end of the model.
	*
	* @param item 		 the <code>Object</code> to be added
	**/
	 public void addElement(java.lang.Object item);

	/**
	* Removes an item from the model.
	*
	* @param item 		 the <code>Object</code> to be removed
	**/
	 public void removeElement(java.lang.Object item);

	/**
	* Adds an item at a specific index.
	*
	* @param item 		 the <code>Object</code> to be added
	* @param index 		 location to add the object
	**/
	 public void insertElementAt(java.lang.Object item, int index);

	/**
	* Removes an item at a specific index.
	*
	* @param index 		 location of object to be removed
	**/
	 public void removeElementAt(int index);

}