package com.ulcjava.base.application;


	/**
	* The <code>ULCAlert</code> class can be used to display simple alert
	* messages.
<p>
</p>
<b>Features</b>
<ul>
<li>A <code>ULCAlert</code> instance
	* displays an alert message and a choice of one, two, or three buttons. After
	* setting up the
<code>ULCAlert</code> instance an application should call the
	* <code>show()</code> method.
<li>Note that - due to the server architecture -
	* the <code>show()</code> method cannot block until the alert closes. For this
	* reason
an application should install an IWindowListener to obtain the label
	* ofthe selected button via <code>getValue()</code> call when the
window is
	* closed.
<li>In addition to the message, an icon can be displayed.
<li>An
	* initial value can be specified. The button with the corresponding label will
	* act as a default button.
</ul>
<b>Examples</b>
<p>
</p>
The following example
	* shows a typical application of the <code>ULCAlert</code> class.

<pre>
final
	* ULCAlert alert = new ULCAlert(frame, // parent window
&quot;Quit
	* application&quot;, // window title
&quot;Do you really want to quit the
	* application?&quot;, &quot;Yes&quot;,
	* &quot;No&quot;);
alert.addWindowListener(new IWindowListener() {
public void
	* windowClosing(WindowEvent event) {
if
	* (alert.getValue().equals(&quot;Yes&quot;))
ApplicationContext.terminate();
}
})
	* ;
alert.show();
</pre>
	*
	* @ulc.application		
	* @see		ULCIcon
	**/
 public class ULCAlert extends com.ulcjava.base.application.ULCProxy
{

	/**
	* No icon is used.
	*
	**/
	 public  final  static int PLAIN_MESSAGE = 0;

	/**
	* Used for error messages.
	*
	**/
	 public  final  static int ERROR_MESSAGE = 0;

	/**
	* Used for information messages.
	*
	**/
	 public  final  static int INFORMATION_MESSAGE = 0;

	/**
	* Used for warning messages.
	*
	**/
	 public  final  static int WARNING_MESSAGE = 0;

	/**
	* Used for questions.
	*
	**/
	 public  final  static int QUESTION_MESSAGE = 0;


	/**
	* Constructs a new alert with one button and the default icon without a parent
	* window.
	*
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	**/
	 public ULCAlert(java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel)
	{
		 super();
	}


	/**
	* Constructs a new alert with two button and the default icon without a parent
	* window.
	*
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	**/
	 public ULCAlert(java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel)
	{
		 super();
	}


	/**
	* Construct a new alert with three buttons and the default icon without a parent
	* window.
	*
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	* @param thirdButtonLabel 		 the label of the third button
	**/
	 public ULCAlert(java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel, java.lang.String thirdButtonLabel)
	{
		 super();
	}


	/**
	* Construct a new alert with three buttons without a parent window.
	*
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	* @param thirdButtonLabel 		 the label of the third button
	* @param icon 		 the icon of the alert
	**/
	 public ULCAlert(java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel, java.lang.String thirdButtonLabel, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs a new alert with one button and the default icon.
	*
	* @param parent 		 the parent of the alert
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	**/
	 public ULCAlert(com.ulcjava.base.application.ULCRootPane parent, java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel)
	{
		 super();
	}


	/**
	* Constructs a new alert with two buttons and the default icon.
	*
	* @param parent 		 the parent of the alert
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	**/
	 public ULCAlert(com.ulcjava.base.application.ULCRootPane parent, java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel)
	{
		 super();
	}


	/**
	* Constructs a new alert with three buttons and the default icon.
	*
	* @param parent 		 the parent of the alert
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	* @param thirdButtonLabel 		 the label of the third button
	**/
	 public ULCAlert(com.ulcjava.base.application.ULCRootPane parent, java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel, java.lang.String thirdButtonLabel)
	{
		 super();
	}


	/**
	* Constructs a new alert with three buttons.
	*
	* @param parent 		 the parent of the alert
	* @param title 		 the title of the alert
	* @param message 		 the message of the alert
	* @param firstButtonLabel 		 the label of the first button
	* @param secondButtonLabel 		 the label of the second button
	* @param thirdButtonLabel 		 the label of the third button
	* @param icon 		 the icon of the alert
	**/
	 public ULCAlert(com.ulcjava.base.application.ULCRootPane parent, java.lang.String title, java.lang.String message, java.lang.String firstButtonLabel, java.lang.String secondButtonLabel, java.lang.String thirdButtonLabel, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Returns the label of the first button.
	*
	* @return		the label of the first button
	**/
	 public java.lang.String getFirstButtonLabel()
	{
		return null;
	}


	/**
	* Returns the icon of this alert.
	*
	* @return		the icon of this alert
	**/
	 public com.ulcjava.base.application.util.ULCIcon getIcon()
	{
		return null;
	}


	/**
	* Returns the title of this alert.
	*
	* @return		the title of this alert
	**/
	 public java.lang.String getTitle()
	{
		return null;
	}


	/**
	* Returns the message of this alert.
	*
	* @return		the message of this alert
	**/
	 public java.lang.String getMessage()
	{
		return null;
	}


	/**
	* Returns the message type of this alert.
	*
	* @return		the message type of this alert
	**/
	 public int getMessageType()
	{
		return 0;
	}


	/**
	* Returns the parent of this alert.
	*
	* @return		the parent of this alert
	**/
	 public com.ulcjava.base.application.ULCRootPane getParent()
	{
		return null;
	}


	/**
	* Returns the label of the second button.
	*
	* @return		the label of the second button
	**/
	 public java.lang.String getSecondButtonLabel()
	{
		return null;
	}


	/**
	* Returns the value the user has selected. "windowClosing" means the user closed
	* the window with out choosing anything. Otherwise the
returned value will be
	* one of the button labels.
	*
	* @return		the value the user has selected
	**/
	 public java.lang.String getValue()
	{
		return null;
	}


	/**
	* Returns the label of the third button.
	*
	* @return		the label of the third button
	**/
	 public java.lang.String getThirdButtonLabel()
	{
		return null;
	}


	/**
	* Returns the initial value.
	*
	* @return		the initial value
	**/
	 public java.lang.String getInitialValue()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateValue(java.lang.String value)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the icon of this alert.
	*
	* @param icon 		 the icon of this alert
	**/
	 public void setIcon(com.ulcjava.base.application.util.ULCIcon icon)
	{
	}


	/**
	* Sets the title of this alert.
	*
	* @param title 		 the title of this alert
	**/
	 public void setTitle(java.lang.String title)
	{
	}


	/**
	* Sets the message of this alert.
	*
	* @param message 		 the message of this alert
	**/
	 public void setMessage(java.lang.String message)
	{
	}


	/**
	* Sets the message type of this alert.
	*
	* @param messageType 		 the message type of this alert
	**/
	 public void setMessageType(int messageType)
	{
	}


	/**
	* Sets the parent of this alert.
	*
	* @param parent 		 the parent of this alert
	**/
	 public void setParent(com.ulcjava.base.application.ULCRootPane parent)
	{
	}


	/**
	* Sets the label of the first button.
	*
	* @param label 		 the label for the first button
	**/
	 public void setFirstButtonLabel(java.lang.String label)
	{
	}


	/**
	* Sets the label of the second button.
	*
	* @param label 		 the label for the second button
	**/
	 public void setSecondButtonLabel(java.lang.String label)
	{
	}


	/**
	* Sets the label of the third button.
	*
	* @param label 		 the label for the third button
	**/
	 public void setThirdButtonLabel(java.lang.String label)
	{
	}


	/**
	* Sets the initial value. The initial value is the label of the default button.
	*
	* @param initialValue 		 the initial value
	**/
	 public void setInitialValue(java.lang.String initialValue)
	{
	}


	/**
	* Makes the alert window visible. If the alert window or its owner are not yet
	* displayable, both are made displayable. If the Window is
already visible,
	* thiswill bring the Window to the front.
	*
	**/
	 public void show()
	{
	}


	/**
	* Registers the specified window listener with the alert window. If l is null,
	* nothing happens.
	*
	* @param l 		 the window listener
	**/
	 public void addWindowListener(com.ulcjava.base.application.event.IWindowListener l)
	{
	}


	/**
	* Returns an array of all the <code>IWindowListener</code>s added to this
	* <code>ULCAlert</code> with
<code>addWindowListener()</code>.
	*
	* @return		all <code>IWindowListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IWindowListener[] getWindowListeners()
	{
		return null;
	}


	/**
	* Removes the specified window listener so that it no longer receives window
	* events from this window. If l is null, no exception is
thrown and no action
	* isperformed.
	*
	* @param l 		 the window listener
	**/
	 public void removeWindowListener(com.ulcjava.base.application.event.IWindowListener l)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCAlertDispatcher extends ULCProxyDispatcher
{

	 public  final void updateValue(java.lang.String value)
	{
	}


}
}