package com.ulcjava.base.application;


	/**
	* The <code>ULCBorderLayoutPane</code> aligns and resizes its components to fit
	* in five regions: north, south, east, west, and center.
ULC's
	* <code>ULCBorderLayoutPane</code> behaves analogous to Swing's
	* <code>BorderLayout</code>.
<p>
</p>
<b>Features</b>
<p>
</p>
<ul>
<li> Each
	* region is identified by a corresponding constant: <code>NORTH</code>,
	* <code>SOUTH</code>, <code>EAST</code>,
<code>WEST</code>, and
	* <code>CENTER</code>.
<li> The components are laid out according to their
	* preferred sizes and the constraints of the container's size. The
	* <code>NORTH</code>
and <code>SOUTH</code> components may be stretched
	* horizontally; the <code>EAST</code> and <code>WEST</code> components may
	* be
stretched vertically; the <code>CENTER</code> component may be stretched
	* both horizontally and vertically to fill any space left
	* over.
</ul>
<b>Examples</b>
<p>
</p>
The following code snippet shows how two
	* add components to a <code>ULCBorderLayoutPane</code>, specifying that the 3
	* buttons will be
added in the center, to the left, and to the right,
	* respectively.

<pre>
ULCBorderLayoutPane borderLayoutPane = new
	* ULCBorderLayoutPane();
borderLayoutPane.add(new ULCButton(&quot;1&quot;),
	* ULCBorderLayoutPane.CENTER);
borderLayoutPane.add(new
	* ULCButton(&quot;2&quot;), ULCBorderLayoutPane.WEST);
borderLayoutPane.add(new
	* ULCButton(&quot;3&quot;), ULCBorderLayoutPane.EAST);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCBorderLayoutPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* The north layout constraints (top of pane).
	*
	**/
	 public  final  static java.lang.String NORTH = null;

	/**
	* The south layout constraints (bottom of pane).
	*
	**/
	 public  final  static java.lang.String SOUTH = null;

	/**
	* The east layout constraints (right side of pane).
	*
	**/
	 public  final  static java.lang.String EAST = null;

	/**
	* The west layout constraints (left side of pane).
	*
	**/
	 public  final  static java.lang.String WEST = null;

	/**
	* The center layout constraints (middle of pane).
	*
	**/
	 public  final  static java.lang.String CENTER = null;


	/**
	* Creates a new <code>ULCBorderLayoutPane</code> instance.
	*
	**/
	 public ULCBorderLayoutPane()
	{
		 super();
	}


	/**
	* Creates a new <code>ULCBorderLayoutPane</code> instance with the specified
	* horizontal and vertical gap.
	*
	* @param hgap 		 the horizontal gap.
	* @param vgap 		 the vertical gap.
	**/
	 public ULCBorderLayoutPane(int hgap, int vgap)
	{
		 super();
	}


	/**
	* Adds the specified component to this border layout pane, applying the
	* specifiedconstraints.
<p>
</p>
For BorderLayoutPane, the constraints have to
	* be one of the following constans:
<p>
</p>
ULCBorderLayoutPane.NORTH
	* ULCBorderLayoutPane.EAST ULCBorderLayoutPane.SOUTH ULCBorderLayoutPane.WEST
	* ULCBorderLayoutPane.CENTER
<p>
</p>
	*
	* @param component 		 the component to be added
	* @param constraints 		 the constraints to be added
	* @return		the component argument
	* @throws		IllegalArgumentException if the constraint is not one of the above values
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.String constraints)
	{
		return null;
	}


	/**
	* Adds the specified component to this border layout pane, applying the
	* specifiedconstraints.
<p>
</p>
For BorderLayoutPane, the constraints have to
	* be one of the following constants:
<p>
</p>
ULCBorderLayoutPane.NORTH
	* ULCBorderLayoutPane.EAST ULCBorderLayoutPane.SOUTH ULCBorderLayoutPane.WEST
	* ULCBorderLayoutPane.CENTER
<p>
</p>
	*
	* @param component 		 the component to be added
	* @param constraints 		 the constraints to be added
	* @return		the component argument
	* @throws		IllegalArgumentException if the constraints is not a String
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Returns the horizontal gap.
	*
	* @return		the horizontal gap.
	**/
	 public int getHgap()
	{
		return 0;
	}


	/**
	* Sets the horizontal gap.
	*
	* @param horizontalGap 		 the horizontal gap
	**/
	 public void setHgap(int horizontalGap)
	{
	}


	/**
	* Returns the vertical gap.
	*
	* @return		the vertical gap
	**/
	 public int getVgap()
	{
		return 0;
	}


	/**
	* Sets the vertical gap.
	*
	* @param verticalGap 		 the vertical gap
	**/
	 public void setVgap(int verticalGap)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCBorderLayoutPaneDispatcher extends ULCContainerDispatcher
{


}
}