package com.ulcjava.base.application;


	/**
	* <code>ULCBoxLayoutPane</code> lays out components either vertically or
	* horizontally. For positioning the components along the X- or
Y-axis an
	* aligmnet can be set.
<p>
</p>
<b>Features</b>
<ul>
<li>Select to lay out
	* components either vertically or horizontally (default).</li>
<li>Define an
	* alignment to lay out components along the X- or Y-axis
	* (<code>CENTER_ALIGNMENT</code> is
	* default).</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example shows how
	* <code>ULCBoxLayoutPane</code> with a horizontal orientation is
	* constructed:

<pre>
final ULCBoxLayoutPane boxLayoutPane = new
	* ULCBoxLayoutPane(
ULCBoxLayoutPane.X_AXIS);
ULCButton bt1 = new
	* ULCButton(&quot;1&quot;);
boxLayoutPane.add(bt1, -1, 0);
</pre>
	*
	* @ulc.application		
	* @see		ULCMenuBar
	* @see		ULCToolBar
	**/
 public class ULCBoxLayoutPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* Constant for top alignment if components arranged vertically.
	*
	**/
	 public  final  static float TOP_ALIGNMENT = 0.0f;

	/**
	* Constant for center alignment if components arranged either vertically or
	* horizontally.
	*
	**/
	 public  final  static float CENTER_ALIGNMENT = 0.0f;

	/**
	* Constant for bottom alignment if components arranged vertically.
	*
	**/
	 public  final  static float BOTTOM_ALIGNMENT = 0.0f;

	/**
	* Constant for left alignment if components arranged horizontally.
	*
	**/
	 public  final  static float LEFT_ALIGNMENT = 0.0f;

	/**
	* Constant for left alignment if components arranged horizontally.
	*
	**/
	 public  final  static float RIGHT_ALIGNMENT = 0.0f;

	/**
	* Constant for component horizontal layout.
	*
	**/
	 public  final  static int X_AXIS = 0;

	/**
	* Constant for component vertical layout.
	*
	**/
	 public  final  static int Y_AXIS = 0;


	/**
	* Constructur for a new ULCBoxLayoutPane with horizontal orientation.
	*
	**/
	 public ULCBoxLayoutPane()
	{
		 super();
	}


	/**
	* Constructor for a new ULCBoxLayoutPane with the orientation given by axis.
	*
	* @param axis 		 the value representing the orientation
	**/
	 public ULCBoxLayoutPane(int axis)
	{
		 super();
	}


	/**
	* Returns an int representing the layout orientation for this ULCBoxLayoutPane.
	*
	* @return		the layout orientation represented by an int
	**/
	 public int getAxis()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Adds a component at the position indicated by index.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index where to add the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}


	/**
	* Adds a component at the position indicated by index with a specific aligment.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index where to add the component
	* @param alignment 		 the aligment for the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index, float alignment)
	{
		return null;
	}


	/**
	* Adds a component to the container with the specified constraints. The
	* constraints have to be a Float describing the alignment for the
component
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Convencience method that creates a ULCBoxLayoutPane whose components will be
	* layed out horizontally.
	*
	* @return		the ULCBoxLayoutPane
	**/
	 public  static com.ulcjava.base.application.ULCBoxLayoutPane createHorizontalBox()
	{
		return null;
	}


	/**
	* Convencience method that creates a ULCBoxLayoutPane whose components will be
	* layed out vertically.
	*
	* @return		the ULCBoxLayoutPane
	**/
	 public  static com.ulcjava.base.application.ULCBoxLayoutPane createVerticalBox()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCBoxLayoutPaneDispatcher extends ULCContainerDispatcher
{


}
}