package com.ulcjava.base.application;


	/**
	* The <code>ULCBoxPane</code> layout component aligns widgets in a
	* two-dimensional grid. The <code>ULCBoxPane</code> class plays a
central role
	* in the ULC layout mechanism.
<p>
<p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCBoxPane</code> component lays out cells in a two-dimensional grid
	* separated by horizontal and vertical gaps (see
Figure). By default,
	* componentsare added in the order left-to-right and top-to-bottom. If for any
	* reason you are unable to build the
form in this order you can use the
	* extended<code>set()</code> API of <code>ULCBoxPane</code> which takes the row
	* and column within
the box at which the component should be added.
<p
	* align=center>
<img src="doc-files/box-layout-grid.png" alt="ULCBoxPane aligns
	* widgets in a two-dimensional grid"><br>
<code>ULCBoxPane</code> aligns
	* widgetsin a two-dimensional grid
<p>
</p>
<li>When adding a component, the
	* cell alignment can be specified (default is "left-center").
<li>The width of
	* acolumn is determined by the maximum width of all widgets in that respective
	* column. The height of a row is determined
by the maximum height of all
	* widgetsin that row.
<li>Extra Space (the box gains more space than its
	* preferred size) is distributed according to weights set for components.
	* Unlessa
weight for at least one component in a row
	* (<code>horizontalWeight</code>) and column (<code>verticalWeight</code>) is
	* specified,
the extra space is distributed evenly over all expandable rows or
	* columns. A row is expandable if at least one cell attribute in that row
is
	* setto expand. A column is expandable if at least one cell attribute in that
	* column is set to expand. If no expandable rows or columns
exist, the box is
	* centered within its widget bounds.
<li>Empty rows or columns do not take any
	* space. To create space between rows or columns use the <code>ULCFiller</code>
	* widget.
<li>Box cells can span multiple columns or rows (see Figure). In this
	* case the cell alignment is defined by the spanning cell. If the
spanning
	* specification results in overlapping cells the (visual) result is undefined.
	* Note that this spanning behavior is analogous to
the well known spanning of
	* cells in HTML tables.
<p align=center>
<img
	* src="doc-files/box-layout-grid-with-spanning.png" alt="A 3x3 box with two
	* spanning cells"><br>
A 3x3 box with two spanning
	* cells
<p>
</p>
<li><code>ULCBoxPanes</code> can be nested. In many cases, the
	* desired layout can be achieved using either spanning or nesting.
<li>The
	* <code>ULCBoxPane</code> can be enabled and disabled. These operations will
	* result in enabling and disabling all contained
components. Note that this
	* onlyworks after the <code>ULCBoxPane</code> is
	* uploaded.
</ul>
<p>
<p>
<b>Examples</b>
<p>
</p>
The following code excerpt
	* shows how to use the <code>ULCBoxPane</code> component to define a radio
	* button group.

<pre>
ULCBoxPane box = new ULCBoxPane(true); //
	* vertical
ULCRadioButton maleButton = new ULCRadioButton(&quot;Male&quot;,
	* true);
ULCRadioButton femaleButton = new
	* ULCRadioButton(&quot;Female&quot;);
box.add(maleButton);
box.add(femaleButton);
	* </pre>

To disable the two radio buttons defined in the above example,
	* disablethe <code>ULCBoxPane</code>.

<pre>
box.setEnabled(false);
</pre>
	*
	* @ulc.application		
	* @see		ULCFiller
	**/
 public class ULCBoxPane extends com.ulcjava.base.application.ULCGridBagLayoutPane implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a new <code>ULCBoxPane</code> instance.
	*
	**/
	 public ULCBoxPane()
	{
		 super();
	}


	/**
	* Creates a new vertical or horizontal <code>ULCBoxPane</code> instance.
	*
	* @param vertical 		 The boolean value which if true indicates that this is a vertical box.
	**/
	 public ULCBoxPane(boolean vertical)
	{
		 super();
	}


	/**
	* Creates a new vertical or horizontal <code>ULCBoxPane</code> instance and uses
	* the specified gap for either the horizontal or
vertical gap.
	*
	* @param vertical 		 The boolean value which if true indicates that this is a vertical box.
	* @param gap 		 The integer gap between rows or columns.
	**/
	 public ULCBoxPane(boolean vertical, int gap)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCBoxPane</code> instance with the given number of rows
	* and columns.
	*
	* @param columns 		 The integer number of columns within this box.
	* @param rows 		 The integer number of rows within this box.
	**/
	 public ULCBoxPane(int columns, int rows)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCBoxPane</code> instance with the given number of rows
	* and columns and the specified gaps.
	*
	* @param columns 		 The integer number of columns within this box.
	* @param rows 		 The integer number of rows within this box.
	* @param horizontalGap 		 The integer gap to be used between each column.
	* @param verticalGap 		 The integer gap to be used between each row.
	**/
	 public ULCBoxPane(int columns, int rows, int horizontalGap, int verticalGap)
	{
		 super();
	}


	/**
	* Returns the number of columns.
	*
	* @return		the number of columns
	**/
	 public int getColumns()
	{
		return 0;
	}


	/**
	* Sets the number of columns.
	*
	* @param columns 		 the number of columns
	**/
	 public void setColumns(int columns)
	{
	}


	/**
	* Returns the number of rows.
	*
	* @return		the number of rows
	**/
	 public int getRows()
	{
		return 0;
	}


	/**
	* Sets the number of rows.
	*
	* @param rows 		 the number of rows
	**/
	 public void setRows(int rows)
	{
	}


	/**
	* Returns the gap between rows.
	*
	* @return		the gap between rows
	**/
	 public int getHorizontalGap()
	{
		return 0;
	}


	/**
	* Sets the gap between columns.
	*
	* @param horizontalGap 		 the gap between columns
	**/
	 public void setHorizontalGap(int horizontalGap)
	{
	}


	/**
	* Returns the gap between columns.
	*
	* @return		the gap between columns
	**/
	 public int getVerticalGap()
	{
		return 0;
	}


	/**
	* Sets the gap between rows.
	*
	* @param verticalGap 		 the gap between rows
	**/
	 public void setVerticalGap(int verticalGap)
	{
	}


	/**
	* Returns the margin between the box and its enclosed components.
	*
	* @return		the margin between the box and its enclosed components
	**/
	 public int getMargin()
	{
		return 0;
	}


	/**
	* Sets the margin between the box and its enclosed components.
	*
	* @param margin 		 the margin between the box and its enclosed components
	* @deprecated		since release 5.3. See {@link #setBorder(com.ulcjava.base.application.border.ULCAbstractBorder) setBorder}.
	**/
	 public void setMargin(int margin)
	{
	}


	/**
	* Returns true if this box behaves like a button group, false
	* otherwise.
<p>
</p><b>Note:</b> If a button is a member of a button group,
	* youcan't reset its state to false. You have to set another button's state
to
	* true.
	*
	* @return		true if this box behaves like a button group, false otherwise
	* @deprecated		use ULCButtonGroup
	**/
	 public boolean isButtonGroup()
	{
		return false;
	}


	/**
	* Sets the button group behavior of the box. All buttons added to this box are
	* automatically added to the same button group.
<p>
</p>
<b>Note:</b> If a
	* button is a member of a button group you can't reset its state to false. You
	* have to set another button's state to
true.
	*
	* @param buttonGroup 		 true if this box behaves like a button group, false otherwise
	* @deprecated		use ULCButtonGroup in the following way:

<pre>
ULCButtonGroup grp = new ULCButtonGroup();
radioButton1.setGroup(grp);
radioButton2.setGroup(grp);
</pre>
	**/
	 public void setButtonGroup(boolean buttonGroup)
	{
	}


	/**
	* Returns the column of the given component.
	*
	* @param component 		 the component
	* @return		the column of the given component
	**/
	 public int getColumnOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the component at the given position.
	*
	* @param position 		 the position of the component
	* @return		the component at the given position
	* @deprecated		use getComponents()[position] instead
	**/
	 public com.ulcjava.base.application.ULCComponent getComponent(int position)
	{
		return null;
	}


	/**
	* Returns the row of the given component.
	*
	* @param component 		 the component
	* @return		the row of the given component
	**/
	 public int getRowOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the horizontal span of the given component.
	*
	* @param component 		 the component
	* @return		the horizontal span of the given component
	**/
	 public int getHorizontalSpanOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the vertical span of the given component.
	*
	* @param component 		 the component
	* @return		the vertical span of the given component
	**/
	 public int getVerticalSpanOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the horizontal weight of the given component.
	*
	* @param component 		 the component
	* @return		the horizontal weight of the given component
	**/
	 public double getHorizontalWeightOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0.0d;
	}


	/**
	* Returns the vertical weight of the given component.
	*
	* @param component 		 the component
	* @return		the vertical weight of the given component
	**/
	 public double getVerticalWeightOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0.0d;
	}


	/**
	* Returns the alignment of the given component.
	*
	* @param component 		 the component
	* @return		the alignment of the given component
	**/
	 public java.lang.String getAlignmentOf(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Skips the next <code>n</code> cells.
	*
	* @param n 		 the number of cells to skip over
	**/
	 public void skip(int n)
	{
	}


	/**
	* Sets a component at a specific cell.
	*
	* @param column 		 The column location of the cell
	* @param row 		 The row location of the cell
	* @param component 		 The component to be added.
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets a component at a specific cell, applying the specified
	* alignment.
<p>
</p>The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param column 		 the column location of the cell
	* @param row 		 the row location of the cell
	* @param alignment 		 the alignment string
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets a component at a specific cell, applying the specified weights and the
	* specified alignment.
<p>
</p>
The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param column 		 the column location of the cell
	* @param row 		 the row location of the cell
	* @param horizontalWeight 		 the horizontal weight of the cell
	* @param verticalWeight 		 the vertical weight of the cell
	* @param alignment 		 the alignment string
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, double horizontalWeight, double verticalWeight, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets a component at a specific cell, spanning the specified number of cells.
	*
	* @param column 		 the column location of the cell
	* @param row 		 the row location of the cell
	* @param horizontalSpan 		 the horizontal span of the component
	* @param verticalSpan 		 the vertical span of the component
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, int horizontalSpan, int verticalSpan, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets a component at a specific cell, spanning the specified number of cells
	* andapplying the specified alignment.
<p>
</p>
The alignment can be one of the
	* following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param column 		 the column location of the cell
	* @param row 		 the row location of the cell
	* @param horizontalSpan 		 the horizontal span of the component
	* @param verticalSpan 		 the vertical span of the component
	* @param alignment 		 the alignment string
	* @param component 		 the component to be added
	* @return		the ULCComponent added
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, int horizontalSpan, int verticalSpan, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets a component at a specific cell, spanning the specified number of cells
	* andapplying the specified weights and the specified
alignment.
<p>
</p>
The
	* alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param column 		 the column location of the cell
	* @param row 		 the row location of the cell
	* @param horizontalSpan 		 the horizontal span of the component
	* @param verticalSpan 		 the vertical span of the component
	* @param horizontalWeight 		 the horizontal weight of the component
	* @param verticalWeight 		 the vertical weight of the component
	* @param alignment 		 the alignment string
	* @param component 		 the component to be added
	* @return		the ULCComponent added
	**/
	 public com.ulcjava.base.application.ULCComponent set(int column, int row, int horizontalSpan, int verticalSpan, double horizontalWeight, double verticalWeight, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected com.ulcjava.base.application.ULCComponent addImpl(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Adds the specified component at the next possible cell, applying the specified
	* alignment.
<p>
</p>
Cells are filled from left to right and top to bottom at
	* the next available index.
<p>
</p>
The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param alignment 		 the alignment to be applied
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds the specified component at the next possible cell, applying the specified
	* weights and the specified alignment.
<p>
</p>
Cells are filled from left to
	* right and top to bottom at the next available index.
<p>
</p>
The alignment
	* can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param horizontalWeight 		 the horizontal Weight to be added
	* @param verticalWeight 		 the vertical Weight to be added
	* @param alignment 		 the alignment to be applied
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(double horizontalWeight, double verticalWeight, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds the specified component at the next possible cell, applying the specified
	* horizontal span.
<p>
</p>
Cells are filled from left to right and top to
	* bottom at the next available index.
	*
	* @param horizontalSpan 		 the number of cells to span this component over
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(int horizontalSpan, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds the specified component at the next possible cell, applying the specified
	* horizontal span and the specified alignment.
<p>
</p>
The alignment can be
	* oneof the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param horizontalSpan 		 the number of cells to span this component over
	* @param alignment 		 the alignment to be applied
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(int horizontalSpan, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds the specified component at the next possible cell, applying the specified
	* horizontal span, the specified weights and the
specified
	* alignment.
<p>
</p>
The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param horizontalSpan 		 the number of cells to span this component over
	* @param horizontalWeight 		 the horizontal weight of this component
	* @param verticalWeight 		 the vertical weight of this component
	* @param alignment 		 the alignment to be applied
	* @param component 		 the component to be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(int horizontalSpan, double horizontalWeight, double verticalWeight, java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Removes all components held by this ULCBoxPane and resets the index.
	*
	**/
	 public void removeAll()
	{
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 public void setAlignmentOf(com.ulcjava.base.application.ULCComponent component, java.lang.String alignment)
	{
	}

	 public  static int convertToFill(java.lang.String alignment)
	{
		return 0;
	}

	 public  static int convertToAnchor(java.lang.String alignment)
	{
		return 0;
	}

	 public com.ulcjava.base.application.util.Insets convertToInsets(int column, int row)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCBoxPaneDispatcher extends ULCGridBagLayoutPaneDispatcher
{


}
}