package com.ulcjava.base.application;


	/**
	* The <code>ULCButton</code> class provides the standard push button
	* functionality.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCButton</code>
	* component inherits all features from
	* <code>ULCAbstractButton</code>.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example creates a button that displays text along with an icon and registers
	* an <code>IActionListener</code>.

<pre>
ULCButton button = new
	* ULCButton(&quot;ULCButton&quot;,
	* icon);
button.setMnemonic('u');
button.addActionListener(new
	* IActionListener(){
public void actionPerformed(ActionEvent event)
	* {
System.out.println(&quot;button clicked&quot;);
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCAbstractButton
	* @see		ULCComponent
	**/
 public class ULCButton extends com.ulcjava.base.application.ULCAbstractButton
{

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Creates a button with no text or icon.
	*
	**/
	 public ULCButton()
	{
		 super();
	}


	/**
	* Creates a button with an initial icon.
	*
	* @param icon 		 the Icon image to display on the button
	**/
	 public ULCButton(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a button with an initial text.
	*
	* @param text 		 the text of the button
	**/
	 public ULCButton(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a button with an initial text and icon.
	*
	* @param text 		 the text of the button.
	* @param icon 		 the image to be displayed on the button
	**/
	 public ULCButton(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Create a button with the properties defined in the action object. The action
	* isregistered as action listener with the button.
	*
	* @param action 		 the action containing the button properties
	**/
	 public ULCButton(com.ulcjava.base.application.IAction action)
	{
		 super();
	}


	/**
	* Returns whether this button is defined as default button in a root pane.
	*
	* @return		true if the button is default button, false otherwise
	* @see		#setDefaultCapable(boolean)
	* @see		ULCRootPane#setDefaultButton
	**/
	 public boolean isDefaultButton()
	{
		return false;
	}


	/**
	* Returns the value of defaultCapable property.
	*
	* @return		true if the button is default capable, false otherwise
	* @see		#setDefaultCapable(boolean)
	**/
	 public boolean isDefaultCapable()
	{
		return false;
	}


	/**
	* Sets whether the button can be made a default button for its root pane. Note:
	* This property is ultimately dependent on the look and
feel.
	*
	* @param defaultCapable 		 true if button can be a the default button on the root pane, false otherwise
	* @see		#isDefaultCapable
	* @see		ULCRootPane#setDefaultButton
	**/
	 public void setDefaultCapable(boolean defaultCapable)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected void removeNotify()
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCButtonDispatcher extends ULCAbstractButtonDispatcher
{


}
}