package com.ulcjava.base.application;


	/**
	* The <code>ULCCardPane</code> piles components on top of each other and shows
	* only the topmost card. A ULCCardPane does not display
tabs, but is merely
	* usedto implement dynamic layout that allows you to switch programmatically
	* between different widget sub-trees.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCCardPane</code> component is used to pile the ULC components on top
	* of each other. Cards can be added and removed.
<li>Cards are identified by
	* their title.
<li>The <code>ULCCardPane</code> does not display tabs for
	* switching between the cards. Instead, the card to be displayed must
	* be
determined depending on the state of other components or upon some other
	* application state.
<li>All cards are preloaded in the card pane by default.
	* Ifyou want to lazy load a card, call
<code>ULCCardPane.setPreloadAt(name,
	* false)</code> with the name of that card. It is important that this method is
	* called AFTER the
card is added to the card pane and BEFORE the card is
	* uploaded. <b>Note: </b> The size of the <code>ULCCardPane</code> is
	* determinedby
the maximum size of all preloaded cards. If you lazy load some
	* cards you have to take care of the size of
	* <code>ULCCardPane</code>
yourself.</li>
</ul>
<b>Examples</b>
<p>
</p>
The
	* following example shows a view that allows a user to select one of two radio
	* buttons. Based on this selection, the view automatically
displays the
	* corresponding details card.

<pre>
ULCBoxPane box = new ULCBoxPane(2,
	* 2);
ULCButtonGroup buttonGroup = new ULCButtonGroup();
final ULCCardPane
	* cardPane = new ULCCardPane();
final ULCComponent maleDetailsPage =
	* createMaleDetailsForm();
cardPane.addCard(&quot;Male&quot;,
	* maleDetailsPage);
final ULCComponent femaleDetailsPage =
	* createFemaleDetailsForm();
cardPane.addCard(&quot;Female&quot;,
	* femaleDetailsPage);
box.add(2, cardPane); // horizontally span 2
	* cells
ULCRadioButton maleButton = new
	* ULCRadioButton(&quot;Male&quot;);
ULCRadioButton femaleButton = new
	* ULCRadioButton(&quot;Female&quot;);
maleButton.setGroup(buttonGroup);
femaleBut
	* ton.setGroup(buttonGroup);
maleButton.addActionListener(new IActionListener()
	* {public void actionPerformed(ActionEvent event)
	* {
cardPane.setSelectedComponent(maleDetailsPage);
}
});
femaleButton.addActionL
	* istener(new IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
cardPane.setSelectedComponent(femaleDetailsPage);
}
});
box.add(maleButton);
	* box.add(femaleButton);
</pre>

<p>
</p>
<b>Note:</b> All methods providing an
	* <code>alignment</code> parameter have been deprecated. Use the corresponding
	* methods without the
<code>alignment</code> parameter. To specify the
	* alignment, use
	* <code>BorderedComponentUtilities.createBorderedComponent</code>.
E.g.,
	* insteadof using <code>addCard(String align, String name, ULCComponent
	* component)</code> you should use
<code>addCard(String name, ULCComponent
	* component)</code>:
<p>
</p>

<pre>
ULCComponent component =
	* BorderedComponentUtilities
.createBorderedComponent(new
	* ULCButton(
&quot;Button in center with margin
	* 0&quot;),
ULCBoxPane.BOX_CENTER_CENTER, BorderFactory
.createEmptyBorder(5,
	* 5,5, 5));
cardPane.addCard(&quot;card-name&quot;, component);
</pre>
	*
	* @ulc.application		
	* @see		ULCLazyLoadingContainer
	* @see		ULCTabbedPane
	**/
 public class ULCCardPane extends com.ulcjava.base.application.ULCLazyLoadingContainer implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Constructs an empty card pane.
	*
	**/
	 public ULCCardPane()
	{
	}


	/**
	* Constructs an empty card pane.
	*
	* @param hgap 		 the horizontal gap
	* @param vgap 		 the vertical gap
	**/
	 public ULCCardPane(int hgap, int vgap)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Returns the horizontal gap.
	*
	* @return		the horizontal gap
	**/
	 public int getHgap()
	{
		return 0;
	}


	/**
	* Sets the horizontal gap.
	*
	* @param hgap 		 the horizontal gap.
	**/
	 public void setHgap(int hgap)
	{
	}


	/**
	* Returns the vertical gap.
	*
	* @return		the vertical gap
	**/
	 public int getVgap()
	{
		return 0;
	}


	/**
	* Set the vertical gap.
	*
	* @param vgap 		 the vertical gap
	**/
	 public void setVgap(int vgap)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>name</code>.
	*
	* @param name 		 the name under which the component can be selected
	* @param component 		 the component to be displayed when this card is selected
	* @see		#removeCard
	**/
	 public void addCard(java.lang.String name, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>name</code> to this card
	* pane.
<p>
</p>
The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param alignment 		 the alignment string
	* @param name 		 the name under which the component can be selected
	* @param component 		 the component to be displayed when this card is selected
	* @see		#removeCard
	* @deprecated		Use <code>addCard(String name, ULCComponent component)</code> instead. To specify the alignment, use
<code>BorderedComponentUtilities.createBorderedComponent</code>. See the corresponding note in the
<code>ULCCardPane</code> general class API doc.
	**/
	 public void addCard(java.lang.String alignment, java.lang.String name, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a component to this card pane. Takes the name of the card as a
	* constraint.<b>Note</b>: the constraint has to be a String.
	*
	* @param component 		 the component to be added
	* @param constraints 		 the name of the component
	* @return		the added component
	* @throws		IllegalArgumentException if the constraint is not a String
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Removes the card with the specified name.
	*
	* @param name 		 the name of the card to be removed
	* @see		#addCard
	**/
	 public void removeCard(java.lang.String name)
	{
	}


	/**
	* Removes the card with the specified component.
	*
	* @param component 		 the component of the card to be removed
	* @see		#addCard
	**/
	 public void removeCard(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Removes the card with the specified component and sets the server side value
	* for the selected card to the subsequent card. If the
last card is removed,
	* thename of the first card will be set as server side value for the selected
	* card.
	*
	* @param component 		 the component of the card to be removed
	* @see		#addCard
	**/
	 public void remove(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns true if the card represented by <code>name</code> is set to be
	* preloaded, false otherwise.
	*
	* @param name 		 the name of the card being queried
	* @return		true if the card represented by <code>name</code> is set to be preloaded, false otherwise
	* @see		#setPreloadAt
	**/
	 public boolean isPreloadAt(java.lang.String name)
	{
		return false;
	}


	/**
	* Sets if the contents of the card represented by <code>name</code> is to be
	* uploaded or not when the card pane is uploaded. By
default all cards are
	* preloaded, i.e., they are uploaded when the card pane is
	* uploaded.
<p>
</p>
<b>Note:</b> Setting this value after the widget
	* (represented by the card name) has been uploaded has no effect.
	*
	* @param name 		 the card name for which the preload attribute should be set
	* @param preload 		 true if the card represented by <code>name</code> should be uploaded upon upload of the card pane, false otherwise
	* @see		#isPreloadAt
	**/
	 public void setPreloadAt(java.lang.String name, boolean preload)
	{
	}


	/**
	* Returns the name of the currently selected card.
	*
	* @return		the name of the currently selected card
	**/
	 public java.lang.String getSelectedName()
	{
		return null;
	}


	/**
	* Sets the selected name for this card pane.
	*
	* @param name 		 the name to be selected
	**/
	 public void setSelectedName(java.lang.String name)
	{
	}


	/**
	* Returns the currently selected component for this card pane. Returns
	* <code>null</code> if there is no currently selected card.
	*
	* @return		the component corresponding to the currently selected card
	* @see		#setSelectedComponent
	**/
	 public com.ulcjava.base.application.ULCComponent getSelectedComponent()
	{
		return null;
	}


	/**
	* Sets the selected component for this card pane.
	*
	* @param component 		 the component whose card is to be selected
	* @see		#getSelectedComponent
	**/
	 public void setSelectedComponent(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns the component in the card represented by <code>name</code>.
	*
	* @param name 		 the name of the card being queried
	* @return		the <code>ULCComponent</code> in the card represented by <code>name</code>
	* @see		#setComponentAt
	**/
	 public com.ulcjava.base.application.ULCComponent getComponentAt(java.lang.String name)
	{
		return null;
	}


	/**
	* Sets the component in the card represented by <code>name</code> to
	* <code>component</code>.
	*
	* @param name 		 the name of the card where this component is being placed
	* @param component 		 the component for the card
	* @see		#getComponentAt
	**/
	 public void setComponentAt(java.lang.String name, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns the alignment in the card represented by <code>name</code>.
	*
	* @param name 		 the name of the card being queried
	* @return		the alignment in the card represented by <code>name</code>
	* @see		#setAlignmentAt
	* @deprecated		See the corresponding note in the <code>ULCCardPane</code> general class API doc.
	**/
	 public java.lang.String getAlignmentAt(java.lang.String name)
	{
		return null;
	}


	/**
	* Sets the alignment in the card represented by <code>name</code>.
<p>
</p>
The
	* alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param name 		 the name of the card
	* @param alignment 		 the alignment for the card
	* @see		#getAlignmentAt
	* @deprecated		Use BorderedComponentUtilities with an empty border to set alignment. See the corresponding note in the
<code>ULCCardPane</code> general class API doc.
	**/
	 public void setAlignmentAt(java.lang.String name, java.lang.String alignment)
	{
	}


	/**
	* Returns the names of all contained cards.
	*
	* @return		the names of all contained cards
	**/
	 public java.lang.String[] getNames()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
<p/>
<b>Note:</b> this implementation is still based on the deprecated constraints conversion mechanism for backward
compatibility. In order to install the new {@link com.ulcjava.base.shared.IStreamCoder}-based conversion mechanism
in a subclass of this container, overwrite this method and therein, invoke {@link #defaultInternalConvertFromConstraints(Object)}.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.shared.internal.Anything internalConvertFromConstraints(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCCardPaneDispatcher extends ULCLazyLoadingContainerDispatcher
{


}
}