package com.ulcjava.base.application;


	/**
	* The <code>ULCCheckBox</code> class is a subclass of
	* <code>ULCToggleButton</code> and is equivalent to the standard check
	* box.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCCheckBox</code> component
	* inherits all features from <code>ULCToggleButton</code>.
<li>In addition it
	* contains the property <code>borderPaintedFlat</code> which gives the look and
	* feel a hint how to paint the border. The
default value is
	* false.
</ul>
<b>Examples</b>
<p>
</p>
The following example creates three
	* check boxes and installs one <code>IValueChangedListener</code> on
	* them.

<pre>
IValueChangedListener listener = new IValueChangedListener()
	* {
public void valueChanged(ValueChangedEvent event) {
ULCCheckBox source =
	* (ULCCheckBox)event.getSource();
System.out.println(&quot;value changed for:
	* &quot; + source.getText()
+ &quot;. new value is: &quot; +
	* source.isSelected());
}
};
ULCCheckBox one = new ULCCheckBox(&quot;One&quot;,
	* true);
one.addValueChangedListener(listener);
ULCCheckBox two = new
	* ULCCheckBox(&quot;Two&quot;);
two.addValueChangedListener(listener);
ULCCheckBo
	* x three = new
	* ULCCheckBox(&quot;Three&quot;);
three.addValueChangedListener(listener);
</pre>
	*
	* @ulc.application		
	* @see		ULCToggleButton
	* @see		ULCAbstractButton
	* @see		ULCComponent
	**/
 public class ULCCheckBox extends com.ulcjava.base.application.ULCToggleButton implements com.ulcjava.base.application.IRendererComponent, com.ulcjava.base.application.IEditorComponent
{


	/**
	* Creates an unselected check box without text or image.
	*
	**/
	 public ULCCheckBox()
	{
		 super();
	}


	/**
	* Creates an unselected check box with the specified image but no text.
	*
	* @param icon 		 the image to be display on this button
	**/
	 public ULCCheckBox(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a check box with the specified image and selection state, but no text.
	*
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, it is initially unselected
	**/
	 public ULCCheckBox(com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected check box with the specified text.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	**/
	 public ULCCheckBox(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a check box with the specified text and selection state.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCCheckBox(java.lang.String text, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected check box with the specified text and image.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param icon 		 the image to be displayed on this button
	**/
	 public ULCCheckBox(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a check box with the specified text, icon, and selection state.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCCheckBox(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Create a check box with the properties defined in the action object. The
	* actionis registered as action listener with the check box.
	*
	* @param action 		 the action containing the check box properties
	**/
	 public ULCCheckBox(com.ulcjava.base.application.IAction action)
	{
		 super();
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public void copyAttributes(com.ulcjava.base.server.ICellComponent source)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public boolean areAttributesEqual(com.ulcjava.base.server.ICellComponent component)
	{
		return false;
	}

	 public int attributesHashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Gets the value of the <code>borderPaintedFlat</code> property.
	*
	* @return		the value of the <code>borderPaintedFlat</code> property
	* @see		#setBorderPaintedFlat
	**/
	 public boolean isBorderPaintedFlat()
	{
		return false;
	}


	/**
	* Sets the <code>borderPaintedFlat</code> property, which gives a hint to the
	* look and feel as to the appearance of the check box
border. This is usually
	* set to <code>true</code> when a <code>JCheckBox</code> instance is used as a
	* renderer in a component such as
a <code>ULCTable</code> or
	* <code>ULCTree</code>. The default value for the
	* <code>borderPaintedFlat</code>property is
<code>false</code>.
	*
	* @param borderPaintedFlat 		 <code>true</code> requests that the border be painted flat; <code>false</code> requests normal borders
	* @see		#isBorderPaintedFlat
	**/
	 public void setBorderPaintedFlat(boolean borderPaintedFlat)
	{
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCCheckBoxDispatcher extends ULCToggleButtonDispatcher
{


}
}