package com.ulcjava.base.application;


	/**
	* <code>ULCColorChooser</code> provides a pane of controls designed to allow a
	* user to manipulate and select a color.
<p>
<b>Features</b>
<ul>
<li>A
	* <code>ULCColorChooser</code> instance displays an dialog with three buttons.
	* After setting up the <code>ULCColorChooser</code>
instance an application
	* should call the
{@link #createDialog(ULCComponent, String, boolean,
	* ULCColorChooser, IActionListener, IActionListener)} method.</li>
<li>Note
	* that- due to the server architecture - the
{@link #createDialog(ULCComponent,
	* String, boolean, ULCColorChooser, IActionListener, IActionListener)} method
	* cannot block until the
dialog closes.</li>
<li>An initial color can be
	* specified.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example shows a
	* typical application of the <code>ULCColorChooser</code> class.

<pre>
final
	* ULCColorChooser colorChooser = new ULCColorChooser(initialColor);
ULCDialog
	* dialog = ULCColorChooser.createDialog(component, "My Color Chooser", true,
	* colorChooser, new IActionListener() {

public void
	* actionPerformed(ActionEventevent) {
Color newColor =
	* colorChooser.getColor());// Do something with the new color...
}
},
	* null);
dialog.setVisible(true);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCColorChooser extends com.ulcjava.base.application.ULCComponent
{


	/**
	* Creates a new color chooser with white as initial color.
	*
	**/
	 public ULCColorChooser()
	{
		 super();
	}


	/**
	* Creates a new color chooser with the specified initial color.
	*
	* @param		initialColor
	**/
	 public ULCColorChooser(com.ulcjava.base.application.util.Color initialColor)
	{
		 super();
	}


	/**
	* Creates and returns a new dialog containing the specified {@link
	* ULCColorChooser} pane along with "OK", "Cancel", and "Reset"
buttons.
<p>
If
	* the "OK" or "Cancel" buttons are pressed, the dialog is automatically hidden
	* (but not disposed). If the "Reset" button is pressed,
the color-chooser's
	* color will be reset to the color which was set the last time
	* <code>show</code>was invoked on the dialog and the
dialog will remain
	* showing.</p>
	*
	* @param component 		 the parent component for the dialog. Could be <code>null</code>. In this case, the returned dialog window will be
centered.
	* @param title 		 the title for the dialog.
	* @param modal 		 a boolean. When <code>true</code>, the remainder of the program is inactive until the dialog is closed.
	* @param colorChooser 		 the color-chooser to be placed inside the dialog.
	* @param okListener 		 the {@link IActionListener} invoked when "OK" is pressed. Might be <code>null</code>.
	* @param cancelListener 		 the {@link IActionListener} invoked when "Cancel" is pressed. Might be <code>null</code>.
	* @return		a new dialog containing the color-chooser pane
	**/
	 public  static com.ulcjava.base.application.ULCDialog createDialog(com.ulcjava.base.application.ULCComponent component, java.lang.String title, boolean modal, com.ulcjava.base.application.ULCColorChooser colorChooser, com.ulcjava.base.application.event.IActionListener okListener, com.ulcjava.base.application.event.IActionListener cancelListener)
	{
		return null;
	}


	/**
	* Returns the selected color.
	*
	* @return		the selected color
	**/
	 public com.ulcjava.base.application.util.Color getColor()
	{
		return null;
	}


	/**
	* Sets the current color of the color chooser to the specified RGB color. Note
	* that the values of red, green, and blue should be
between the numbers 0 and
	* 255, inclusive.
	*
	* @param r 		 an int specifying the amount of Red
	* @param g 		 an int specifying the amount of Green
	* @param b 		 an int specifying the amount of Blue
	* @exception		IllegalArgumentException if r,g,b values are out of range
	**/
	 public void setColor(int r, int g, int b)
	{
	}


	/**
	* Sets the current color of the color chooser to the specified color.
	*
	* @param color 		 the color to be set in the color chooser.
	**/
	 public void setColor(com.ulcjava.base.application.util.Color color)
	{
	}

	 protected void updateColor(com.ulcjava.base.application.util.Color color)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}

 protected class ULCColorChooserDispatcher extends ULCComponentDispatcher
{

	 public  final void updateColor(com.ulcjava.base.application.util.Color color)
	{
	}


} protected  static class ULCColorChooserDialog extends com.ulcjava.base.application.ULCDialog
{

	 public ULCColorChooserDialog(com.ulcjava.base.application.ULCWindow owner, java.lang.String title, boolean modal, com.ulcjava.base.application.ULCComponent component, com.ulcjava.base.application.ULCColorChooser chooserPane, com.ulcjava.base.application.event.IActionListener okListener, com.ulcjava.base.application.event.IActionListener cancelListener)
	{
		 super();
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


}
}