package com.ulcjava.base.application;


	/**
	* <code>ULCContainer</code> is the abstract base class for all other container
	* classes which can hold components.
<p>
</p>
<p>
</p>
There are two types of
	* containers: top-level containers representing windows on the one hand and
	* layout containers on the other
	* hand.
<p>
</p>
<p>
</p>
<code>ULCContainer</code> combines containers, a
	* layout managers and intermediate
	* objects.
<p>
</p>
<p>
</p>
<b>Features</b>
<ul>
<li>Provides methods to add a
	* component with or without constraints.</li>
<li>Provides a method to remove a
	* component.</li>
<li>Provides a method to remove all components held by the
	* container.</li>
<li>Can check if a specific container is the ancestor of a
	* component.</li>
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
Getting the root
	* pane,removing all components from the root pane and adding a
	* component:
<p>
</p>

<pre>
ULCRootPane rootPane =
	* changePaneButton.getRootPane();
rootPane.removeAll();
rootPane.add(anotherPane)
	* ;
</pre>
	*
	* @ulc.application		
	* @see		ULCScrollPane
	* @see		ULCTabbedPane
	* @see		ULCSplitPane
	* @see		ULCBoxPane
	* @see		ULCGridBagLayoutPane
	* @see		ULCBoxLayoutPane
	* @see		ULCRootPane
	* @see		ULCGridLayoutPane
	* @see		ULCFlowLayoutPane
	* @see		ULCCardPane
	* @see		ULCBorderLayoutPane
	**/
 public  abstract class ULCContainer extends com.ulcjava.base.application.ULCComponent
{

	 protected ULCContainer()
	{
		 super();
	}


	/**
	* Returns true if this container is an ancestor of the provided component, false
	* otherwise. Note that this method returns false if the
provided component or
	* its parent is null.
	*
	* @param component 		 the component
	* @return		true if this container is an ancestor of the provided component, false otherwise
	**/
	 public boolean isAncestorOf(com.ulcjava.base.application.ULCComponent component)
	{
		return false;
	}


	/**
	* Equivalent to {@link #isAncestorOf(ULCComponent)} (old, mis-spelled version;
	* kept for API compatibility).
	*
	* @param component 		 the component
	* @return		true if this container is an ancestor of the provided component, false otherwise
	* @deprecated		use <code>isAncestorOf</code> instead
	**/
	 public boolean isAnchesterOf(com.ulcjava.base.application.ULCComponent component)
	{
		return false;
	}


	/**
	* Adds a component to the container. The default constraints for this container
	* are used.
	*
	* @param component 		 the content.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds a component to the container with the specified constraints.
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected com.ulcjava.base.application.ULCComponent addImpl(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected void removeFromParent(com.ulcjava.base.application.ULCComponent component)
	{
	}

	 protected void setParentOn(com.ulcjava.base.application.ULCComponent component)
	{
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}


	/**
	* Removes all components held by this <code>ULCContainer</code>.
	*
	**/
	 public void removeAll()
	{
	}


	/**
	* Removes the specified component from the pane.
	*
	* @param component 		 the component to be removed
	**/
	 public void remove(com.ulcjava.base.application.ULCComponent component)
	{
	}

	 protected void addNotify()
	{
	}

	 protected void removeNotify()
	{
	}


	/**
	* Returns all components held by this <code>ULCContainer</code>.
	*
	* @return		all components held by this <code>ULCContainer</code>.
	**/
	 public com.ulcjava.base.application.ULCComponent[] getComponents()
	{
		return null;
	}


	/**
	* Returns the number of the components held by this <code>ULCContainer</code>.
	*
	* @return		the number of the components held by this <code>ULCContainer</code>.
	**/
	 public int getComponentCount()
	{
		return 0;
	}


	/**
	* Sets the <code>ComponentOrientation</code> for this container and its
	* containedcomponents.
	*
	* @param componentOrientation 		 the new component orientation to set
	* @exception		NullPointerException if <code>componentOrientation</code> is null.
	* @see		ULCComponent#setComponentOrientation
	* @see		ULCComponent#getComponentOrientation
	**/
	 public void applyComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.Object getConstraintsImpl(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected void setConstraintsImpl(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
	}

	 protected int getComponentIndex(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the client-side default UI properties prefix.
	*
	* @return		the property prefix constant
	**/
	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.shared.internal.Anything internalConvertFromConstraints(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Implements the default constraints conversion mechanism used by {@link
	* #internalConvertFromConstraints(ULCComponent, Object)}.

Use this method to
	* overwrite any overwritten {@link
	* #internalConvertFromConstraints(ULCComponent,Object)} method in a subclass
in
	* order to re-install the default constraints conversion mechanism.
	*
	* @param constraints 		 the constraints to be converted
	* @return		an instance of Anything wrapping the constraints instance provided
	**/
	 protected com.ulcjava.base.shared.internal.Anything defaultInternalConvertFromConstraints(java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCContainerDispatcher extends ULCComponentDispatcher
{


}
}