package com.ulcjava.base.application;


	/**
	* A <code>ULCDialog</code> is a top-level window with a title and a border that
	* is typically used to collect some form of input from the
user.
<p>
</p>
A
	* dialog can have either a <code>ULCFrame</code> or a <code>ULCDialog</code>
	* defined as its owner when it's constructed. When the
owner window of a
	* visibledialog is hidden or minimized, the dialog will automatically be hidden
	* from the user. When the owner window is
subsequently re-opened, then the
	* dialog is made visible to the user again.
<p>
</p>
A dialog can be either
	* modeless (the default) or modal. A modal dialog is one which blocks input to
	* all other toplevel windows in the app
context, except for any windows created
	* with the dialog as their owner.
<p>
</p>
<b>Features</b>
<ul>
<li>A dialog is
	* a window that is dependent on another window. When the owner window is
	* destroyed, so are its dependent dialogs. When the
window is iconified, its
	* dependent dialogs disappear from the screen. When the owner window is
	* subsequently re-opened, then the dialog is
made visible to the user
	* again.
<li>By default, a dialog will be displayed at the location (0,0). When
	* the dialog is moved, closed and reopened, it is displayed at the
last
	* location. This default behavior can be overridden by explicitly setting the
	* location of the dialog using the
{@link
	* #setLocation(com.ulcjava.base.application.util.Point)} or {@link
	* #setLocationRelativeTo(ULCComponent)} methods.
<li>A dialog can be modal,
	* i.e., block input for all other application
	* windows.
</ul>
<b>Examples</b>
<p></p>
This creates a modal
	* <code>ULCDialog</code>, opening on top of the main application
	* window:

<pre>
ULCFrame mainFrame = new ULCFrame(&quot;Main
	* window&quot;);
ULCDialog modalDialog = new ULCDialog(mainFrame, // parent
	* window
&quot;Modal dialog&quot;, // title
true); // modal
modalDialog.add(new
	* ULCLabel(&quot;This dialog is
	* modal.&quot;));
mainFrame.setVisible(true);
modalDialog.setVisible(true);
</pre
	* >
	*
	* @ulc.application		
	* @see		ULCFrame
	* @see		ULCAlert
	* @see		ULCBoxPane
	* @see		com.ulcjava.base.application.event.WindowEvent
	* @see		ULCWindow#addWindowListener
	**/
 public class ULCDialog extends com.ulcjava.base.application.ULCWindow
{


	/**
	* Constructs a non-modal dialog with no title or parent component. A shared,
	* hidden container will be set as the owner of the dialog.
	*
	**/
	 public ULCDialog()
	{
		 super();
	}


	/**
	* Constructs a non-modal dialog with no title. The given window will be the
	* parent of this dialog.
	*
	* @param owner 		 the <code>ULCWindow</code> from which the dialog is displayed. <code>null</code> if the parent is instance of
<code>ULCAppletPane</code> or <code>RootPane</code>
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCWindow owner)
	{
		 super();
	}


	/**
	* Constructs a dialog with no title. The given window will be the parent of this
	* dialog.
	*
	* @param owner 		 the <code>ULCWindow</code> from which the dialog is displayed. <code>null</code> if the parent is instance of
<code>ULCAppletPane</code> or <code>RootPane</code>
	* @param modal 		 true for a modal dialog, false for one that allows others windows to be active at the same time
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCWindow owner, boolean modal)
	{
		 super();
	}


	/**
	* Constructs a non-modal dialog with the specified title. The given window will
	* be the parent of this dialog.
	*
	* @param owner 		 the <code>ULCWindow</code> from which the dialog is displayed. <code>null</code> if the parent is instance of
<code>ULCAppletPane</code> or <code>RootPane</code>
	* @param title 		 the <code>String</code> to display in the dialog's title bar
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCWindow owner, java.lang.String title)
	{
		 super();
	}


	/**
	* Constructs a dialog with the specified title. The given window will be the
	* parent of this dialog.
	*
	* @param owner 		 the <code>ULCWindow</code> from which the dialog is displayed.<code>null</code> if the parent is instance of
<code>ULCAppletPane</code> or <code>RootPane</code>
	* @param title 		 the <code>String</code> to display in the dialog's title bar
	* @param modal 		 true for a modal dialog, false for one that allows other windows to be active at the same time
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCWindow owner, java.lang.String title, boolean modal)
	{
		 super();
	}


	/**
	* Constructs a non-modal dialog with no title. The given root pane will be the
	* parent of this dialog if it is an instance of ULCWindow.
Otherwise the parent
	* window will be set to null.
	*
	* @param owner 		 the <code>ULCRootPane</code> from which the dialog is displayed
	* @deprecated		if owner is an instance of ULCWindow use ULCDialog((ULCWindow)) instead. Else use ULCDialog(null).
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCRootPane owner)
	{
		 super();
	}


	/**
	* Constructs a dialog with no title. The given root pane will be the parent of
	* this dialog if it is an instance of ULCWindow. Otherwise
the parent window
	* will be set to null.
	*
	* @param owner 		 the <code>ULCRootPane</code> from which the dialog is displayed
	* @param modal 		 true for a modal dialog, false for one that allows others windows to be active at the same time
	* @deprecated		if owner is an instance of ULCWindow use ULCDialog((ULCWindow) owner, modal) instead. Else use ULCDialog(null, modal).
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCRootPane owner, boolean modal)
	{
		 super();
	}


	/**
	* Constructs a non-modal dialog with the specified title. The given root pane
	* will be the parent of this dialog if it is an instance of
ULCWindow.
	* Otherwisethe parent window will be set to null.
	*
	* @param owner 		 the <code>ULCRootPane</code> from which the dialog is displayed
	* @param title 		 the <code>String</code> to display in the dialog's title bar
	* @deprecated		if owner is an instance of ULCWindow use ULCDialog((ULCWindow) owner, title) instead. Else use ULCDialog(null, title).
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCRootPane owner, java.lang.String title)
	{
		 super();
	}


	/**
	* Constructs a dialog with the specified title. The given root pane will be the
	* parent of this dialog if it is an instance of
ULCWindow. Otherwise the parent
	* window will be set to null.
	*
	* @param owner 		 the <code>ULCRootPane</code> from which the dialog is displayed
	* @param title 		 the <code>String</code> to display in the dialog's title bar
	* @param modal 		 true for a modal dialog, false for one that allows other windows to be active at the same time
	* @deprecated		if owner is an instance of ULCWindow use ULCDialog((ULCWindow) owner, title, modal) instead. Else use ULCDialog(null,
title, modal).
	**/
	 public ULCDialog(com.ulcjava.base.application.ULCRootPane owner, java.lang.String title, boolean modal)
	{
		 super();
	}


	/**
	* Returns true if the dialog is modal, flase otherwise. When a modal Dialog is
	* shown, all the other windows in the app context are
blocked, except for the
	* windows created with this dialog as their owner.
	*
	* @return		<code>true</code> if this dialog window is modal; <code>false</code> otherwise.
	* @see		#setModal
	**/
	 public boolean isModal()
	{
		return false;
	}


	/**
	* Returns true if this window can be resized by the user. By default, all
	* windowsare resizable.
	*
	* @return		<code>true</code> if the user can resize this window; <code>false</code> otherwise.
	* @see		#setResizable
	**/
	 public boolean isResizable()
	{
		return false;
	}


	/**
	* Sets whether this window's size can be changed by the user.
	*
	* @param resizable 		 <code>true</code> if this frame is resizable; <code>false</code> otherwise.
	* @see		#isResizable
	**/
	 public void setResizable(boolean resizable)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Choose whether this dialog should be modal.
	*
	* @param modal 		 true if the dialog should be modal, false otherwise
	* @throws		IllegalStateException if the dialog is currently visible
	* @see		#isModal
	**/
	 public void setModal(boolean modal)
	{
	}


	/**
	* Returns the dialog's title.
	*
	* @return		the title of this dialog, or an empty string ("") if this dialog doesn't have a title.
	* @see		#setTitle
	**/
	 public java.lang.String getTitle()
	{
		return null;
	}


	/**
	* Sets the title for this dialog.
	*
	* @param title 		 the title for this dialog
	* @see		#getTitle
	**/
	 public void setTitle(java.lang.String title)
	{
	}


	/**
	* Choose what should happen when the user closes this window. The following
	* options are available:
<ul>
<li>DO_NOTHING_ON_CLOSE Ignore the event;
	* requiresthe program to handle the operation in the <code>windowClosing</code>
	* method of
a registered <code>WindowListener</code> object.
<li>HIDE_ON_CLOSE
	* Hide the window after notifying all registered <code>WindowListener</code>
	* objects.
<li>DISPOSE_ON_CLOSE Hide and dispose the window after notifying all
	* registered <code>WindowListener</code> objects.
</ul>
<p>
</p>
The value is
	* set to HIDE_ON_CLOSE by default.
	*
	* @param operation 		 the operation which will happen by default when the user initiates a "close" on this dialog
	* @see		#getDefaultCloseOperation
	**/
	 public void setDefaultCloseOperation(int operation)
	{
	}


	/**
	* Returns the operation performed when the user closes this window.
	*
	* @return		an integer indicating the window-close operation
	* @see		#setDefaultCloseOperation
	**/
	 public int getDefaultCloseOperation()
	{
		return 0;
	}


	/**
	* Returns true if the dialog is undecorated, false otherwise.
	*
	* @return		the undecorated flag
	**/
	 public boolean isUndecorated()
	{
		return false;
	}


	/**
	* Sets the undecorated property to disable or enable decorations for this
	* dialog.This property can only be set while the dialog is not
displayable.
	*
	* @param undecorated 		 <code>true</code> if no frame decorations are to be enabled, <code>false</code> otherwise
	* @throws		IllegalStateException if the dialog is displayable.
	* @see		#isUndecorated
	* @see		ULCWindow#isDisplayable
	**/
	 public void setUndecorated(boolean undecorated)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCDialogDispatcher extends ULCWindowDispatcher
{


}
}