package com.ulcjava.base.application;


	/**
	* The <code>ULCFlowLayoutPane</code> aligns components in a left-to-right flow,
	* much like lines of text in a paragraph.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* components added to the <code>ULCFlowLayoutPane</code> can be aligned to the
	* left, right, or center by a corresponding
constructor constant:
	* <code>LEFT</code>, <code>CENTER</code>, and <code>RIGHT</code>.
<li>This
	* <code>ULCFlowLayoutPane</code> lets each contained component assume its
	* natural (preferred) size.
</ul>
<b>Examples</b>
<p>
</p>
The following code
	* snippet shows how two add components to a <code>ULCFlowLayoutPane</code>,
	* specifying that the 3 buttons will be
added from left to right and aligned in
	* the center (default) of the pane.

<pre>
ULCFlowLayoutPane flowLayoutPane =
	* new ULCFlowLayoutPane();
flowLayoutPane.add(new
	* ULCButton(&quot;1&quot;));
flowLayoutPane.add(new
	* ULCButton(&quot;2&quot;));
flowLayoutPane.add(new
	* ULCButton(&quot;3&quot;));
</pre>
	*
	* @ulc.application		
	**/
 public class ULCFlowLayoutPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* This value indicates that each row of components should be left-justified.
	*
	**/
	 public  final  static int LEFT = 0;

	/**
	* This value indicates that each row of components should be centered.
	*
	**/
	 public  final  static int CENTER = 0;

	/**
	* This value indicates that each row of components should be right-justified.
	*
	**/
	 public  final  static int RIGHT = 0;


	/**
	* Creates a new <code>ULCFlowLayoutPane</code> instance with a centered alignment.
	*
	**/
	 public ULCFlowLayoutPane()
	{
		 super();
	}


	/**
	* Creates a new <code>ULCFlowLayoutPane</code> instance with the specified
	* alignment.
	*
	* @param alignment 		 the alignment
	**/
	 public ULCFlowLayoutPane(int alignment)
	{
		 super();
	}


	/**
	* Creates a new instance with the specified alignment and horizontal and
	* verticalgap. The value of the <code>alignment</code>
argument must be one of
	* the following five values: <code>LEFT</code>, <code>RIGHT</code>,
	* <code>CENTER</code>,
<code>LEADING</code>, <code>TRAILING</code>.
	*
	* @param alignment 		 the alignment value
	* @param hgap 		 the horizontal gap
	* @param vgap 		 the vertical gap
	* @throws		IllegalArgumentException thrown if the value of <code>alignment</code> is not allowed
	**/
	 public ULCFlowLayoutPane(int alignment, int hgap, int vgap)
	{
		 super();
	}


	/**
	* Adds a ULCComponent to this container at the index position.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index position where to component will be added
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}


	/**
	* Adds a component to the container with the specified constraints.
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints, must be an Integer.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Returns the horizontal gap.
	*
	* @return		the horizontal gap
	**/
	 public int getHgap()
	{
		return 0;
	}


	/**
	* Sets the horizontal gap.
	*
	* @param horizontalGap 		 the horizontal gap
	**/
	 public void setHgap(int horizontalGap)
	{
	}


	/**
	* Returns the vertical gap.
	*
	* @return		the vertical gap
	**/
	 public int getVgap()
	{
		return 0;
	}


	/**
	* Sets the vertical gap.
	*
	* @param verticalGap 		 the vertical gap
	**/
	 public void setVgap(int verticalGap)
	{
	}


	/**
	* Gets the alignment used in this pane.
	*
	* @return		the alignment value
	**/
	 public int getAlignment()
	{
		return 0;
	}


	/**
	* Sets the alignment used in this pane. The value of the <code>alignment</code>
	* argument must be one of the following five values:
<code>LEFT</code>,
	* <code>RIGHT</code>, <code>CENTER</code>, <code>LEADING</code>,
	* <code>TRAILING</code>.
	*
	* @param alignment 		 the alignment value
	* @throws		IllegalArgumentException thrown if the value of <code>alignment</code> is not allowed
	**/
	 public void setAlignment(int alignment)
	{
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCFlowLayoutPaneDispatcher extends ULCContainerDispatcher
{


}
}