package com.ulcjava.base.application;


	/**
	* The <code>ULCGridBagLayoutPane</code> aligns widgets according to the concept
	* of Swing's <code>GridBagLayout</code>. It provides
most flexibility and
	* allowsfor complex GUIs. ULC's <code>ULCGridBagLayoutPane</code> is analogous
	* to Swing's
<code>GridBagLayout</code>.
<ul>
<li>The
	* <code>ULCGridBagLayoutPane</code> class aligns components vertically and
	* horizontally, without requiring that the components
be of the same size. Each
	* <code>ULCGridBagLayoutPane</code> object maintains a dynamic rectangular grid
	* of cells, with each component
occupying one or more cells, called its
	* <em>display area</em>.
<li>Each component managed by a
	* <code>ULCGridBagLayoutPane</code> is associated with an instance of {@link
	* GridBagConstraints} that
specifies how the component is laid out within its
	* display area.
<li> How a <code>ULCGridBagLayoutPane</code> object places a
	* setof components depends on the <code>GridBagConstraints</code>
	* object
associated with each component, and on the minimum size and the
	* preferred size of the components' containers.
<li>To use the
	* <code>ULCGridBagLayoutPane</code> effectively, you must customize one or more
	* of the <code>GridBagConstraints</code>
objects that are associated with its
	* components.
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
The following code
	* snippetshows how to add a component to a <code>ULCGridBagLayoutPane</code>,
	* specifying that the button be placed
in the cell at column 0, row 0, with row
	* weight 1, column weight 0, expanding vertically, and sticking to the left of
	* the surrounding
cell.
<p>
</p>

<pre>
ULCGridBagLayoutPane gridBagLayoutPane
	* =new ULCGridBagLayoutPane();
GridBagConstraints constraints = new
	* GridBagConstraints();
ULCButton bt1 = new
	* ULCButton(&quot;1&quot;);
constraints.fGridx = 0;
constraints.fGridy =
	* 0;
constraints.fWeightx = 0;
constraints.fWeighty = 1;
constraints.fFill =
	* GridBagConstraints.VERTICAL;
constraints.fAnchor =
	* GridBagConstraints.EAST;
gridBagLayoutPane.setConstraints(bt1,
	* constraints);
gridBagLayoutPane.add(bt1);
</pre>
	*
	* @ulc.application		
	* @see		GridBagConstraints
	**/
 public class ULCGridBagLayoutPane extends com.ulcjava.base.application.ULCContainer implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a new <code>ULCGridBagLayoutPane</code> instance.
	*
	**/
	 public ULCGridBagLayoutPane()
	{
		 super();
	}


	/**
	* Gets the constraints for the specified component in this grid bag layout pane.
	* A copy of the actual <code>GridBagConstraints</code>
object is returned.
	*
	* @param component 		 the component to be queried
	* @return		a copy of the constraints for the specified component in this grid bag layout pane or null if the component is not part of
this pane
	**/
	 public com.ulcjava.base.application.GridBagConstraints getConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Sets the constraints for the specified component in this grid bag layout pane.
	*
	* @param component 		 the component to be modified
	* @param constraints 		 the constraints to be applied
	**/
	 public void setConstraints(com.ulcjava.base.application.ULCComponent component, com.ulcjava.base.application.GridBagConstraints constraints)
	{
	}


	/**
	* Adds the specified component to this grid bag layout pane, applying the
	* specified constraints.
	*
	* @param component 		 the component to be added
	* @param constraints 		 the constraints to be applied
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, com.ulcjava.base.application.GridBagConstraints constraints)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
<p/>
<b>Note:</b> this implementation is still based on the deprecated constraints conversion mechanism for backward
compatibility. In order to install the new {@link com.ulcjava.base.shared.IStreamCoder}-based conversion mechanism
in a subclass of this container, overwrite this method and therein, invoke {@link #defaultInternalConvertFromConstraints(Object)}.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.shared.internal.Anything internalConvertFromConstraints(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromGridBagConstraints(com.ulcjava.base.application.GridBagConstraints constraints)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCGridBagLayoutPaneDispatcher extends ULCContainerDispatcher
{


}
}