package com.ulcjava.base.application;


	/**
	* The <code>ULCHtmlPane</code> component visualizes HTML that is either passed
	* asa text parameter or retrieved from a specified
	* URL.
<p>
</p>
<b>Features</b><ul>
<li>The <code>ULCHtmlPane</code> component
	* inherits all features from <code>ULCComponent</code>.
<li>The
	* <code>ULCHtmlPane</code> renders and displays HTML text. The HTML code can
	* either be passed directly on the component (i.e.,
the developer passes the
	* HTML source text as a parameter) or a URL can be specified as the content
	* source.
<li>The application can install an <code>IHyperlinkListener</code> to
	* be notified about hyperlink selections by the user (and errors,
i.e.,
	* selection of invalid or broken hyperlinks).
<li>If the veto property is set
	* totrue, the pane does not automatically load the new URL but merely notifies
	* the application about the
hyperlink selection. It is the application's
	* responsibility to decide if the URL should be set as the new content
	* source.
</ul>
<b>Examples</b>
<p>
</p>
The following example shows how to set
	* up a <code>ULCHtmlPane</code> component and use the veto property to check
	* theURL before the
corresponding contents are displayed in the HTML
	* pane.

<pre>
ULCHtmlPane htmlPane = new
	* ULCHtmlPane(&quot;http://www.acme.com&quot;);
htmlPane.setVeto(true);
htmlPane.
	* addHyperlinkListener(new IHyperlinkListener() {
public void
	* linkActivated(HyperlinkEvent event) {
ULCHtmlPane source =
	* (ULCHtmlPane)event.getSource();
source.setPage(event.getUrlString());
}

public
	* void linkError(HyperlinkEvent event) {
System.out.println(&quot;link error:
	* &quot; + event.getErrorString());
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	**/
 public class ULCHtmlPane extends com.ulcjava.base.application.ULCComponent
{


	/**
	* Constructs a new HTML pane.
	*
	**/
	 public ULCHtmlPane()
	{
		 super();
	}


	/**
	* Constructs a new HTML pane displaying the specified URL.
	*
	* @param page 		 the URL
	**/
	 public ULCHtmlPane(java.lang.String page)
	{
		 super();
	}


	/**
	* Adds a hyperlink listener for notification of any changes, for example when a
	* link is selected and entered.
	*
	* @param listener 		 the listener
	**/
	 public void addHyperlinkListener(com.ulcjava.base.application.event.IHyperlinkListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IHyperlinkListener</code>s added to this
	* <code>ULCHtmlPane</code> with
<code>addHyperlinkListener()</code>.
	*
	* @return		all <code>IHyperlinkListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IHyperlinkListener[] getHyperlinkListeners()
	{
		return null;
	}


	/**
	* Gets the current URL being displayed as string. If a URL was not specified in
	* the creation of the document, this will return
<code>null</code>, and
	* relativeURL's will not be resolved.
	*
	* @return		the URL as string, or <code>null</code> if none
	**/
	 public java.lang.String getPage()
	{
		return null;
	}


	/**
	* Returns the veto flag which results in every hyperlink selection to be passed
	* to the application for confirmation. The application
must call
	* <code>setPage</code> to activate the page if <code>veto</code> is true
	*
	* @return		veto If true, then all hyperlinks selected will be sent to the ULC application for confirmation.
	**/
	 public boolean getVeto()
	{
		return false;
	}


	/**
	* Removes a hyperlink listener.
	*
	* @param listener 		 the listener
	**/
	 public void removeHyperlinkListener(com.ulcjava.base.application.event.IHyperlinkListener listener)
	{
	}


	/**
	* Fires a link activated event.
	*
	* @param hyperlinkEvent 		 the hyperlink event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireLinkActivated(com.ulcjava.base.application.event.HyperlinkEvent hyperlinkEvent)
	{
	}


	/**
	* Fires a link error event.
	*
	* @param hyperlinkEvent 		 the hyperlink event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireLinkError(com.ulcjava.base.application.event.HyperlinkEvent hyperlinkEvent)
	{
	}


	/**
	* Creates a hyperlink event from the given arguments.
<p>
</p>
<b>Note:</b> This
	* method will be called as part of a client-initiated event firing.
</p>
	*
	* @param description 		 the description of the hyperlink event
	* @param error 		 the error of the hyperlink event
	* @return		a hyperlink event with this <code>ULCHtmlPane</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.HyperlinkEvent createHyperlinkEvent(java.lang.String urlAsString, java.lang.String description, java.lang.String error)
	{
		return null;
	}


	/**
	* Dispatches a hyperlink event to registered listeners via {@link
	* #dispatchEvent(String, String, java.util.EventObject)}. Extension
writers may
	* override this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing.
</p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#HYPERLINK_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @ulc.extension		
	* @see		#dispatchEvent(String, String, java.util.EventObject)
	**/
	 protected void processHyperlinkEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.HyperlinkEvent eventObject)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Sets the current URL being displayed. Exceptions are reported to the hyperlink
	* listeners with help of the linkError method.
	*
	* @param page 		 the URL for display
	**/
	 public void setPage(java.lang.String page)
	{
	}


	/**
	* Sets the text of this TextComponent to the specified text. If the text is null
	* or empty, this has the effect of simply deleting the
old text.
	*
	* @param text 		 the new text to be set
	**/
	 public void setText(java.lang.String text)
	{
	}


	/**
	* Sets the veto flag which results in every hyperlink selection to be passed to
	* the application for confirmation. The application must
call
	* <code>setPage</code> to activate the page if <code>veto</code> is true
	*
	* @param veto 		 If true, then all hyperlinks selected will be sent to the ULC application for confirmation.
	**/
	 public void setVeto(boolean veto)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#HYPERLINK_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IHyperlinkListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getHyperlinkListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCHtmlPaneDispatcher extends ULCComponentDispatcher
{

	 public  final com.ulcjava.base.application.event.HyperlinkEvent createHyperlinkEvent(java.lang.String urlAsString, java.lang.String description, java.lang.String error)
	{
		return null;
	}

	 public  final void processHyperlinkEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.HyperlinkEvent eventObject)
	{
	}

	 public  final java.lang.Class getHyperlinkListenerClass()
	{
		return null;
	}


}
}