package com.ulcjava.base.application;


	/**
	* The <code>ULCLabel</code> class provides a display area for a text string, an
	* icon, or both.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCLabel</code>
	* component inherits all features from <code>ULCComponent</code>.
<li>A
	* <code>ULCLabel</code> instance displays a text and/or an icon (a separate
	* iconcan be specified for the disabled state).
<li>Use
	* <code>HTMLUtilities</code> to set multiline text on the
	* <code>ULCLabel</code>.<li>Horizontal and vertical alignment properties can be
	* used to align text and icon.
<li>An <code>IDataType</code> object can be used
	* to format non-textual values that should be displayed in the label
	* (e.g.,
<code>ULCDateDataType</code>).
<li>ULCLabel offers a possibility to
	* associate it with another component with <code>setLabelFor()</code> API. One
	* can set a mnemonic for
a label with <code>setDisplayMnemonic()</code> and
	* alsospecify the index of a character in the label text for mnemonic
	* decorationwith
<code>setDisplayMnemonicIndex()</code>. When a user presses
	* Alt-"keycode" where "keycode" is a mnemonic associated with the label,
	* the
component chosen with <code>setLabelFor()</code> will receive the
	* focus.
</ul>
<b>Examples</b>
<p>
</p>
To set the icon and the alignment
	* properties, see the following examples:
<p>
</p>

<pre>
ULCLabel label = new
	* ULCLabel(&quot;ULCLabel&quot;);
label.setIcon(icon);
label.setDisabledIcon(disa
	* bledIcon);
label.setHorizontalAlignment(ULCLabel.LEFT);
label.setHorizontalTextP
	* osition(ULCLabel.LEFT);
label.setVerticalAlignment(ULCLabel.TOP);
label.setVerti
	* calTextPosition(ULCLabel.TOP);
</pre>
<p>
</p>
The following code snippet
	* showsan example of using a <code>ULCLabel</code> with an
	* <code>IDataType</code> object
	* (
<code>ULCDateDataType</code>).
<p>
</p>

<pre>label.setDataType(new
	* ULCDateDataType(&quot;dd.MM.yyyy&quot;));
label.setValue(new Date());
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCIcon
	* @see		com.ulcjava.base.application.util.HTMLUtilities
	**/
 public class ULCLabel extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.application.IRendererComponent, com.ulcjava.base.server.dnd.IDnDComponent, com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a <code>ULCLabel</code> with the specified text, icon, and horizontal
	* alignment. The label is centered vertically in its
display area. The text is
	* on the trailing edge of the icon.
<p/>
The alignment can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @param text 		 the text to be displayed
	* @param icon 		 the icon to be displayed
	* @param horizontalAlignment 		 the horizontal alignment
	**/
	 public ULCLabel(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, int horizontalAlignment)
	{
		 super();
	}


	/**
	* Creates a <code>ULCLabel</code> with the specified text and horizontal
	* alignment. The label is centered vertically in its display
area.
<p/>
The
	* alignment can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @param text 		 the text to be displayed by the label.
	* @param horizontalAlignment 		 the horizontal alignment
	**/
	 public ULCLabel(java.lang.String text, int horizontalAlignment)
	{
		 super();
	}


	/**
	* Creates a <code>ULCLabel</code> with the specified text. The label is aligned
	* against the leading edge of its display area, and
centered vertically.
	*
	* @param text 		 The text to be displayed by the label.
	**/
	 public ULCLabel(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a <code>ULCLabel</code> with the specified icon and horizontal
	* alignment. The label is centered vertically in its display
area.
<p/>
The
	* alignment can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @param icon 		 The icon to be displayed by the label.
	* @param horizontalAlignment 		 the horizontal alignment
	**/
	 public ULCLabel(com.ulcjava.base.application.util.ULCIcon icon, int horizontalAlignment)
	{
		 super();
	}


	/**
	* Creates a <code>ULCLabel</code> with the specified icon. The label is centered
	* vertically and horizontally in its display area.
	*
	* @param icon 		 The icon to be displayed by the label.
	**/
	 public ULCLabel(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a <code>ULCLabel</code> with no icon and with an empty string for the
	* title. The label is centered vertically in its display
area. The label's
	* contents (text and/or icon) will be displayed on the leading edge of the
	* label's display area.
	*
	**/
	 public ULCLabel()
	{
		 super();
	}


	/**
	* Returns the data type.
	*
	* @return		the data type
	**/
	 public com.ulcjava.base.application.datatype.IDataType getDataType()
	{
		return null;
	}


	/**
	* Returns the disabled icon.
	*
	* @return		the disabled icon.
	* @see		#setDisabledIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getDisabledIcon()
	{
		return null;
	}


	/**
	* Returns the icon that the label displays.
	*
	* @return		a <code>ULCIcon</code>
	* @see		#setIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getIcon()
	{
		return null;
	}


	/**
	* Returns the amount of space between the text and the icon displayed in this
	* label.
	*
	* @return		the number of pixels between the text and the icon.
	* @see		#setIconTextGap
	**/
	 public int getIconTextGap()
	{
		return 0;
	}


	/**
	* Returns the text string that the label displays.
	*
	* @return		a <code>String</code>
	* @see		#setText
	**/
	 public java.lang.String getText()
	{
		return null;
	}


	/**
	* Returns the value displayed by this label. This API can return basic data
	* typesfrom the UI (e.g., <code>Boolean</code>,
<code>Date</code>,
	* <code>Long</code> etc) if this field is associated with an
	* <code>IDataType</code> (using the
{@link #setDataType(IDataType) setDataType}
	* method) that supports the type.
<p>
</p>
For
	* example:
<p>
</p>

<pre>
label.setDataType(new
	* ULCDateDataType());
label.setValue(new Date());
Date date =
	* (Date)label.getValue();
</pre>
	*
	* @return		the value contained in this label
	* @see		IDataType
	* @see		#getDataType
	* @see		#getText
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the data type.
	*
	* @param dataType 		 the data type
	* @see		#getValue
	* @see		IDataType
	* @see		com.ulcjava.base.application.datatype.ULCDateDataType
	* @see		com.ulcjava.base.application.datatype.ULCPercentDataType
	* @see		com.ulcjava.base.application.datatype.ULCNumberDataType
	* @see		com.ulcjava.base.application.datatype.ULCRegularExpressionDataType
	* @see		com.ulcjava.base.application.datatype.ULCStringDataType
	**/
	 public void setDataType(com.ulcjava.base.application.datatype.IDataType dataType)
	{
	}


	/**
	* Set the icon to be displayed if this <code>ULCLabel</code> is "disabled"
	* (ULCLabel.setEnabled(false)).
	*
	* @param disabledIcon 		 the icon to display when the component is disabled
	* @see		#getDisabledIcon
	* @see		#setEnabled
	**/
	 public void setDisabledIcon(com.ulcjava.base.application.util.ULCIcon disabledIcon)
	{
	}


	/**
	* Returns the alignment of the label's contents along the X axis.
<p/>
The
	* alignment can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @return		The value of the horizontalAlignment property
	* @see		#setHorizontalAlignment
	**/
	 public int getHorizontalAlignment()
	{
		return 0;
	}


	/**
	* Returns the alignment of the label's contents along the Y axis.
<p/>
The
	* alignment can be one of the
	* following:
<ul>
<li><code>TOP</code>,
<li><code>CENTER</code>,
<li><code>BOTTOM
	* </code>,
</ul>
	*
	* @return		the value of the verticalAlignment property
	* @see		#setVerticalAlignment
	**/
	 public int getVerticalAlignment()
	{
		return 0;
	}


	/**
	* Returns the horizontal position of the label's text, relative to its
	* icon.
<p/>The position can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @return		the horizontal text position
	* @see		#setHorizontalTextPosition
	**/
	 public int getHorizontalTextPosition()
	{
		return 0;
	}


	/**
	* Returns the vertical position of the label's text, relative to its
	* icon.
<p/>
The alignment can be one of the
	* following:
<ul>
<li><code>TOP</code>,
<li><code>CENTER</code>,
<li><code>BOTTOM
	* </code>,
</ul>
	*
	* @return		the vertical text position
	* @see		#setVerticalTextPosition
	**/
	 public int getVerticalTextPosition()
	{
		return 0;
	}


	/**
	* Sets the alignment of the label's contents along the X axis.
<p/>
The
	* alignmentcan be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @param alignment 		 the horizontal alignment
	* @see		#getHorizontalAlignment
	**/
	 public void setHorizontalAlignment(int alignment)
	{
	}


	/**
	* Sets the alignment of the label's contents along the Y axis.
<p/>
The
	* alignmentcan be one of the
	* following:
<ul>
<li><code>TOP</code>,
<li><code>CENTER</code>,
<li><code>BOTTOM
	* </code>,
</ul>
	*
	* @param alignment 		 the vertical alignment
	* @see		#getVerticalAlignment
	**/
	 public void setVerticalAlignment(int alignment)
	{
	}


	/**
	* Sets the horizontal position of the label's text, relative to its
	* icon.
<p/>
The alignment can be one of the
	* following:
<ul>
<li><code>LEFT</code>,
<li><code>CENTER</code>,
<li><code>RIGHT
	* </code>,
<li><code>LEADING</code> or
<li><code>TRAILING</code>.
</ul>
	*
	* @param textPosition 		 the horizontal text poition
	* @see		#getHorizontalTextPosition
	**/
	 public void setHorizontalTextPosition(int textPosition)
	{
	}


	/**
	* Sets the vertical position of the label's text, relative to its icon.
<p/>
The
	* alignment can be one of the
	* following:
<ul>
<li><code>TOP</code>,
<li><code>CENTER</code>,
<li><code>BOTTOM
	* </code>,
</ul>
	*
	* @param textPosition 		 the vertical text position
	* @see		#getVerticalTextPosition
	**/
	 public void setVerticalTextPosition(int textPosition)
	{
	}


	/**
	* Defines the icon that the label will display. If <code>icon</code> is
	* <code>null</code>, nothing is displayed.
	*
	* @param icon 		 the icon this label will display
	* @see		#setVerticalTextPosition
	* @see		#setHorizontalTextPosition
	* @see		#getIcon
	**/
	 public void setIcon(com.ulcjava.base.application.util.ULCIcon icon)
	{
	}


	/**
	* Defines the space between icon and text, if both are defined.
<p/>
The default
	* value of this property is 4 pixels.
	*
	* @param iconTextGap 		 the number of pixels between the text and the icon.
	* @see		#getIconTextGap
	**/
	 public void setIconTextGap(int iconTextGap)
	{
	}


	/**
	* Defines the single line of text this label will display. If <code>text</code>
	* is <code>null</code> or the empty string, nothing is
displayed.
	*
	* @param text 		 the (single line of) text this label will display
	* @see		#setVerticalTextPosition
	* @see		#setHorizontalTextPosition
	* @see		#setIcon
	**/
	 public void setText(java.lang.String text)
	{
	}


	/**
	* This API allows passing basic data types to the UI (e.g.,
	* <code>Boolean</code>,<code>Date</code>, <code>Long</code> etc). The value
(if
	* edited in the UI) will also be of the same type if this field is associated
	* with a <code>IDataType</code> (using the
{@link #setDataType(IDataType)
	* setDataType} method) that supports the type passed.
<p/>
For
	* example:
<p>
</p>
<pre>
label.setDataType(new
	* ULCDateDataType());
label.setValue(new Date());
Date d =
	* (Date)label.getValue();
</pre>
	*
	* @param value 		 the new value to be set
	* @see		IDataType
	* @see		#setDataType
	* @see		#setText
	**/
	 public void setValue(java.lang.Object value)
	{
	}


	/**
	* Returns whether the label's text is visible (provided the label itself is
	* visible as well). By default, the text is visible.
	*
	* @return		<code>true</code>, if the text is visible, false otherwise
	**/
	 public boolean isTextVisible()
	{
		return false;
	}


	/**
	* Shows or hides the label's text as specified by <code>textVisible</code>. By
	* default, the text is visible. This method should be used
when using
	* <code>ULCLabel</code> as an <code>IRendererComponent</code> that should
	* display only an icon.
	*
	* @param textVisible 		 if <code>true</code>, show the text, otherwise, hide the text
	**/
	 public void setTextVisible(boolean textVisible)
	{
	}


	/**
	* Get the component this is label is attached to.
	*
	* @return		the ULCComponent this is labelling. Can be null if this does not label a Component. If the displayedMnemonic property is set
and the labelFor property is also set, the label will call the requestFocus method of the component specified by the labelFor
property when the mnemonic is activated.
	* @see		#getDisplayedMnemonic
	* @see		#setDisplayedMnemonic
	**/
	 public com.ulcjava.base.application.ULCComponent getLabelFor()
	{
		return null;
	}


	/**
	* Set the <code>ULCComponent</code> this label should be attached to. Can be
	* nullif this does not label a ULCComponent. If the
displayedMnemonic property
	* is set and the labelFor property is also set, the label will call the
	* requestFocus method of the component
specified by the labelFor property when
	* the mnemonic is activated.
	*
	* @param component 		 the <code>ULCComponent</code> this label is for, or null if the label is not attached to a component
	* @see		#getDisplayedMnemonic
	* @see		#setDisplayedMnemonic
	**/
	 public void setLabelFor(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Specify a keycode that indicates a mnemonic key. This property is used when
	* thelabel is part of a larger component. If the labelFor
property of the label
	* is not null, the label will call the requestFocus method of the component
	* specified by the labelFor property
when the mnemonic is activated.
	*
	* @param key 		 the keycode for a mnemonic key
	* @see		#getLabelFor
	* @see		#setLabelFor
	**/
	 public void setDisplayedMnemonic(int key)
	{
	}


	/**
	* Specifies the displayedMnemonic as a char value.
	*
	* @param aChar 		 a char specifying the mnemonic to display
	* @see		#setDisplayedMnemonic(int)
	**/
	 public void setDisplayedMnemonic(char aChar)
	{
	}


	/**
	* Return the keycode that indicates a mnemonic key. This property is used when
	* the label is part of a larger component. If the labelFor
property of the
	* labelis not null, the label will call the requestFocus method of the
	* componentspecified by the labelFor property
when the mnemonic is activated.
	*
	* @return		int value for the mnemonic key
	* @see		#getLabelFor
	* @see		#setLabelFor
	**/
	 public int getDisplayedMnemonic()
	{
		return 0;
	}


	/**
	* Sets the index of the character from the label text that should be decorated
	* bylook and feel as the mnemonic. This property is look
and feel dependent.
	* Usethis method when the default character should not be underlined. A value
	* of-1 indicates one of the
following:
<ul>
<li>there is no mnemonic
<li>the
	* mnemonic character is not part of label text
<li>do not display the
	* mnemonic
</ul>
	*
	* @param mnemonicIndex 		 Index of the char in label text that should be underlined
	* @exception		IllegalArgumentException when <code>index</code> is out of bounds of the label text
	**/
	 public void setDisplayedMnemonicIndex(int mnemonicIndex)throws java.lang.IllegalArgumentException
	{
	}


	/**
	* Returns index of the character that should be decorated by look and feel as a
	* mnemonic.
	*
	* @return		index corresponding to the mnemonic character
	* @see		#setDisplayedMnemonicIndex
	**/
	 public int getDisplayedMnemonicIndex()
	{
		return 0;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public void copyAttributes(com.ulcjava.base.server.ICellComponent source)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public boolean areAttributesEqual(com.ulcjava.base.server.ICellComponent component)
	{
		return false;
	}

	 public int attributesHashCode()
	{
		return 0;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}


	/**
	* Returns the transfer handler.
	*
	* @return		the instance of TransferHandler
	**/
	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCLabelDispatcher extends ULCComponentDispatcher
{


}
}