package com.ulcjava.base.application;


	/**
	* The <code>ULCList</code> class displays a list of items. To make the list
	* scrollable, it has to be in a
	* <code>ULCScrollPane</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCList</code> component inherits all features of
	* <code>ULCComponent</code>.</li>
<li>The list of items presented by the list
	* isprovided by an <code>IListModel</code> which must be implemented by the
	* developer.</li>
<li>Setting the visible row count specifies how many rows of
	* the list are visible.</li>
<li>In order to allow special rendering of list
	* cells, an implementation of the <code>IListCellRenderer</code> interface can
	* be
provided which returns ULC widgets to render requested cells.</li>
<li>The
	* application can register <code>ISelectionSelectionListener</code>s to be
	* notified about selection changes. Moreover, the
application can use methods
	* toretrieve and change the current selection on the list. The selection mode
	* can be specified as one of the
following (all defined in
	* <code>ULCListSelectionModel</code>):
	* <code>SINGLE_SELECTION</code>,
<code>SINGLE_INTERVAL_SELECTION</code>, or
	* <code>MULTIPLE_INTERVAL_SELECTION</code>.</li>
<li>Registration of
	* <code>IActionListener</code>s allows tracking of action events fired by the
	* list (i.e., double clicks on a cell
or pressing the &lt;ENTER&gt;
	* key).</li>
<li>The <code>ULCList</code> transparently supports lazy loading
	* ofdata. Only the data of the currently visible rows are uploaded to
the
	* client.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example creates a
	* list with items taken from <code>MyListModel</code>. To display all items
	* horizontally centered, we
configure a <code>ULCLabel</code> accordingly and
	* return it as a cell renderer of the list.

<pre>
final ULCList list = new
	* ULCList(new MyListModel());
class MyCenteringRenderer extends
	* DefaultListCellRenderer {
public MyCenteringRenderer()
	* {
setHorizontalAlignment(ULCLabel.CENTER);
}
}
list.setCellRenderer(new
	* MyCenteringRenderer());
</pre>

Set the visible list rows to 10 and put the
	* list into a scroll pane:

<pre>
list.setVisibleRowCount(10);
ULCScrollPane
	* scrollPane = new ULCScrollPane(list);
</pre>

To select a row and ensure that
	* this row is
	* visible

<pre>
list.setSelectedIndex(70);
list.ensureIndexIsVisible(70);
</pre>
	* The following example configures the selection properties of the list and
	* installs a selection changed
	* listener.

<pre>
list.setSelectionMode(ULCListSelectionModel.SINGLE_SELECTION);
	* list.setSelectionBackground(Color.red);
list.setSelectionForeground(Color.blue)
	* ;
list.addListSelectionListener(new IListSelectionListener() {
public void
	* valueChanged(ListSelectionEvent event) {
ULCListSelectionModel source =
	* (ULCListSelectionModel)event
.getSource();
System.out.println(&quot;selection
	* changed: &quot;
+ source.getMinSelectionIndex());
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCListSelectionModel
	* @see		IListModel
	* @see		IListCellRenderer
	* @see		com.ulcjava.base.application.event.IListSelectionListener
	**/
 public class ULCList extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.server.dnd.IDnDComponent
{

	 protected com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}

	 protected void requestCellRendererComponents(int[] range)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Adds a listener for action events. An action event is generated, when user
	* double-clicks or hits enter key on an item.
	*
	* @param listener 		 the action listener to add
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns the action command for this list.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCList</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IListSelectionListener</code>s added to this
	* <code>ULCList</code> with
<code>addListSelectionListener()</code>.
	*
	* @return		all <code>IListSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IListSelectionListener[] getListSelectionListeners()
	{
		return null;
	}


	/**
	* Removes a listener for action events.
	*
	* @param listener 		 the action listener to remove
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Sets the action command property for this list.
	*
	* @param actionCommand 		 the action command for the list
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Constructs a <code>ULCList</code> with an empty model.
	*
	**/
	 public ULCList()
	{
		 super();
	}


	/**
	* Constructs a <code>ULCList</code> that displays the elements in the specified,
	* non-null model. All <code>ULCList</code>
constructors delegate to this one.
	*
	* @param model 		 the data model for this list
	* @throws		IllegalArgumentException if <code>dataModel</code> is <code>null</code>
	**/
	 public ULCList(com.ulcjava.base.application.IListModel model)
	{
		 super();
	}


	/**
	* Constructs a <code>ULCList</code> that displays the elements in the specified
	* array. This constructor just delegates to the
<code>IListModel</code>
	* constructor.
	*
	* @param listData 		 the array of <code>Objects</code> to be loaded into the data model
	**/
	 public ULCList(java.lang.Object[] listData)
	{
		 super();
	}


	/**
	* Constructs a <code>ULCList</code> that displays the elements in the specified
	* <code>List</code>. This constructor just delegates
to the
	* <code>IListModel</code> constructor.
	*
	* @param listData 		 the <code>List</code> to be loaded into the data model
	**/
	 public ULCList(java.util.List listData)
	{
		 super();
	}


	/**
	* Adds a listener for list selection events.
	*
	* @param listener 		 the list selection listener to add
	**/
	 public void addListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Adds the rows from <code>index0</code> to <code>index1</code>, inclusive, to
	* the current selection.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void addSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Deselects all selected rows.
	*
	**/
	 public void clearSelection()
	{
	}

	 protected com.ulcjava.base.application.ULCListSelectionModel createSelectionModel()
	{
		return null;
	}


	/**
	* Scrolls the list so that row at the specified index is visible.
	*
	* @param index 		 the index of the row to make visible
	**/
	 public void ensureIndexIsVisible(int index)
	{
	}


	/**
	* Returns the current list cell renderer.
<p>
</p>
<b>Note:</b> Returns null if
	* no custom renderer is installed.
	*
	* @return		the current list cell renderer, or null if no custom renderer is installed
	**/
	 public com.ulcjava.base.application.IListCellRenderer getCellRenderer()
	{
		return null;
	}


	/**
	* Returns the fixed cell height value.
	*
	* @return		the fixed cell height, in pixels
	**/
	 public int getFixedCellHeight()
	{
		return 0;
	}


	/**
	* Returns the fixed cell width value.
	*
	* @return		the fixed cell width, in pixels
	**/
	 public int getFixedCellWidth()
	{
		return 0;
	}


	/**
	* Returns the preferred number of visible rows.
	*
	* @return		the preferred number of rows to display without using a scroll bar
	**/
	 public int getVisibleRowCount()
	{
		return 0;
	}


	/**
	* Returns the index of the last selected row, -1 if no row is selected.
	*
	* @return		the index of the first selected row
	**/
	 public int getMaxSelectionIndex()
	{
		return 0;
	}


	/**
	* Returns the index of the first selected row, -1 if no row is selected.
	*
	* @return		the index of the first selected row
	**/
	 public int getMinSelectionIndex()
	{
		return 0;
	}


	/**
	* Returns the list model.
	*
	* @return		returns the data model of this list
	**/
	 public com.ulcjava.base.application.IListModel getModel()
	{
		return null;
	}


	/**
	* Returns the index of the first selected row, -1 if no row is selected.
	*
	* @return		the index of the first selected row
	**/
	 public int getSelectedIndex()
	{
		return 0;
	}


	/**
	* Returns the indices of all selected rows.
	*
	* @return		an array of integers containing the indices of all selected rows, or an empty array if no row is selected
	**/
	 public int[] getSelectedIndices()
	{
		return null;
	}


	/**
	* Returns the first selected value.
	*
	* @return		the first selected value
	**/
	 public java.lang.Object getSelectedValue()
	{
		return null;
	}


	/**
	* Returns all selected values.
	*
	* @return		an array of Objects containing all selected values, or an empty array if nothing is selected
	**/
	 public java.lang.Object[] getSelectedValues()
	{
		return null;
	}


	/**
	* Returns the background color for selected rows.
	*
	* @return		the background color for selected rows
	**/
	 public com.ulcjava.base.application.util.Color getSelectionBackground()
	{
		return null;
	}


	/**
	* Returns the foreground color for selected rows.
	*
	* @return		the foreground color for selected rows
	**/
	 public com.ulcjava.base.application.util.Color getSelectionForeground()
	{
		return null;
	}


	/**
	* Returns the current selection mode.
	*
	* @return		The value of the selectionMode property.
	**/
	 public int getSelectionMode()
	{
		return 0;
	}


	/**
	* Returns the <code>ULCListSelectionModel</code> that is used to maintain row
	* selection state.
	*
	* @return		the object that provides row selection state
	**/
	 public com.ulcjava.base.application.ULCListSelectionModel getSelectionModel()
	{
		return null;
	}


	/**
	* Returns true if the row at the specified index is selected.
	*
	* @param index 		 the index position to be checked if selected
	* @return		true if the row at index <code>row</code> is selected, where 0 is the first row
	* @throws		IllegalArgumentException if <code>row</code> is not in the valid range
	**/
	 public boolean isSelectedIndex(int index)
	{
		return false;
	}


	/**
	* Returns true if nothing is selected, false otherwise.
	*
	* @return		true if nothing is selected, false otherwise
	**/
	 public boolean isSelectionEmpty()
	{
		return false;
	}


	/**
	* Removes a listener for list selection events.
	*
	* @param listener 		 the list selection listener to remove
	**/
	 public void removeListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Deselects the rows from <code>index0</code> to <code>index1</code>, inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void removeSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Sets the specified list cell renderer.
<p>
</p>
<b>Note:</b> Setting the
	* renderer to null installs the default renderer.
	*
	* @param renderer 		 the list cell renderer to set
	**/
	 public void setCellRenderer(com.ulcjava.base.application.IListCellRenderer renderer)
	{
	}


	/**
	* Sets the height for all cells in the list.
	*
	* @param height 		 the height in pixels for all cells in this list
	**/
	 public void setFixedCellHeight(int height)
	{
	}


	/**
	* Sets the width for all cells in the list. When this property is set to -1, the
	* component width will be set to the width of the widest
cell. When the list is
	* very large the calculation may significantly affect the
	* performance.
<p>
</p>
The default value of this property is -1.
<p>
</p>
	*
	* @param width 		 the width in pixels for all cells in this list
	**/
	 public void setFixedCellWidth(int width)
	{
	}


	/**
	* Sets the preferred number of rows in the list that can be displayed without a
	* scollbar.
	*
	* @param visibleRowCount 		 the preferred number of visible rows
	**/
	 public void setVisibleRowCount(int visibleRowCount)
	{
	}


	/**
	* Constructs a list model from an array of objects and then applies setModel to
	* it.
	*
	* @param listData 		 the object array
	**/
	 public void setListData(java.lang.Object[] listData)
	{
	}


	/**
	* Constructs a list model from a list and then applies setModel to it.
	*
	* @param listData 		 the list
	**/
	 public void setListData(java.util.List listData)
	{
	}


	/**
	* Sets the data model for the list.
	*
	* @param dataModel 		 the list model to set
	**/
	 public void setModel(com.ulcjava.base.application.IListModel dataModel)
	{
	}


	/**
	* Sets selection to given index.
	*
	* @param index 		 index to be selected
	**/
	 public void setSelectedIndex(int index)
	{
	}


	/**
	* Sets selection to given indices.
	*
	* @param indices 		 array of indices to be selected
	**/
	 public void setSelectedIndices(int[] indices)
	{
	}


	/**
	* Selects the specified object from the list.
	*
	* @param value 		 the object to select
	* @param ensureIndexIsVisible 		 true if the list should scroll to display the selected object, false otherwise
	**/
	 public void setSelectedValue(java.lang.Object value, boolean ensureIndexIsVisible)
	{
	}


	/**
	* Choose the background color for selected rows. Cell renderers can use this
	* value to for background in selected cells.
<p>
</p>
The default value of this
	* property is defined by the look and feel implementation.
	*
	* @param selectionBackground 		 the <code>Color</code> to use for the background of selected cells
	**/
	 public void setSelectionBackground(com.ulcjava.base.application.util.Color selectionBackground)
	{
	}


	/**
	* Sets the foreground color for selected rows. Cell renderers can use this value
	* for text and graphics color in selected cells.
<p>
</p>
The default value of
	* this property is defined by the look and feel implementation.
	*
	* @param selectionForeground 		 the <code>Color</code> to use in the foreground for selected list items
	**/
	 public void setSelectionForeground(com.ulcjava.base.application.util.Color selectionForeground)
	{
	}


	/**
	* Selects the rows from <code>index0</code> to <code>index1</code>, inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void setSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Set the selection mode. The following selectionMode values are
	* allowed:
<ul>
<li> <code>ULCListSelectionModel.SINGLE_SELECTION</code> Only
	* one list index can be selected at a time. In this mode
	* the
setSelectionInterval and addSelectionInterval methods are equivalent, and
	* only the second index argument is used.
<li>
	* <code>ULCListSelectionModel.SINGLE_INTERVAL_SELECTION</code> One contiguous
	* index interval can be selected at a time. In this
mode setSelectionInterval
	* and addSelectionInterval are equivalent.
<li>
	* <code>ULCListSelectionModel.MULTIPLE_INTERVAL_SELECTION</code> In this mode,
	* there's no restriction on what can be selected.
</ul>
	*
	* @param selectionMode 		 the selection mode
	**/
	 public void setSelectionMode(int selectionMode)
	{
	}


	/**
	* Computes the <code>fixedCellWidth</code> by configuring the
	* <code>cellRenderer</code> to index equals zero for the specified
value and
	* then computing the renderer component's preferred size. These properties are
	* useful when the list is too long to allow
<code>ULCList</code> to compute the
	* widest value out of each cell and there is a single cell value that is known
	* to occupy as much
space as any of the others. The default value of this
	* property is <code>null</code>.
<p>
</p>
To use the exclusively client side
	* computing of the list width based on the available list values set
	* the
<code>prototypeCellValue</code> to an empty string.
	*
	* @param prototypeCellValue 		 the value on which to base <code>fixedCellWidth</code>
	* @see		#getPrototypeCellValue
	* @see		#setFixedCellWidth
	* @see		#setFixedCellHeight
	**/
	 public void setPrototypeCellValue(java.lang.Object prototypeCellValue)
	{
	}


	/**
	* Returns the value of the "prototypical cell" -- a cell used for the
	* calculationof cell widths.
	*
	* @return		the value of the <code>prototypeCellValue</code> property
	* @see		#setPrototypeCellValue
	**/
	 public java.lang.Object getPrototypeCellValue()
	{
		return null;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}


	/**
	* Returns the transfer handler.
	*
	* @return		the instance of TransferHandler
	**/
	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCListDispatcher extends ULCComponentDispatcher
{

	 public  final void requestCellRendererComponents(int[] range)
	{
	}


}
}