package com.ulcjava.base.application;


	/**
	* The <code>ULCMenu</code> component represents a menu component containing
	* <code>ULCMenuItems</code> and
	* <code>ULCSeparators</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCMenu</code> component inherits all features from
	* <code>ULCMenuItem</code>, <code>ULCAbstractButton</code>
	* and
<code>ULCComponent</code>.
<li>The developer can add, insert, and remove
	* <code>ULCMenuItems</code> (the actual menu items),
	* <code>ULCSeparators</code>
(separators to form logical groups of menu items),
	* and <code>ULCMenus</code> (to define sub menus) to a
	* <code>ULCMenu</code>.
<li>A <code>ULCMenu</code> can be used as a popup menu
	* on any <code>ULCComponent</code>.
</ul>
<b>Examples</b>
<p>
</p>
The
	* followingexample shows how to construct a <code>ULCMenu</code> that contains
	* simple menu items, a separator, and a submenu.

<pre>
ULCMenu subMenu = new
	* ULCMenu(&quot;SubMenu&quot;);
subMenu.add(&quot;SubOne&quot;).addActionListener
	* (actionListener);
subMenu.add(&quot;SubTwo&quot;).addActionListener(actionListen
	* er);
ULCMenu menu = new
	* ULCMenu(&quot;Menu&quot;);
menu.setMnemonic('m');
menu.add(subMenu);
menu.addSe
	* parator();
menu.add(&quot;One&quot;).addActionListener(actionListener);
menu.add
	* (&quot;Two&quot;).addActionListener(actionListener);
</pre>
	*
	* @ulc.application		
	* @see		ULCMenuItem
	* @see		ULCAbstractButton
	* @see		ULCComponent
	* @see		ULCSeparator
	**/
 public class ULCMenu extends com.ulcjava.base.application.ULCMenuItem
{


	/**
	* Constructs a new <code>ULCMenu</code> with no text.
	*
	**/
	 public ULCMenu()
	{
		 super();
	}


	/**
	* Constructs a new <code>ULCMenu</code> with the supplied string as its text.
	*
	* @param text 		 the text for the menu label
	**/
	 public ULCMenu(java.lang.String text)
	{
		 super();
	}


	/**
	* Returns the <code>ULCPopupMenu</code> for this <code>ULCMenu</code>.
	*
	* @return		the <code>ULCPopupMenu</code> for this <code>ULCMenu</code>
	**/
	 public com.ulcjava.base.application.ULCPopupMenu getComponentPopupMenu()
	{
		return null;
	}


	/**
	* Create a menu with the properties defined in the action object. The action is
	* registered as action listener with the menu.
	*
	* @param action 		 the action containing the menu properties
	**/
	 public ULCMenu(com.ulcjava.base.application.IAction action)
	{
		 super();
	}


	/**
	* Adds a menu item to the end of this menu. Returns the menu item added.
	*
	* @param menuItem 		 the <code>ULCMenuItem</code> to be added
	* @return		the <code>ULCMenuItem</code> added
	**/
	 public com.ulcjava.base.application.ULCMenuItem add(com.ulcjava.base.application.ULCMenuItem menuItem)
	{
		return null;
	}


	/**
	* Adds the given component to the end of this menu.
	*
	* @param component 		 the component to be added
	* @return		the <code>ULCComponent</code> added
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Constructs a new menu item with the specified text and adds it to the end of
	* this menu.
	*
	* @param s 		 the string for the menu item to be added
	* @return		the <code>ULCMenuItem</code> added
	**/
	 public com.ulcjava.base.application.ULCMenuItem add(java.lang.String s)
	{
		return null;
	}


	/**
	* Appends a new separator to the end of the menu.
	*
	**/
	 public void addSeparator()
	{
	}


	/**
	* Returns the number of components on the menu.
	*
	* @return		an integer containing the number of components on the menu
	**/
	 public int getMenuComponentCount()
	{
		return 0;
	}


	/**
	* Returns the component at position <code>n</code>.
	*
	* @param n 		 the position of the component to be returned
	* @return		the component requested
	**/
	 public com.ulcjava.base.application.ULCComponent getMenuComponent(int n)
	{
		return null;
	}


	/**
	* Returns an array of <code>ULCComponent</code>s of the menu's subcomponents.
	* Note that this returns all <code>ULCComponent</code>s
in the menu, including
	* separators.
	*
	* @return		an array of <code>ULCComponent</code>s
	**/
	 public com.ulcjava.base.application.ULCComponent[] getMenuComponents()
	{
		return null;
	}


	/**
	* Inserts the specified <code>ULCMenuItem</code> at a given position.
	*
	* @param mi 		 the <code>ULCMenuItem</code> to add
	* @param pos 		 an integer specifying the position at which to add the new <code>ULCMenuItem</code>
	* @return		the new menu item
	**/
	 public com.ulcjava.base.application.ULCMenuItem insert(com.ulcjava.base.application.ULCMenuItem mi, int pos)
	{
		return null;
	}


	/**
	* Creates and inserts a new menu item with the specified text at a given position.
	*
	* @param s 		 the text for the menu item to add
	* @param pos 		 an integer specifying the position at which to add the new menu item
	**/
	 public void insert(java.lang.String s, int pos)
	{
	}


	/**
	* Inserts a separator at the specified position.
	*
	* @param index 		 an integer specifying the position at which to insert the menu separator
	**/
	 public void insertSeparator(int index)
	{
	}


	/**
	* Removes the specified menu item from this menu.
	*
	* @param item 		 the <code>ULCMenuItem</code> to be removed from the menu
	**/
	 public void remove(com.ulcjava.base.application.ULCMenuItem item)
	{
	}


	/**
	* Removes the menu item at a specified index from this menu.
	*
	* @param index 		 the index of <code>ULCMenuItem</code> to be removed from the menu
	**/
	 public void remove(int index)
	{
	}


	/**
	* Removes all menu items from this menu.
	*
	**/
	 public void removeAll()
	{
	}


	/**
	* <code>setAccelerator</code> is not defined for <code>ULCMenu</code>. Use
	* <code>setMnemonic()</code> instead.
	*
	* @param keyStroke 		 unvalid as this method is not defined for ULCMenu
	* @throws		UnsupportedOperationException if invoked -- this method is not defined for <code>ULCMenu</code>.
	**/
	 public void setAccelerator(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
	}


	/**
	* Returns whether the menu is a 'top-level menu', i.e., whether it is activated
	* from a menubar, or from a menu item or menu.
	*
	* @return		true if the menu is direct child of a menubar, false otherwise
	**/
	 public boolean isTopLevelMenu()
	{
		return false;
	}


	/**
	* Returns the suggested delay (in milliseconds) before submenus are popped up or
	* down.
	*
	* @return		the <code>delay</code> property
	* @see		#setDelay(int)
	**/
	 public int getDelay()
	{
		return 0;
	}


	/**
	* Sets the delay between menu selection and making the popup menu visible This
	* property's behavior is dependent on the look and feel.
The default value is 0.
	*
	* @param delay 		 the number of milliseconds to delay
	* @exception		IllegalArgumentException if <code>delay</code> is less than 0
	**/
	 public void setDelay(int delay)
	{
	}


	/**
	* Sets the language-sensitive orientation that is to be used to order the
	* elements or text within this menu.
	*
	* @param componentOrientation 		 ComponentOrientation to set
	* @see		ComponentOrientation
	**/
	 public void setComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}


	/**
	* Sets the <code>ComponentOrientation</code> for this menu and its contained
	* components.
	*
	* @param componentOrientation 		 the component orientation to set
	* @exception		NullPointerException if <code>componentOrientation</code> is null.
	* @see		ULCComponent#setComponentOrientation
	* @see		ULCComponent#getComponentOrientation
	**/
	 public void applyComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCMenuDispatcher extends ULCMenuItemDispatcher
{


}
}