package com.ulcjava.base.application;


	/**
	* The <code>ULCMenuBar</code> component is the container for all menus of a
	* <code>ULCRootPane</code>. After constructing the menu bar,
it has to be added
	* to a root pane, e.g, <code>ULCFrame</code>, <code>ULCDialog</code>, or
	* <code>ULCAppletPane</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCMenuBar</code> component inherits all features from
	* <code>ULCComponent</code>.
<li><code>ULCMenus</code> can be added to and
	* removed from a <code>ULCMenuBar</code> at runtime.
<li>The
	* <code>ULCMenuBar</code> offers access to the menus it
	* contains.
</ul>
<b>Examples</b>
<p>
</p>
The following code excerpt creates a
	* <code>ULCMenuBar</code>, adds two existing menus and adds the menu bar to
	* a
<code>ULCRootPane</code>.

<pre>
ULCMenuBar menuBar = new
	* ULCMenuBar();
menuBar.add(menuOne);
menuBar.add(menuTwo);
rootPane.setMenuBar(m
	* enuBar);
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCMenu
	* @see		ULCRootPane
	* @see		ULCFrame
	* @see		ULCDialog
	**/
 public class ULCMenuBar extends com.ulcjava.base.application.ULCContainer
{


	/**
	* Constructs a new menu bar.
	*
	**/
	 public ULCMenuBar()
	{
		 super();
	}


	/**
	* Appends the specified menu to the end of the menu bar.
	*
	* @param menu 		 the <code>ULCMenu</code> component to add
	* @return		the menu component
	**/
	 public com.ulcjava.base.application.ULCMenu add(com.ulcjava.base.application.ULCMenu menu)
	{
		return null;
	}


	/**
	* Add the specified menu at the position indicated by index.
	*
	* @param component 		 the <code>ULCComponent</code> component to add
	* @param index 		 the index where to add the menu
	* @return		the menu component
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}


	/**
	* Returns the menu at the given index in this menu bar.
	*
	* @param index 		 an integer representing an index of the desired menu 0 is the first position
	* @return		the <code>ULCMenu</code> at the given index, or <code>null</code> if if there is no <code>ULCMenu</code> at that index
	**/
	 public com.ulcjava.base.application.ULCMenu getMenu(int index)
	{
		return null;
	}


	/**
	* Returns the number of menus in the menu bar.
	*
	* @return		the number of menus in the menu bar
	**/
	 public int getMenuCount()
	{
		return 0;
	}


	/**
	* Returns the margin space between the menubar's border and its menus.
	*
	* @return		the margin
	**/
	 public com.ulcjava.base.application.util.Insets getMargin()
	{
		return null;
	}


	/**
	* Sets the margin between the menubar's border and its menus. Setting to
	* <code>null</code> will cause the menubar to use the default
margins.
	*
	* @param margin 		 the space between the menubar's border and its menus
	**/
	 public void setMargin(com.ulcjava.base.application.util.Insets margin)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Returns true if the menu bars border should be painted.
	*
	* @return		true if the border should be painted, else false
	**/
	 public boolean isBorderPainted()
	{
		return false;
	}


	/**
	* Sets whether the border should be painted.
	*
	* @param borderPainted 		 if true and border property is not <code>null</code>, the border is painted.
	* @see		#isBorderPainted
	**/
	 public void setBorderPainted(boolean borderPainted)
	{
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCMenuBarDispatcher extends ULCContainerDispatcher
{


}
}