package com.ulcjava.base.application;


	/**
	* <code>ULCPopupMenu</code> extends the possibility to navigate over a component
	* hierarchy as in swing. As in swing where
<code>JMenuBar</code> is a container
	* <code>ULCMenuBar</code> is a container as well, from which
	* <code>ULCMenu</code> components can
be accessed. <code>ULCMenu</code>
	* providesa <code>ULCPopupMenu</code> from which its children
	* <code>ULCMenu</code>s and
<code>ULCMenuItem</code>s can be accessed.
	* Additionally <code>ULCPopupMenu</code> is used for a component popup menu as
	* introduced
in JDK1.5, which now can be set on all
	* <code>ULCComponent</code>s.
<p>
</p>
<b>Features</b>
<ul>
<li>Provides a
	* mechanism to navigate over the <code>ULCMenuBar</code>, <code>ULCMenu</code>
	* and <code>ULCMenuItem</code>
hierarchy.</li>
<li>Provides a base to enable
	* <code>ULCPopupMenu</code>s for all <code>ULCComponent</code>s.</li>
<li>The
	* application can register <code>IPopupMenuListener</code>s, which are notified
	* whenever the popup menu is about to become
visible or invisible or when it is
	* canceled.
</ul>
<b>Examples</b>
</p>
The following code snippet accesses a
	* <code>ULCMenu</code>'s <code>ULCPopupMenu</code> to navigate over the menu
	* hierarchy.

<pre>
ULCMenuBar bar = new ULCMenuBar();
...
ULCButton
	* changeMenuButton = new ULCButton(&quot;Change
	* menu&quot;);
changeMenuButton.addActionListener(new IActionListener()
	* {
publicvoid actionPerformed(ActionEvent event) {
ULCMenu menu =
	* bar.getMenu(0);
ULCPopupMenu popupMenu = menu.getComponentPopupMenu();
// set
	* a new text to an existing menu
	* item
((ULCMenuItem)popupMenu.getComponents()[0]).setText(&quot;new
	* Text&quot;);
// add a new menu item
popupMenu.add(&quot;new menu
	* item&quot;);
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent
	* @see		com.ulcjava.base.application.ULCMenu
	* @see		com.ulcjava.base.application.ULCMenuItem
	* @see		com.ulcjava.base.application.event.IPopupMenuListener
	**/
 public class ULCPopupMenu extends com.ulcjava.base.application.ULCContainer
{


	/**
	* Creates a ULCPopupMenu with an empty label.
	*
	**/
	 public ULCPopupMenu()
	{
		 super();
	}


	/**
	* Creates a ULCPopupMenu with a label.
	*
	* @param label 		 the label of the popup menu.
	**/
	 public ULCPopupMenu(java.lang.String label)
	{
		 super();
	}


	/**
	* Adds a menu entry to the popup menu with the given string value.
	*
	* @param menuItemText 		 the text to appear as the menu entry
	* @return		the created <code>ULCMenuItem</code>
	**/
	 public com.ulcjava.base.application.ULCMenuItem add(java.lang.String menuItemText)
	{
		return null;
	}


	/**
	* Adds a menu entry to the popup menu.
	*
	* @param menuItem 		 the menu item to appear as the menu entry
	* @return		the created <code>ULCMenuItem</code>
	**/
	 public com.ulcjava.base.application.ULCMenuItem add(com.ulcjava.base.application.ULCMenuItem menuItem)
	{
		return null;
	}


	/**
	* Inserts a menu entry into a popup menu at a specific index.
	*
	* @param component 		 the component to be inserted.
	* @param index 		 the index where the component is inserted.
	**/
	 public void insert(com.ulcjava.base.application.ULCComponent component, int index)
	{
	}


	/**
	* Adds a menu at the position indicated by index.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index where to add the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds a separator at the end of the popup menu.
	*
	**/
	 public void addSeparator()
	{
	}


	/**
	* Checks if the border around the popup menu gets painted or not.
	*
	* @return		true if the border is painted, false otherwise
	**/
	 public boolean isBorderPainted()
	{
		return false;
	}


	/**
	* Defines if the border is painted or not.
	*
	* @param borderPainted 		 true if the border should get painted, false otherwise
	**/
	 public void setBorderPainted(boolean borderPainted)
	{
	}


	/**
	* The label of the popup menu.
	*
	* @return		the label of the popup menu.
	**/
	 public java.lang.String getLabel()
	{
		return null;
	}


	/**
	* Sets the label of the popup menu.
	*
	* @param label 		 the label of the popup menu.
	**/
	 public void setLabel(java.lang.String label)
	{
	}


	/**
	* Returns the component on which is this popup menu has popped up must recently.
	* Note that {@link #getInvoker()} does not work in
conjunction with the
	* deprecated method {@link ULCComponent#setPopupMenu(ULCMenu)} but only
	* with
{@link ULCComponent#setComponentPopupMenu(ULCPopupMenu)}.
	*
	* @return		The invoker component or <code>null</code> if the popup menu has not ever popped up or if the invoker is unknown.
	**/
	 public com.ulcjava.base.application.ULCComponent getInvoker()
	{
		return null;
	}


	/**
	* Add a popup menu listener.
	*
	* @param listener 		 the listener to be added
	**/
	 public void addPopupMenuListener(com.ulcjava.base.application.event.IPopupMenuListener listener)
	{
	}


	/**
	* Remove a popup menu listener.
	*
	* @param listener 		 the listener to be removed
	**/
	 public void removePopupMenuListener(com.ulcjava.base.application.event.IPopupMenuListener listener)
	{
	}


	/**
	* Returns an array of all the popup menu listeners registered on this popup menu.
	*
	* @return		all of this popup menu's <code>IPopupMenuListener</code>s or an empty array if no popup menu listeners are currently
registered
	* @see		#addPopupMenuListener(IPopupMenuListener)
	* @see		#removePopupMenuListener(IPopupMenuListener)
	**/
	 public com.ulcjava.base.application.event.IPopupMenuListener[] getPopupMenuListeners()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected void updateInvoker(java.lang.Integer id)
	{
	}

	 protected void updateVisible(boolean visible)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCPopupMenuDispatcher extends ULCContainerDispatcher
{

	 public  final void updateInvoker(java.lang.Integer id)
	{
	}

	 public  final void updateVisible(boolean visible)
	{
	}


}
	/**
	* This class is a popup menu specific separator.
	*
	* @ulc.application		
	**/
 public  static class ULCSeparator extends com.ulcjava.base.application.ULCSeparator
{


	/**
	* Creates a new horizontal popup menu separator.
	*
	**/
	 public ULCSeparator()
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSeparatorDispatcher extends com.ulcjava.base.application.ULCSeparator$ULCSeparatorDispatcher
{


}
}
}