package com.ulcjava.base.application;


	/**
	* The <code>ULCProgressBar</code> component is to visualize the progress of any
	* task. The application needs to set the values on the
component as the task
	* progresses, the component then displays the progress state between a minimum
	* and a maximum value.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCProgressBar</code> component inherits all features from
	* <code>ULCComponent</code>.
<li>An application developer must define the
	* minimum and maximum value of the range to be visualized by the
	* <code>ULCProgressBar</code>.
The current value, which is represented by the
	* position of the progress bar, is set on the component directly.
<li>The
	* orientation of a <code>ULCProgressBar</code> can be specified to be
	* horizontalor vertical.
<li>It can be specified if the border of
	* <code>ULCProgressBar</code> should be painted or
	* not.
</ul>
<b>Examples</b>
<p>
</p>
The following code snippet shows how to
	* use an <code>ULCProgressBar</code> in conjunction with an
	* <code>ULCPollingTimer</code> in
order to update the progress during task
	* completion. After initialzing a horizontal <code>ULCProgressBar</code> with
	* minimum 0 and
maximum 100, an <code>ULCPollingTimer</code> is created. The
	* <code>ULCPollingTimer</code> should not run repeatedly, but only once.
An
	* instance of <code>IActionListener</code> contains the code to be executed
	* during each server roundtrip. First, the server checks for
open tasks to
	* complete. If found, the next task will be executed and the
	* <code>ULCProgressBar</code> will be updated after the server
roundtrip
	* returnsusing the <code>setValue(int)</code> method. Finally, the
	* <code>ULCPollingTimer</code> has to be restarted in order
to initialize the
	* next server roundtrip. If all tasks are completed, the
	* <code>ULCPollingTimer</code> should not be restarted since all
the work is
	* done.

<pre>
final ULCProgressBar progressBar = new
	* ULCProgressBar(
ULCProgressBar.HORIZONTAL, 0, 100);
final ULCLabel status =
	* new ULCLabel();
final ULCPollingTimer timer = new ULCPollingTimer(500,
	* null);
timer.setRepeats(false);
timer.addActionListener(new IActionListener()
	* {
char fCurrentChar = 'A';

public void actionPerformed(ActionEvent event)
	* {
if (fCurrentChar &lt;= 'Z') {
// simulate a task
try
	* {
Thread.sleep(Math.round(1000 * Math.random()));
} catch
	* (InterruptedException e) {
}
status.setText(&quot;Indexed Words &quot; +
	* fCurrentChar + &quot;...&quot;);
progressBar.setValue(100 / ('Z' - 'A') *
	* (fCurrentChar - 'A'));
fCurrentChar++;
timer.restart();
} else
	* {
status.setText(&quot;Done.&quot;);
}
}
});
final ULCButton button = new
	* ULCButton(&quot;Start&quot;);
button.addActionListener(new IActionListener()
	* {public void actionPerformed(ActionEvent event)
	* {
button.setEnabled(false);
timer.start();
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCPollingTimer
	**/
 public class ULCProgressBar extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a horizontal progress bar. The default orientation for progress bars
	* is<code>HORIZONTAL</code>. Uses the default minimum
value (0) and default
	* maximum value (100). Uses the default minimum value for the initial value of
	* the progress bar.
	*
	**/
	 public ULCProgressBar()
	{
		 super();
	}


	/**
	* Creates a progress bar with the specified orientation, which can be either
	* <code>VERTICAL</code> or <code>HORIZONTAL</code>.
Uses the default minimum
	* value (0) and default maximum value (100). Uses the default minimum value for
	* the initial value of the
progress bar.
	*
	* @param orientation 		 the orientation of the progress bar
	**/
	 public ULCProgressBar(int orientation)
	{
		 super();
	}


	/**
	* Creates a progress bar with the specified minimum and maximum values. Uses the
	* specified minimum for the initial value of the
progress bar. Uses the default
	* orientation <code>HORIZONTAL</code>.
	*
	* @param min 		 the minimum of the progress bar
	* @param max 		 the maximum of the progress bar
	**/
	 public ULCProgressBar(int min, int max)
	{
		 super();
	}


	/**
	* Creates a progress bar with the specified orientation, minimum and maximum
	* values. Uses the specified minimum for the initial value
of the progress bar.
	*
	* @param orientation 		 the orientation of the progress bar
	* @param min 		 the minimum of the progress bar
	* @param max 		 the maximum of the progress bar
	* @see		#setOrientation
	**/
	 public ULCProgressBar(int orientation, int min, int max)
	{
		 super();
	}


	/**
	* Returns the maximum value. The default is <I>100</I>.
	*
	* @return		the maximum value
	* @see		#setMaximum
	**/
	 public int getMaximum()
	{
		return 0;
	}


	/**
	* Returns the minimum value. The default is <I>0</I>.
	*
	* @return		the minimum value
	* @see		#setMinimum
	**/
	 public int getMinimum()
	{
		return 0;
	}


	/**
	* Returns the orientation of the progress bar which can be
	* <code>HORIZONTAL</code> or <code>VERTICAL</code> The default orientation
is
	* <code>HORIZONTAL</code>.
	*
	* @return		HORIZONTAL or VERTICAL
	* @see		#setOrientation
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Returns the current value. The value is always between the minimum and maximum
	* values, inclusive. By default, the value equals the
minimum.
	*
	* @return		the value
	* @see		#setValue
	**/
	 public int getValue()
	{
		return 0;
	}


	/**
	* Sets the maximum value to <I>maximum</I>.
	*
	* @param maximum 		 the new maximum value
	* @see		#getMaximum
	**/
	 public void setMaximum(int maximum)
	{
	}


	/**
	* Sets the minimum value to <I>minimum</I>.
	*
	* @param minimum 		 the new minimum value
	* @see		#getMinimum
	**/
	 public void setMinimum(int minimum)
	{
	}


	/**
	* Sets the orientation to <code>newOrientation</code>.
<p>
</p>
Possible values
	* for the orientation
	* are:
<ul>
<li><code>HORIZONTAL</code>,
<li><code>VERTICAL</code>,
</ul>
	*
	* @param newOrientation 		 the new orientation
	* @throws		IllegalArgumentException if orientation is not one of: HORIZONTAL or VERTICAL.
	* @see		#getOrientation
	**/
	 public void setOrientation(int newOrientation)
	{
	}


	/**
	* Sets the current value of the progress bar to <I>value</I>.
	*
	* @param value 		 the new value
	* @see		#getValue
	**/
	 public void setValue(int value)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Returns true if the progress bars border should be painted.
	*
	* @return		true if the border should be painted, else false
	**/
	 public boolean isBorderPainted()
	{
		return false;
	}


	/**
	* Sets whether the border should be painted.
	*
	* @param borderPainted 		 if true and border property is not <code>null</code>, the border is painted.
	* @see		#isBorderPainted
	**/
	 public void setBorderPainted(boolean borderPainted)
	{
	}


	/**
	* Returns whether this progress bar is in the <code>indeterminate</code> mode.
	*
	* @return		true if this progress bar is in the <code>indeterminate</code> mode (i.e., cannot currently provide any reasonable
information about its state), false otherwise
	**/
	 public boolean isIndeterminate()
	{
		return false;
	}


	/**
	* Sets whether this progress bar should be <code>indeterminate</code>. An
	* indeterminate progress bar continuously displays animation
indicating that an
	* operation of unknown length is occurring. By default, this property is
	* <code>false</code>. Some clients might
not support indeterminate progress
	* bars; they will ignore this property.
	*
	* @param indeterminate 		 <code>true</code> if the progress bar should be set to indeterminate mode; <code>false</code> otherwise.
	**/
	 public void setIndeterminate(boolean indeterminate)
	{
	}


	/**
	* Returns a number between 0.0 and 1.0 that represents the percent complete
	* status for the progress bar.
	*
	* @return		the percent complete status for the progress bar
	**/
	 public double getPercentComplete()
	{
		return 0.0d;
	}


	/**
	* Returns whether the progress bar should render a string.
	*
	* @return		true if progress bar renders a string, false otherwise
	* @see		#setStringPainted
	* @see		#setString
	**/
	 public boolean isStringPainted()
	{
		return false;
	}


	/**
	* Sets whether the progress bar should render a progress string. The default is
	* false, meaning no string is painted. This property's
behavior is dependent on
	* the look and feel.
	*
	* @param paintString 		 true if the progress bar should render a string, false otherwise
	* @see		#isStringPainted
	* @see		#setString
	**/
	 public void setStringPainted(boolean paintString)
	{
	}


	/**
	* Returns the current value of the progress string.
	*
	* @return		the value of the progress string
	* @see		#setString
	**/
	 public java.lang.String getString()
	{
		return null;
	}


	/**
	* Sets the progress string to be painted. The default value is <code>null</code>.
	*
	* @param progressString 		 the value of the percent string
	* @see		#getString
	* @see		#setStringPainted
	* @see		#isStringPainted
	**/
	 public void setString(java.lang.String progressString)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCProgressBarDispatcher extends ULCComponentDispatcher
{


}
}