package com.ulcjava.base.application;


	/**
	* The <code>ULCRadioButton</code> class is a subclass of
	* <code>ULCToggleButton</code> and is equivalent to the standard radio
	* button.
Use <code>ULCButtonGroup</code> or <code>ULCBoxPane</code> to form a
	* group of radio buttons.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCRadioButton</code> component inherits all features from
	* <code>ULCToggleButton</code>.
<li>In order to get the appropriate radio
	* buttonbehavior, a <code>ULCButtonGroup</code> must be created and assigned to
	* all
<code>ULCRadioButtons</code> that form one logical radio button
	* group.
</ul>
<b>Examples</b>
<p>
</p>
The following example shows how to
	* construct a group of <code>ULCRadioButtons</code>.

<pre>
ULCRadioButton one
	* =new ULCRadioButton(&quot;One&quot;,
	* true);
one.setMnemonic('o');
one.setGroup(buttonGroup);
one.addValueChangedList
	* ener(valueChangedListener);
ULCRadioButton two = new
	* ULCRadioButton(&quot;Two&quot;);
two.setMnemonic('w');
two.setGroup(buttonGroup
	* );
two.addValueChangedListener(valueChangedListener);
ULCRadioButton three =
	* new
	* ULCRadioButton(&quot;Three&quot;);
three.setMnemonic('h');
three.setGroup(butto
	* nGroup);
three.addValueChangedListener(valueChangedListener);
</pre>
	*
	* @ulc.application		
	* @see		ULCToggleButton
	* @see		ULCAbstractButton
	* @see		ULCComponent
	* @see		ULCButtonGroup
	**/
 public class ULCRadioButton extends com.ulcjava.base.application.ULCToggleButton
{


	/**
	* Creates an unselected radio button without text or image.
	*
	**/
	 public ULCRadioButton()
	{
		 super();
	}


	/**
	* Creates an unselected radio button with the specified image but no text.
	*
	* @param icon 		 the image to be display on this button
	**/
	 public ULCRadioButton(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a radio button with the specified image and selection state, but no
	* text.
	*
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, it is initially unselected
	**/
	 public ULCRadioButton(com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected radio button with the specified text.
	*
	* @param text 		 the string to be displayed on this button
	**/
	 public ULCRadioButton(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a radio button with the specified text and selection state.
	*
	* @param text 		 the string to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCRadioButton(java.lang.String text, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected radio button with the specified text and image.
	*
	* @param text 		 the string to be displayed on this button
	* @param icon 		 the image to be displayed on this button
	**/
	 public ULCRadioButton(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a radio button with the specified text, icon, and selection state.
	*
	* @param text 		 the string to be displayed on this button
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCRadioButton(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Create a radio button with the properties defined in the action object. The
	* action is registered as action listener with the radio
button.
	*
	* @param action 		 the action containing the radio button properties
	**/
	 public ULCRadioButton(com.ulcjava.base.application.IAction action)
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCRadioButtonDispatcher extends ULCToggleButtonDispatcher
{


}
}