package com.ulcjava.base.application;


	/**
	* <code>ULCRadioButtonMenuItems</code> can be used to define radio button
	* behavior for menu items.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCRadioButtonMenuItem</code> component inherits all features from
	* <code>ULCToggleMenuItem</code>,
<code>ULCMenuItem</code>,
	* <code>ULCAbstractButton</code> and <code>ULCComponent</code>.
<li>In order to
	* get the appropriate radio button behavior, a <code>ULCButtonGroup</code> must
	* be created and assigned to all
<code>ULCRadioButtonMenuItems</code> that form
	* one logical radio button group.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example shows how to construct a group of
	* <code>ULCRadioButtonMenuItems</code>.

<pre>
ULCRadioButtonMenuItem one = new
	* ULCRadioButtonMenuItem(&quot;One&quot;,
	* true);
one.setMnemonic('o');
one.setGroup(buttonGroup);
one.addValueChangedList
	* ener(valueChangedListener);
ULCRadioButtonMenuItem two = new
	* ULCRadioButtonMenuItem(&quot;Two&quot;);
two.setMnemonic('w');
two.setGroup(but
	* tonGroup);
two.addValueChangedListener(valueChangedListener);
ULCRadioButtonMenu
	* Item three = new
	* ULCRadioButtonMenuItem(&quot;Three&quot;);
three.setMnemonic('h');
three.setGro
	* up(buttonGroup);
three.addValueChangedListener(valueChangedListener);
</pre>
	*
	* @ulc.application		
	* @see		ULCToggleMenuItem
	* @see		ULCMenuItem
	* @see		ULCAbstractButton
	* @see		ULCComponent
	* @see		ULCButtonGroup
	**/
 public class ULCRadioButtonMenuItem extends com.ulcjava.base.application.ULCToggleMenuItem
{


	/**
	* Constructs radio button menu item, with no text or image.
	*
	**/
	 public ULCRadioButtonMenuItem()
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given icon.
	*
	* @param icon 		 an icon to be displayed
	**/
	 public ULCRadioButtonMenuItem(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given text label.
	*
	* @param text 		 the label to be shown on this item
	**/
	 public ULCRadioButtonMenuItem(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given text label and icon.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 an icon to be displayed
	**/
	 public ULCRadioButtonMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given text label and initial state.
	*
	* @param text 		 the label to be shown on this item
	* @param selected 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCRadioButtonMenuItem(java.lang.String text, boolean selected)
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given image and initial state.
	*
	* @param icon 		 an icon to be displayed
	* @param selected 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCRadioButtonMenuItem(com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Constructs radio button menu item with a given text label, image and initial
	* state.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 an icon to be displayed
	* @param selected 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCRadioButtonMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Create a radio button menu item with the properties defined in the action
	* object. The action is registered as action listener with
the radio button
	* menuitem.
	*
	* @param action 		 the action containing the radio button menu item properties
	**/
	 public ULCRadioButtonMenuItem(com.ulcjava.base.application.IAction action)
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCRadioButtonMenuItemDispatcher extends ULCToggleMenuItemDispatcher
{


}
}