package com.ulcjava.base.application;


	/**
	* ULCScrollBar is used in ULCScrollPane for manipulation of the
	* viewport.
<p>
</p>
<b>Features</b>
<ul>
<li>The orientation and the position
	* of the scroll bar can be specified.
<li>The behavior of the scroll bar can be
	* customized by setting the block and the unit increments.
<li>An
	* <code>IAdjustmentListener</code> can be added to a scroll bar to listen to
	* changes of the adjustable.
</ul>
<b>Examples</b>
<p>
</p>
The following code
	* snippet creates a vertical scroll bar with a block increment of 200
	* pixes.

<pre>
ULCScrollBar bar = new
	* ULCScrollBar(ULCScrollBar.VERTICAL);
bar.setBlockIncrement(200);
</pre>

<b>Not
	* e</b>: The setting of the block (and unit) increment might be overridden if
	* oneof the following components is contained in the
scroll
	* pane:
<ul>
<li><code>ULCList</code>
<li><code>ULCTable</code>
<li><code>ULCTabl
	* eTree</code>
<li><code>ULCTextComponent</code>: <code>ULCTextArea</code>,
	* <code>ULCTextField</code>
<li><code>ULCTree</code>
</ul>
	*
	* @ulc.application		
	* @see		ULCScrollPane
	* @see		IAdjustmentListener
	**/
 public class ULCScrollBar extends com.ulcjava.base.application.ULCComponent
{

	/**
	* A constant value to create a HORIZONTAL ULCScrollBar.
	*
	**/
	 public  final  static int HORIZONTAL = 0;

	/**
	* A constant value to create a VERTICAL ULCScrollBar.
	*
	**/
	 public  final  static int VERTICAL = 0;


	/**
	* Creates a vertical scrollbar with position 0.0.
	*
	**/
	 public ULCScrollBar()
	{
		 super();
	}


	/**
	* Creates a scrollbar with the specified orientation and the position 0.0.
	*
	* @param orientation 		 the orientation of the scrollbar
	**/
	 public ULCScrollBar(int orientation)
	{
		 super();
	}


	/**
	* Creates a scrollbar with the specified orientation and position. The position
	* is a value between 0 and 1, indicating the scrollbar
position relative to the
	* maximum size of the viewport view in the corresponding direction. <p/>
	*
	* @param orientation 		 the orientation of the scrollbar
	* @param position 		 the position of the scrollbar
	* @throws		IllegalArgumentException if orientation is not one of VERTICAL, HORIZONTAL
	**/
	 public ULCScrollBar(int orientation, double position)
	{
		 super();
	}

	 protected void updatePosition(double position)
	{
	}


	/**
	* Set the orientation of the scrollbar to either VERTICAL or HORIZONTAL.
	*
	* @param orientation 		 the new orientation of the scrollbar
	* @throws		IllegalArgumentException if orientation is not one of VERTICAL, HORIZONTAL
	**/
	 public void setOrientation(int orientation)
	{
	}


	/**
	* Returns the orientation of the scrollbar.
	*
	* @return		the orientation of the scrollbar
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Sets the unit increment of the scrollbar, the amount to change the value of
	* thescrollbar by a unit up/down request. <b>Note</b>:
The setting of this
	* property might be overridden if one of the following components is in the
	* scroll
	* pane:
<ul>
ULCList
<li>ULCTable
<li>ULCTableTree
<li>ULCTextArea
<li>ULCTextFie
	* ld
<li>ULCTree
	*
	* @param unitIncrement 		 the new unit increment of the scrollbar
	**/
	 public void setUnitIncrement(int unitIncrement)
	{
	}


	/**
	* Returns the unit increment of the scrollbar, the amount to change the value of
	* the scrollbar by a unit up/down request.
	*
	* @return		the unit increment of the scrollbar
	**/
	 public int getUnitIncrement()
	{
		return 0;
	}


	/**
	* Sets the amount to change the value of the scrollbar by a block (usually
	* "page") up/down request. <b>Note</b>: The setting of this
property might be
	* overridden if one of the following components is in the scroll
	* pane:
<ul>
ULCList
<li>ULCTable
<li>ULCTableTree
<li>ULCTextArea
<li>ULCTextFie
	* ld
<li>ULCTree
	*
	* @param blockIncrement 		 the new block increment
	**/
	 public void setBlockIncrement(int blockIncrement)
	{
	}


	/**
	* Returns the amount to change the value of the scrollbar a block (usually
	* "page") up/down request.
	*
	* @return		the block increment of the scrollbar
	**/
	 public int getBlockIncrement()
	{
		return 0;
	}


	/**
	* Sets the position of the scrollbar relative to the size of the viewport view
	* inthe corresponding direction.
	*
	* @param position 		 a value between 0 and 1 indicating the scrollbar position
	**/
	 public void setPosition(double position)
	{
	}


	/**
	* Returns the scrollbar position relative to the size of the viewport view in
	* thecorresponding direction.
	*
	* @return		the scrollbar position as a value between 0 and 1
	**/
	 public double getPosition()
	{
		return 0.0d;
	}


	/**
	* Adds an <code>IAdjustmentListener</code> that is notified each time the
	* scrollbar position has changed.
	*
	* @param listener 		 the <code>IAdjustmentListener</code> to be added
	**/
	 public void addAdjustmentListener(com.ulcjava.base.application.event.IAdjustmentListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IAdjustmentListener</code>s added to this
	* <code>ULCScrollBar</code> with
<code>addAdjustmentListener()</code>.
	*
	* @return		all <code>IAdjustmentListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IAdjustmentListener[] getAdjustmentListeners()
	{
		return null;
	}


	/**
	* Removes the <code>IAdjustmentListener</code>.
	*
	* @param listener 		 the <code>IAdjustmentListener</code> to be removed
	**/
	 public void removeAdjustmentListener(com.ulcjava.base.application.event.IAdjustmentListener listener)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCScrollBarDispatcher extends ULCComponentDispatcher
{

	 public  final void updatePosition(double position)
	{
	}


}
}