package com.ulcjava.base.application;


	/**
	* <code>ULCSeparator</code> objects are used for separating different menu or
	* toolbar items.
<p>
</p>
<b>Features</b>
<ul>
<li><code>ULCSeparator</code>
	* objects separate different menu items or toolbar buttons, and can hence be
	* used to form logical groups
of menu items or toolbar buttons.
<li>The
	* orientation of the <code>ULCSeparator</code> can be specified between
	* horizontal or vertical.
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
For
	* <code>ULCMenu</code> and <code>ULCToolbar</code>, <code>ULCSeparator</code>
	* objects should be added using the existing
convenience method to make sure
	* that a menu / tool bar specific separator is
	* added.

<pre>
menu.addSeparator();
toolBar.addSeparator();
</pre>
	*
	* @ulc.application		
	* @see		ULCMenu
	* @see		ULCToolBar
	**/
 public class ULCSeparator extends com.ulcjava.base.application.ULCComponent
{

	/**
	* Horizontal orientation.
	*
	**/
	 public  final  static int HORIZONTAL = 0;

	/**
	* Vertical orientation.
	*
	**/
	 public  final  static int VERTICAL = 0;


	/**
	* Creates a new horizontal separator.
	*
	**/
	 public ULCSeparator()
	{
		 super();
	}


	/**
	* Creates a new separator with the specified horizontal or vertical
	* orientation.
<p>
</p>
Legal orientation values
	* are:
<ul>
<li>HORIZONTAL
<li>VERTICAL
</ul>
	*
	* @param orientation 		 one of the two values listed above
	* @throws		IllegalArgumentException if orientation is invalid
	**/
	 public ULCSeparator(int orientation)
	{
		 super();
	}


	/**
	* Returns the orientation of the separator.
	*
	* @return		The <code>orientation</code>property
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Sets the orientation of the separator.
<p>
</p>
Legal orientation values
	* are:
<ul>
<li>HORIZONTAL
<li>VERTICAL
</ul>
	*
	* @param orientation 		 one of the two values listed above
	* @throws		IllegalArgumentException if orientation is invalid
	**/
	 public void setOrientation(int orientation)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSeparatorDispatcher extends ULCComponentDispatcher
{


}
}