package com.ulcjava.base.application;


	/**
	* The <code>ULCSlider</code> component visualizes values between predefined
	* minimum and maximum values as different positions on a
	* slider
bar.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCSlider</code>
	* component inherits all features from <code>ULCComponent</code>.
<li>An
	* application developer must define the minimum and maximum values of the range
	* to be visualized by the <code>ULCSlider</code>.
<li>An application can
	* register an <code>IValueChangedListener</code> to get notified about state
	* changes of the
<code>ULCSlider</code>.
<li>The orientation of a
	* <code>ULCSlider</code> can be specified to be horizontal or vertical. The
	* <code>paintTicks</code> and
<code>paintLabels</code> properties define if the
	* <code>ULCSlider</code> draws the ticks (indicating the intervals on the
	* slider) and
the corresponding labels. Moreover, how the slider draws these
	* ticks can be configured by specifying a <code>minorTickSpacing</code>
and a
	* <code>majorTickSpacing</code>, and if the knob should snap to the
	* ticks.
</ul><b>Examples</b>
<p>
</p>
The following example shows how to use
	* <code>ULCSlider</code>.

<pre>
ULCSlider slider = new
	* ULCSlider(ULCSlider.HORIZONTAL, // orientation
0, // minimum
1000, //
	* maximum
250); //
	* initial
slider.setMajorTickSpacing(250);
slider.setMinorTickSpacing(50);
slider
	* .setSnapToTicks(true);
slider.setPaintLabels(true);
slider.setPaintTicks(true);
	* slider.addValueChangedListener(new IValueChangedListener() {
public void
	* valueChanged(ValueChangedEvent event) {
ULCSlider source =
	* (ULCSlider)event.getSource();
System.out.println(&quot;value changed: &quot;
	* +source.getValue());
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	**/
 public class ULCSlider extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.shared.IDefaults, com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Creates a horizontal slider with the range 0...100 and an initial value of 50.
	*
	**/
	 public ULCSlider()
	{
		 super();
	}


	/**
	* Creates a slider using the specified orientation with the range 0...100 and an
	* initial value of 50.
<p>
</p>
Possible values for <code>orientation</code>
	* are:
<ul>
<li><code>HORIZONTAL</code>,
<li><code>VERTICAL</code>,
</ul>
	*
	* @param orientation 		 the orientation of the slider
	**/
	 public ULCSlider(int orientation)
	{
		 super();
	}


	/**
	* Creates a horizontal slider with the specified minimum and maximum values, and
	* an initial value of 50.
	*
	* @param minimum 		 the minimum of the slider
	* @param maximum 		 the maximum of the slider
	**/
	 public ULCSlider(int minimum, int maximum)
	{
		 super();
	}


	/**
	* Creates a horizontal slider with the specified minimum, maximum and initial
	* values.
	*
	* @param minimum 		 the minimum of the slider
	* @param maximum 		 the maximum of the slider
	* @param initial 		 the initial value of the slider
	**/
	 public ULCSlider(int minimum, int maximum, int initial)
	{
		 super();
	}


	/**
	* Creates a horizontal slider with the specified orientation and the specified
	* minimum, maximum and initial values.
	*
	* @param orientation 		 the orientation of the slider
	* @param minimum 		 the minimum of the slider
	* @param maximum 		 the maximum of the slider
	* @param initial 		 the initial value of the slider
	* @see		#setOrientation
	* @see		#setMinimum
	* @see		#setMaximum
	* @see		#setValue
	**/
	 public ULCSlider(int orientation, int minimum, int maximum, int initial)
	{
		 super();
	}


	/**
	* Adds a <code>IValueChangedListener</code> to the slider.
	*
	* @param listener 		 the <code>IValueChangedListener</code> to add
	* @see		#removeValueChangedListener
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* Returns the major tick spacing which represents the distance (measured in
	* values) between each major tick mark.
	*
	* @return		the number of values between major ticks
	* @see		#setMajorTickSpacing
	**/
	 public int getMajorTickSpacing()
	{
		return 0;
	}


	/**
	* Returns the maximum value supported by the slider.
	*
	* @return		the maximum value
	* @see		#setMaximum
	**/
	 public int getMaximum()
	{
		return 0;
	}


	/**
	* Returns the minimum value supported by the slider.
	*
	* @return		the minimum value
	* @see		#setMinimum
	**/
	 public int getMinimum()
	{
		return 0;
	}


	/**
	* Returns the minor tick spacing which represents the distance (measured in
	* values) between each minor tick mark.
	*
	* @return		the number of values between minor ticks
	* @see		#getMinorTickSpacing
	**/
	 public int getMinorTickSpacing()
	{
		return 0;
	}


	/**
	* Tells if labels are to be painted.
	*
	* @return		true if labels are painted
	* @see		#setPaintLabels
	**/
	 public boolean getPaintLabels()
	{
		return false;
	}


	/**
	* Tells if tick marks are to be painted.
	*
	* @return		true if tick marks are painted
	* @see		#setPaintTicks
	**/
	 public boolean getPaintTicks()
	{
		return false;
	}


	/**
	* Returns true if the slider track is to be painted.
	*
	* @return		true if the slider track is painted
	* @see		#setPaintTrack
	**/
	 public boolean getPaintTrack()
	{
		return false;
	}


	/**
	* Returns true if the knob resolves to the closest tick mark next to where the
	* user positioned the knob.
	*
	* @return		true if the value snaps to the nearest tick mark, else false
	* @see		#setSnapToTicks
	**/
	 public boolean getSnapToTicks()
	{
		return false;
	}


	/**
	* Returns the slider's value.
	*
	* @return		the slider's value
	* @see		#setValue
	**/
	 public int getValue()
	{
		return 0;
	}


	/**
	* Returns true if the slider's value-range is shown in reverse order.
	*
	* @return		true if the value-range is shown in reverse order
	* @see		#setInverted
	**/
	 public boolean getInverted()
	{
		return false;
	}


	/**
	* Returns an array of all the <code>IValueChangedListener</code>s added to this
	* <code>ULCSlider</code> with
<code>addValueChangedListener()</code>.
	*
	* @return		all <code>IValueChangedListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IValueChangedListener[] getValueChangedListeners()
	{
		return null;
	}

	 protected void updateValue(int value)
	{
	}


	/**
	* Return this slider's vertical or horizontal orientation.
	*
	* @return		<code>VERTICAL</code> or <code>HORIZONTAL</code>.
	* @see		#setOrientation
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Removes an <code>IValueChangedListener</code> from the slider.
	*
	* @param listener 		 the <code>IValueChangedListener</code> to remove
	* @see		#addValueChangedListener
	**/
	 public void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Set the scrollbars orientation to either <code>VERTICAL</code> or
	* <code>HORIZONTAL</code>.
	*
	* @param orientation 		 the orientation of the slider
	* @see		#getOrientation
	**/
	 public void setOrientation(int orientation)
	{
	}


	/**
	* Sets the major tick spacing. <code>majorTickSpacing</code> represents the
	* distance, measured in values, between each major tick
mark.
	*
	* @param majorTickSpacing 		 the major tick spacing of the slider
	* @see		#getMajorTickSpacing
	**/
	 public void setMajorTickSpacing(int majorTickSpacing)
	{
	}


	/**
	* Sets the maximum value of the slider.
	*
	* @param value 		 the maximum value of the slider
	* @see		#getMaximum
	**/
	 public void setMaximum(int value)
	{
	}


	/**
	* Sets the minimum value of the slider.
	*
	* @param value 		 the minimum value of the slider
	* @see		#getMinimum
	**/
	 public void setMinimum(int value)
	{
	}


	/**
	* Sets the minor tick spacing. <code>minorTickSpacing</code> represents the
	* distance, measured in values, between each minor tick
mark.
	*
	* @param minorTickSpacing 		 the minor tick spacing of the slider
	* @see		#getMinorTickSpacing
	**/
	 public void setMinorTickSpacing(int minorTickSpacing)
	{
	}


	/**
	* Determines whether labels are painted on the slider.
	*
	* @param paintLabels 		 true if the labels are painted on the slider.
	* @see		#getPaintLabels
	**/
	 public void setPaintLabels(boolean paintLabels)
	{
	}


	/**
	* Determines whether tick marks are painted on the slider.
	*
	* @param paintTicks 		 true if the tick marks are painted on the slider
	* @see		#getPaintTicks
	**/
	 public void setPaintTicks(boolean paintTicks)
	{
	}


	/**
	* Sets whether the slider track is to be painted.
	*
	* @param paintTrack 		 true if the slider track is to be painted, false otherwise
	* @see		#getPaintTrack
	**/
	 public void setPaintTrack(boolean paintTrack)
	{
	}


	/**
	* Specifying true makes the knob resolve to the closest tick mark next to where
	* the user positioned the knob.
	*
	* @param b 		 true to snap the knob to the closest tick mark
	* @see		#getSnapToTicks
	**/
	 public void setSnapToTicks(boolean b)
	{
	}


	/**
	* Sets the slider's current value.
	*
	* @param value 		 the current value of the slider
	* @see		#getValue
	**/
	 public void setValue(int value)
	{
	}


	/**
	* Sets whether the slider's value-range is to be shown in reverse order.
	*
	* @param inverted 		 true if the slider's value-range is to be shown in reverse order, false otherwise
	* @see		#getInverted
	**/
	 public void setInverted(boolean inverted)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Returns the map of labels to tick values.
	*
	* @return		the <code>Map</code> containing labels to values
	**/
	 public java.util.Map getLabelTable()
	{
		return null;
	}


	/**
	* Sets what label will be drawn at a value. The key-value pairs are of this
	* format:
<code>{ Integer value, com.ulcjava.base.application.ULCComponent
	* label}</code>.
	*
	* @param labels 		 the Map of labels to values
	* @see		#createStandardLabels(int, int)
	* @see		#getLabelTable
	**/
	 public void setLabelTable(java.util.Map labels)
	{
	}


	/**
	* Creates a Map that will draw text labels starting at the slider minimum using
	* the increment specified. For instance,
<code>createStandardLabels( 10
	* )</code>with slider minimum of zero will make labels for the values 0, 10,
	* 20,30, and so on.
	*
	* @param increment 		 at which the label should be drawn
	* @return		the Map of labels to values
	* @see		#setLabelTable
	**/
	 public java.util.Map createStandardLabels(int increment)
	{
		return null;
	}


	/**
	* Creates a map that will draw text labels starting at the start point specified
	* using the increment specified. For instance,
<code>createStandardLabels( 10,
	* 2)</code> will make labels for the values 2, 12, 22, 32, and so on.
	*
	* @param increment 		 at which the label should be drawn
	* @param start 		 the value on slider scale at which to begin labeling
	* @return		the Map of labels to values
	* @see		#setLabelTable
	* @exception		IllegalArgumentException if slider label start point out of range or if label increment is less than or equal to zero
	**/
	 public java.util.Map createStandardLabels(int increment, int start)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSliderDispatcher extends ULCComponentDispatcher
{

	 public  final void updateValue(int value)
	{
	}


}
}