package com.ulcjava.base.application;


	/**
	* The <code>ULCSpinner</code> component presents sequence of objects in a single
	* line input field.
<p>
<b>Features</b>
<ul>
<li>The user can a select an
	* object(which could be a number, date, etc.) from the sequence by stepping
	* through the sequence values
using the arrow buttons of the widget or using
	* thearrow keys.
<li>The user can also enter a legal value from the sequence
	* directly into the spinner.
<li>The sequence of values in a
	* <code>ULCSpinner</code> is defined by its <code>ISpinnerModel</code>. Please
	* see:
<code>ULCSpinnerListModel</code>, <code>ULCSpinnerNumberModel</code>,
	* and<code>ULCSpinnerDateModel</code>.
<li>ULCSpinner has a component called
	* the<code>editor</code> that displays and enables editing of the current
	* <code>value</code>.
This <code>editor</code> corresponds to the type of the
	* <code>model</code> and is created by the
	* <code>ULCSpinner</code>'s
constructoror can be changed by setting the
	* <code>editor</code> property.
<li>Background color, foreground color, font
	* andcursor can be customized using the corresponding setter methods on
	* ULCSpinner's editor
component.</li>
<li>An application can register an
	* <code>IValueChangedListener</code> to be notified about value changes of the
	* spinner.
</ul>
<b>Examples</b>
<p>
</p>
The following example shows a spinner
	* with number sequence and an
	* <code>IValueChangedListener</code>.

<pre>
ULCSpinnerNumberModel numberModel
	* =new ULCSpinnerNumberModel();
numberModel.setMaximum(new
	* Double(1000));
numberModel.setMinimum(new
	* Double(-1000));
numberModel.setStepSize(new
	* Double(200));
numberModel.setValue(new Double(-400));

final ULCSpinner
	* spinner = new ULCSpinner(numberModel);
ULCSpinner.NumberEditor numberEditor =
	* new ULCSpinner.NumberEditor(
spinner,
	* &quot;#,##0.00&quot;);
spinner.setEditor(numberEditor);
spinner.getEditor().set
	* Background(Color.yellow);
spinner.addValueChangedListener(new
	* IValueChangedListener() {
public void valueChanged(ValueChangedEvent event)
	* {
System.out.println(&quot;Value changed: &quot;
+
	* ((ULCSpinner)event.getSource()).getValue());
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent
	* @see		com.ulcjava.base.application.ISpinnerModel
	* @see		com.ulcjava.base.application.ULCAbstractSpinnerModel
	* @see		com.ulcjava.base.application.ULCSpinnerListModel
	* @see		com.ulcjava.base.application.ULCSpinnerNumberModel
	* @see		com.ulcjava.base.application.ULCSpinnerDateModel
	**/
 public class ULCSpinner extends com.ulcjava.base.application.ULCComponent
{


	/**
	* Constructs a <code>ULCSpinner</code> with an editor for the specified model.
	*
	* @param model 		 the <code>ISpinnerModel</code> that provides the sequence for the spinner
	**/
	 public ULCSpinner(com.ulcjava.base.application.ISpinnerModel model)
	{
		 super();
	}


	/**
	* Constructs a <code>ULCSpinner</code> with an <code>Integer
	* ULCSpinnerNumberModel</code>. The <code>model</code> represents a
sequence of
	* integers with initial value 0 and no minimum or maximum limits.
	*
	**/
	 public ULCSpinner()
	{
		 super();
	}


	/**
	* Method to create an appropriate <code>editor</code> corresponding to the
	* <code>model</code>. The following list shows a mapping
of model type to
	* editor:
<ul>
<li> <code>ULCSpinnerNumberModel =&gt;
	* ULCSpinner.ULCNumberEditor</code>
<li> <code>ULCSpinnerDateModel =&gt;
	* ULCSpinner.ULCDateEditor</code>
<li> <code>ULCSpinnerListModel =&gt;
	* ULCSpinner.ULCListEditor</code>
<li> <i>all others</i> =&gt;
	* <code>ULCSpinner.ULCDefaultEditor</code>
</ul>
	*
	* @return		the editor for the current model
	* @param model 		 the current model of the spinner
	* @see		#getModel
	* @see		#setEditor
	**/
	 protected com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor createEditor(com.ulcjava.base.application.ISpinnerModel model)
	{
		return null;
	}


	/**
	* Sets the model that deteremines the sequence of values presented by the
	* <code>ULCSpinner</code>. Setting the <code>model</code>
sets the
	* <code>editor</code> implicitly to the value returned by
	* <code>createEditor</code> if the editor has not already been set
explicitly.
	*
	* @param model 		 the new <code>ISpinnerModel</code> that provides the sequence of objects
	* @see		#getModel
	* @see		#getEditor
	* @see		#setEditor
	* @throws		IllegalArgumentException if model is <code>null</code>
	**/
	 public void setModel(com.ulcjava.base.application.ISpinnerModel model)
	{
	}


	/**
	* Sets the <code>editor</code> that displays the current value of the
	* <code>ISpinnerModel</code>.
	*
	* @param editor 		 the new editor
	* @see		#getEditor
	* @see		#createEditor
	* @see		#getModel
	* @throws		IllegalArgumentException if editor is <code>null</code>
	**/
	 public void setEditor(com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor editor)
	{
	}


	/**
	* Returns the current editor.
	*
	* @return		the current editor
	**/
	 public com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor getEditor()
	{
		return null;
	}


	/**
	* Returns the <code>ISpinnerModel</code> that defines the sequence of values for
	* this spinner.
	*
	* @return		the <code>ISpinnerModel</code> that provides sequence of objects to this spinner
	* @see		#setModel
	**/
	 public com.ulcjava.base.application.ISpinnerModel getModel()
	{
		return null;
	}


	/**
	* Returns the current value displayed by the editor.
<p>
This is a convenience
	* method that gets the value by delegating the call to the
	* model:

<pre>
getModel().getValue()
</pre>
	*
	* @return		the current value of the model
	* @see		#setValue
	* @see		ISpinnerModel#getValue
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}


	/**
	* Sets current value of the model. An <code>IllegalArgumentException</code> is
	* thrown if the <code>value</code> is not supported by
the
	* <code>ISpinnerModel</code> implementation.
<p>
This is a convenience method
	* that sets the value by delegating the call to the
	* model:

<pre>
getModel().setValue(value)
</pre>
	*
	* @param value 		 the value to set on the model
	* @throws		IllegalArgumentException if <code>value</code> is not valid
	* @see		#getValue
	* @see		ISpinnerModel#setValue
	**/
	 public void setValue(java.lang.Object value)
	{
	}


	/**
	* Adds an <code>IValueChangedListener</code> to this spinner. The listener is
	* notified with a <code>ValueChanged</code> event
whenever the model value
	* changes.
	*
	* @param listener 		 the <code>IValueChangedListener</code> to be notified
	* @see		#removeValueChangedListener
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* Removes an <code>IValueChangedListener</code> from this spinner.
	*
	* @param listener 		 the <code>IValueChangedListener</code> to be removed
	**/
	 public void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IValueChangedListener</code>s added to this
	* <code>ULCSpinner</code> with
<code>addValueChangedListener()</code>.
	*
	* @return		all <code>IValueChangedListener</code>s added or an empty array if no listeners have been added
	* @see		#addValueChangedListener
	**/
	 public com.ulcjava.base.application.event.IValueChangedListener[] getValueChangedListeners()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSpinnerDispatcher extends ULCComponentDispatcher
{


}
	/**
	* This class is the base class for <code>ULCSpinner editor</code> that displays
	* current value of the <code>model</code>.
	*
	**/
 public  static class ULCDefaultEditor extends com.ulcjava.base.application.ULCComponent
{


	/**
	* Creates a new editor for the given <code>ULCSpinner</code>.
	*
	* @param spinner 		 the <code>ULCSpinner</code> for which this editor will display the current value
	**/
	 public ULCDefaultEditor(com.ulcjava.base.application.ULCSpinner spinner)
	{
		 super();
	}


	/**
	* Returns the <code>ULCSpinner</code> for which this editor displays the current
	* value.
	*
	* @return		the <code>ULCSpinner</code> for which this editor displays the current value
	**/
	 public com.ulcjava.base.application.ULCSpinner getSpinner()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class DefaultEditorDispatcher extends ULCComponentDispatcher
{


}
}
	/**
	* An editor for <code>ULCSpinner</code> that displays a sequence of dates using
	* a<code>ULCSpinnerDateModel</code>. The date
format can be specified as a
	* <code>String</code>.
<p>
<b>Examples</b>
<p>
The following example creates a
	* spinner editor with number format.

<pre>
ULCSpinnerDateModel dateModel = new
	* ULCSpinnerDateModel();
ULCSpinner spinner = new
	* ULCSpinner(dateModel);
ULCSpinner.DateEditor dateEditor = new
	* ULCSpinner.DateEditor(spinner,
&quot;dd-MM-yyyy&quot;);
spinner.setEditor(dateE
	* ditor);
</pre>
	*
	**/
 public  static class ULCDateEditor extends com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor
{


	/**
	* Constructs a <code>ULCSpinner.ULCDateEditor</code> that supports displaying
	* andediting the value of a
<code>ULCSpinnerDateModel</code>.
	*
	* @param spinner 		 the <code>ULCSpinner</code> for which this editor will display the current value
	* @exception		IllegalArgumentException if the spinner's model is not an instance of <code>ULCSpinnerDateModel</code>
	* @see		#getModel
	* @see		ULCSpinnerDateModel
	**/
	 public ULCDateEditor(com.ulcjava.base.application.ULCSpinner spinner)
	{
		 super((com.ulcjava.base.application.ULCSpinner)null);
	}


	/**
	* Constructs a <code>ULCSpinner.ULCDateEditor</code> that supports displaying
	* andediting the value of a
<code>ULCSpinnerDateModel</code> with the specified
	* date format pattern.
	*
	* @param spinner 		 <code>ULCSpinner</code> for which this editor will display the current value
	* @param dateFormatPattern 		 the pattern that is used to display and parse the value of the text field.
	* @exception		IllegalArgumentException if the spinners model is not an instance of <code>ULCSpinnerDateModel</code>
	* @see		#getModel
	* @see		ULCSpinnerDateModel
	* @see		java.text.SimpleDateFormat
	**/
	 public ULCDateEditor(com.ulcjava.base.application.ULCSpinner spinner, java.lang.String dateFormatPattern)
	{
		 super((com.ulcjava.base.application.ULCSpinner)null);
	}


	/**
	* Returns the model for which this editor displays the current value.
	*
	* @return		the <code>ULCSpinnerDateModel</code> for which this editor displays the current value.
	**/
	 public com.ulcjava.base.application.ULCSpinnerDateModel getModel()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


}
	/**
	* An editor for <code>ULCSpinner</code> that displays a sequence of values from
	* a<code>ULCSpinnerListModel</code>.
	*
	**/
 public  static class ULCListEditor extends com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor
{


	/**
	* Constructs a <code>ULCSpinner.ULCListEditor</code> that supports displaying
	* andediting the values of a
<code>ULCSpinnerListModel</code>.
	*
	* @param spinner 		 the <code>ULCSpinner</code> for which this editor will display the current value
	* @exception		IllegalArgumentException if the spinner's model is not an instance of <code>ULCSpinnerListModel</code>
	* @see		#getModel
	* @see		ULCSpinnerListModel
	**/
	 public ULCListEditor(com.ulcjava.base.application.ULCSpinner spinner)
	{
		 super((com.ulcjava.base.application.ULCSpinner)null);
	}


	/**
	* Returns the model for which this editor displays the current value.
	*
	* @return		the <code>ULCSpinnerListModel</code> for which this editor displays the current value
	**/
	 public com.ulcjava.base.application.ULCSpinnerListModel getModel()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


}
	/**
	* An editor for <code>ULCSpinner</code> that displays a sequence of
	* <code>Number</code>s from a <code>ULCSpinnerNumberModel</code>.
The number
	* format can be specified as a <code>String</code>.
	* <b>Example:</b>
<p>
<b>Examples</b>
<p>
The following example creates a
	* spinner editor with number format.

<pre>
ULCSpinner.NumberEditor
	* numberEditor= new ULCSpinner.NumberEditor(
spinner,
	* &quot;#,##0.000&quot;);
spinner.setEditor(numberEditor);
</pre>
	*
	**/
 public  static class ULCNumberEditor extends com.ulcjava.base.application.ULCSpinner$ULCDefaultEditor
{


	/**
	* Constructs a <code>ULCSpinner.ULCNumberEditor</code> that supports displaying
	* and editing the number value of a
<code>ULCSpinnerNumberModel</code>.
	*
	* @param spinner 		 the <code>ULCSpinner</code> for which this editor will display the current value
	* @exception		IllegalArgumentException if the spinner's model is not an instance of <code>ULCSpinnerNumberModel</code>
	* @see		#getModel
	* @see		ULCSpinnerNumberModel
	**/
	 public ULCNumberEditor(com.ulcjava.base.application.ULCSpinner spinner)
	{
		 super((com.ulcjava.base.application.ULCSpinner)null);
	}


	/**
	* Constructs a <code>ULCSpinner.ULCNumberEditor</code> that supports displaying
	* and editing the number value of a
<code>ULCSpinnerNumberModel</code> with the
	* specified number format pattern.
	*
	* @param spinner 		 the <code>ULCSpinner</code> for which this editor will display the current value
	* @param decimalFormatPattern 		 the pattern that's used to display and parse the value of the text field.
	* @exception		IllegalArgumentException if the spinners model is not an instance of <code>ULCSpinnerNumberModel</code> or if
<code>decimalFormatPattern</code> is not a legal argument to <code>DecimalFormat</code>
	* @see		ULCSpinnerNumberModel
	* @see		java.text.DecimalFormat
	**/
	 public ULCNumberEditor(com.ulcjava.base.application.ULCSpinner spinner, java.lang.String decimalFormatPattern)
	{
		 super((com.ulcjava.base.application.ULCSpinner)null);
	}


	/**
	* Returns the model for which this editor displays the current value.
	*
	* @return		the <code>ULCSpinnerNumberModel</code> for which this editor displays the current value
	**/
	 public com.ulcjava.base.application.ULCSpinnerNumberModel getModel()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


}
}