package com.ulcjava.base.application;


	/**
	* This class implements <code>ISpinnerModel</code> for providing a sequence of
	* <code>Date</code>s.
<p>
</p>
<b>Features</b>
<ul>
<li>The lower limit of the
	* sequence is defined by the <code>start</code> property. A null value
	* indicatesno lower bound.
<li>The upper limit of the sequence is defined by
	* the<code>end</code> property. A null value indicates no upper bound.
<li>The
	* size of the increase or decrease in current value with each step is defined
	* bya property called <code>calendarField</code>.
The value of the
	* <code>calendarField</code> property must be one of the
	* <code>java.util.Calendar</code> constants that specify a
field within a
	* <code>Calendar</code>. The date is changed forwards or backwards by this
	* amount. For example, if
<code>calendarField</code> is
	* <code>Calendar.DAY_OF_WEEK</code>, then next value is a <code>Date</code>
	* that's 24 hours after the
current <code>value</code>, and previous value is a
	* <code>Date</code> that's 24 hours earlier.
<p>
The legal values for
	* <code>calendarField</code>
	* are:
<ul>
<li><code>Calendar.ERA</code>
<li><code>Calendar.YEAR</code>
<li><cod
	* e>Calendar.MONTH</code>
<li><code>Calendar.WEEK_OF_YEAR</code>
<li><code>Calenda
	* r.WEEK_OF_MONTH</code>
<li><code>Calendar.DAY_OF_MONTH</code>
<li><code>Calendar
	* .DAY_OF_YEAR</code>
<li><code>Calendar.DAY_OF_WEEK</code>
<li><code>Calendar.DAY
	* _OF_WEEK_IN_MONTH</code>
<li><code>Calendar.AM_PM</code>
<li><code>Calendar.HOUR
	* </code>
<li><code>Calendar.HOUR_OF_DAY</code>
<li><code>Calendar.MINUTE</code>
<
	* li><code>Calendar.SECOND</code>
<li><code>Calendar.MILLISECOND</code>
</ul>
<li>
	* This class inherits a <code>IValueChangedListener</code> list that is
	* notifiedwhenever the model's <code>value</code>
	* changes.
</ul>
<b>Examples</b><p>
</p>

<pre>
Calendar calendar =
	* Calendar.getInstance();
Date initDate =
	* calendar.getTime();
calendar.add(Calendar.YEAR, -10);
Date earliestDate =
	* calendar.getTime();
calendar.add(Calendar.YEAR, 20);
Date latestDate =
	* calendar.getTime();
ULCSpinnerDateModel dateModel = new
	* ULCSpinnerDateModel(initDate,
earliestDate, latestDate,
	* Calendar.YEAR);
ULCSpinner spinner = new ULCSpinner(dateModel);
</pre>

<p>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCSpinner
	* @see		com.ulcjava.base.application.ISpinnerModel
	* @see		com.ulcjava.base.application.ULCAbstractSpinnerModel
	* @see		Date
	* @see		Calendar
	**/
 public class ULCSpinnerDateModel extends com.ulcjava.base.application.ULCAbstractSpinnerModel
{


	/**
	* Constructs a <code>ULCSpinnerDateModel</code> that represents a sequence of
	* dates between <code>start</code> and <code>end</code>
dates. The current date
	* <code>value</code> is incremented or decremented by the
	* <code>calendarField</code> time unit (refer to
<code>add</code> method in
	* <code>java.util.Calendar</code>).
<p>
A <code>null</code> value for
	* <code>start</code> and <code>end</code> parameters means that the range
	* doesn't have an upper or
lower bound. An
	* <code>IllegalArgumentException</code>is thrown if <code>value</code> or
	* <code>calendarField</code> is
<code>null</code>, or if both
	* <code>start</code>and <code>end</code> are specified and <code>start &gt;
	* end</code>. An
<code>IllegalArgumentException</code> is also thrown if value
	* is not between <code>start</code> and <code>end</code> dates.
	*
	* @param value 		 the current (non <code>null</code>) value of the model
	* @param start 		 the first date in the sequence or <code>null</code>
	* @param end 		 the last date in the sequence or <code>null</code>
	* @param calendarField 		 one of
<ul>
<li><code>Calendar.ERA</code>
<li><code>Calendar.YEAR</code>
<li><code>Calendar.MONTH</code>
<li><code>Calendar.WEEK_OF_YEAR</code>
<li><code>Calendar.WEEK_OF_MONTH</code>
<li><code>Calendar.DAY_OF_MONTH</code>
<li><code>Calendar.DAY_OF_YEAR</code>
<li><code>Calendar.DAY_OF_WEEK</code>
<li><code>Calendar.DAY_OF_WEEK_IN_MONTH</code>
<li><code>Calendar.AM_PM</code>
<li><code>Calendar.HOUR</code>
<li><code>Calendar.HOUR_OF_DAY</code>
<li><code>Calendar.MINUTE</code>
<li><code>Calendar.SECOND</code>
<li><code>Calendar.MILLISECOND</code>
</ul>
	* @throws		IllegalArgumentException if <code>value</code> or <code>calendarField</code> are <code>null</code>, if
<code>calendarField</code> isn't valid, or if the value is not between <code>start and end</code>.
	* @see		#setValue
	* @see		#setStart
	* @see		#setEnd
	* @see		#setCalendarField
	* @see		Calendar#add
	**/
	 public ULCSpinnerDateModel(java.util.Date value, java.util.Date start, java.util.Date end, int calendarField)
	{
	}


	/**
	* Constructs a <code>ULCSpinnerDateModel</code> whose initial <code>value</code>
	* is the current date, <code>calendarField</code>
is equal to
	* <code>Calendar.DAY_OF_MONTH</code>, and for which there are no
	* <code>start</code>/<code>end</code> limits.
	*
	**/
	 public ULCSpinnerDateModel()
	{
	}


	/**
	* Sets the lower limit (start) for <code>Date</code>s in this sequence. A
	* <code>null</code> value means there is no lower limit.
The API user should
	* ensure that the invariant <code>(start &lt;= value &lt;= end)</code> remains
	* valid.
	*
	* @param start 		 defines the first date in the sequence
	* @see		#getStart
	* @see		#setEnd
	* @see		#addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener)
	**/
	 public void setStart(java.util.Date start)
	{
	}


	/**
	* Returns the first <code>Date</code> (start) of the sequence.
	*
	* @return		the start date
	* @see		#setStart
	**/
	 public java.util.Date getStart()
	{
		return null;
	}


	/**
	* Sets the upper limit (end) for <code>Date</code>s in this sequence. A
	* <code>null</code> value means there is no upper limit. The
API user should
	* ensure that the invariant <code>(start &lt;= value &lt;= end)</code> remains
	* valid.
	*
	* @param end 		 defines the last date in the sequence
	* @see		#getEnd
	**/
	 public void setEnd(java.util.Date end)
	{
	}


	/**
	* Returns the last <code>Date</code> (end) in the sequence.
	*
	* @return		the end date
	* @see		#setEnd
	**/
	 public java.util.Date getEnd()
	{
		return null;
	}


	/**
	* Sets the step size by which the date value is incremented or decremented. The
	* <code>calendarField</code> parameter must be one of
the <code>Calendar</code>
	* field constants like <code>Calendar.MONTH</code> or
	* <code>Calendar.MINUTE</code>.
	*
	* @param calendarField 		 one of
<ul>
<li><code>Calendar.ERA</code>
<li><code>Calendar.YEAR</code>
<li><code>Calendar.MONTH</code>
<li><code>Calendar.WEEK_OF_YEAR</code>
<li><code>Calendar.WEEK_OF_MONTH</code>
<li><code>Calendar.DAY_OF_MONTH</code>
<li><code>Calendar.DAY_OF_YEAR</code>
<li><code>Calendar.DAY_OF_WEEK</code>
<li><code>Calendar.DAY_OF_WEEK_IN_MONTH</code>
<li><code>Calendar.AM_PM</code>
<li><code>Calendar.HOUR</code>
<li><code>Calendar.HOUR_OF_DAY</code>
<li><code>Calendar.MINUTE</code>
<li><code>Calendar.SECOND</code>
<li><code>Calendar.MILLISECOND</code>
</ul>
	* @see		#getCalendarField
	* @see		Calendar#add
	**/
	 public void setCalendarField(int calendarField)
	{
	}


	/**
	* Returns the <code>calendarField</code> that is added to or subtracted from the
	* current value when the date is incremented or
decremented.
	*
	* @return		the <code>calendarField</code> value
	* @see		#setCalendarField
	**/
	 public int getCalendarField()
	{
		return 0;
	}


	/**
	* Returns the current element in this sequence of <code>Date</code>s. This
	* methodis equivalent to <code>(Date)getValue</code>.
	*
	* @return		the <code>value</code> as Date
	* @see		#setValue
	**/
	 public java.util.Date getDate()
	{
		return null;
	}


	/**
	* Returns the current element in this sequence of <code>Date</code>s.
	*
	* @return		the <code>value</code> as Object
	* @see		#setValue
	* @see		#getDate
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}


	/**
	* Sets the current <code>Date</code> for this sequence. An
	* <code>IllegalArgumentException</code> is thrown if <code>value</code>
is
	* <code>null</code>. The API user should ensure that the <code>(start &lt;=
	* value &lt;= end)</code> invariant remains true.
<p>
This method fires a
	* <code>ValueChangedEvent</code> if the <code>value</code> has changed.
	*
	* @param value 		 the current <code>Date</code> to set for this sequence
	* @throws		IllegalArgumentException if value is <code>null</code> or not a <code>Date</code>
	* @see		#getDate
	* @see		#getValue
	* @see		#addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener)
	**/
	 public void setValue(java.lang.Object value)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateValue(java.util.Date value)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSpinnerDateModelDispatcher extends ULCAbstractSpinnerModelDispatcher
{


	/**
	* Updates the model's value.
	*
	* @param value 		 the value to update
	**/
	 public  final void updateValue(java.util.Date value)
	{
	}


}
}