package com.ulcjava.base.application;


	/**
	* This class implements <code>ISpinnerModel</code> whose values are defined by
	* anarray or a <code>List</code>. <b>Features</b>
<ul>
<li> Stores a reference
	* to a list of values.
<li> This class inherits a
	* <code>IValueChangedListener</code> list that is notified whenever the model's
	* <code>value</code> changes.
</ul>
<b>Examples</b>
<p>
</p>
The following code
	* creates a list of names of the days of the week:

<pre>
String[] days = new
	* DateFormatSymbols().getWeekdays();
ISpinnerModel model = new
	* ULCSpinnerListModel(new ArrayList(Arrays.asList(
days).subList(1,
	* 8)));
ULCSpinner spinner = new ULCSpinner(model);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCSpinner
	* @see		com.ulcjava.base.application.ISpinnerModel
	* @see		com.ulcjava.base.application.ULCAbstractSpinnerModel
	**/
 public class ULCSpinnerListModel extends com.ulcjava.base.application.ULCAbstractSpinnerModel
{


	/**
	* Constructs a <code>ULCSpinnerListModel</code> whose sequence of values is
	* defined by the specified <code>List</code>. The
initial value (<i>current
	* element</i>) of the model will be <code>values.get(0)</code>. An
	* <code>IllegalArgumentException</code>
is thrown if <code>values</code> is
	* <code>null</code> or has zero size.
	*
	* @param values 		 the sequence of objects that will be provided by this model
	* @throws		IllegalArgumentException if the list of <code>values</code> is <code>null</code> or empty
	**/
	 public ULCSpinnerListModel(java.util.List values)
	{
	}


	/**
	* Constructs a <code>ULCSpinnerListModel</code> whose sequence of values is
	* defined by the specified array. The initial value of the
model will be
	* <code>values[0]</code>. An <code>IllegalArgumentException</code> is thrown if
	* <code>values</code> is
<code>null</code> or has zero size.
	*
	* @param values 		 the sequence of objects that will be provided by this model
	* @throws		IllegalArgumentException if <code>values</code> is <code>null</code> or zero length
	**/
	 public ULCSpinnerListModel(java.lang.Object[] values)
	{
	}


	/**
	* Creates an effectively empty <code>ULCSpinnerListModel</code>. The model's
	* listwill contain a single <code>"empty"</code>
string element.
	*
	**/
	 public ULCSpinnerListModel()
	{
	}


	/**
	* Returns the <code>List</code> that defines the sequence for this model.
	*
	* @return		the value of the <code>list</code> of objects in the sequence
	* @see		#setList
	**/
	 public java.util.List getList()
	{
		return null;
	}


	/**
	* Sets the list that defines this sequence and resets the index of the model's
	* <code>value</code> to zero. The model stores a
reference to the new
	* <code>list</code>.
<p>
This method fires a <code>ValueChangedEvent</code> if
	* <code>list</code> is not equal to the current list.
	*
	* @param list 		 the sequence that this model will represents
	* @throws		IllegalArgumentException if <code>list</code> is <code>null</code> or zero length
	* @see		#getList
	**/
	 public void setList(java.util.List list)
	{
	}


	/**
	* Returns the current element of the sequence.
	*
	* @return		the current value of the model
	* @see		#setValue
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}


	/**
	* Sets the current element of the sequence and notifies
	* <code>IValueChangedListeners</code>. An
<code>IllegalArgumentException</code>
	* is thrown when the specified value is not equal to an element of the
	* underlying sequence.
	*
	* @param element 		 the sequence element that will be model's current value
	* @throws		IllegalArgumentException if the specified value is invalid
	* @see		#getValue
	* @see		#addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener)
	**/
	 public void setValue(java.lang.Object element)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateValue(java.lang.Object value)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSpinnerListModelDispatcher extends ULCAbstractSpinnerModelDispatcher
{


	/**
	* Updates the model's value.
	*
	* @param value 		 the value to update
	**/
	 public  final void updateValue(java.lang.Object value)
	{
	}


}
}