package com.ulcjava.base.application;


	/**
	* This class implements <code>ISpinnerModel</code> that provides a sequence of
	* <code>Number</code>s.
<p>
</p>
<b>Features</b>
<ul>
<li>The lower limit of
	* thesequence is defined by the <code>minimum</code> property. A null value
	* indicates no lower bound.
<li>The upper limit of the sequence is defined by
	* the <code>maximum</code> property. A null value indicates no upper
	* bound.
<li>The size of the increase or decrease in current value with each
	* step is defined by a property called <code>stepSize</code>.
<li> This class
	* inherits a <code>IValueChangedListener</code> list that is notified whenever
	* the model's <code>value</code> changes.
</ul>
<b>Examples</b>
<p>
The
	* following code shows how to create a <code>ULCSpinnerNumberModel</code> for
	* the integer range 0 to 100, with 50 as the initial
value:

<pre>
Integer
	* value= new Integer(50);
Integer min = new Integer(0);
Integer max = new
	* Integer(100);
Integer step = new Integer(1);
ULCSpinnerNumberModel model =
	* newULCSpinnerNumberModel(value, min, max,
step);
</pre>

<p>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCSpinner
	* @see		com.ulcjava.base.application.ULCAbstractSpinnerModel
	**/
 public class ULCSpinnerNumberModel extends com.ulcjava.base.application.ULCAbstractSpinnerModel
{


	/**
	* Constructs a <code>ULCSpinnerNumberModel</code> that represents a closed
	* sequence of numbers from <code>minimum</code> to
<code>maximum</code>. The
	* current value is incremented or decremented by the value of the property
	* <code>stepSize</code> A
<code>null</code> value for <code>minimum</code> and
	* <code>maximum</code> parameters means that the range doesn't have an upper
or
	* lower bound. An <code>IllegalArgumentException</code> is thrown if
	* <code>value</code> or <code>stepSize</code> is
<code>null</code>, or if both
	* <code>minimum</code> and <code>maximum</code> are specified and
<code>minimum
	* &gt; maximum</code>. An <code>IllegalArgumentException</code> is also thrown
	* if the value is not between
<code>minimum and maximum</code>.
	*
	* @param value 		 the current value of the model
	* @param minimum 		 the first number in the sequence or <code>null</code>
	* @param maximum 		 the last number in the sequence or <code>null</code>
	* @param stepSize 		 the difference between elements of the sequence
	* @throws		IllegalArgumentException if stepSize or value is <code>null</code> or if the value is not between
<code>minimum and maximum</code>
	**/
	 public ULCSpinnerNumberModel(java.lang.Number value, java.lang.Number minimum, java.lang.Number maximum, java.lang.Number stepSize)
	{
	}


	/**
	* Creates a <code>ULCSpinnerNumberModel</code> with the specified
	* <code>value</code>, <code>minimum</code>/<code>maximum</code>
bounds, and
	* <code>stepSize</code> all of which are <code>int</code>s.
	*
	* @param value 		 the current value of the model
	* @param minimum 		 the first number in the sequence
	* @param maximum 		 the last number in the sequence
	* @param stepSize 		 the difference between elements of the sequence
	* @throws		IllegalArgumentException if the value is not between <code>minimum and maximum</code>
	**/
	 public ULCSpinnerNumberModel(int value, int minimum, int maximum, int stepSize)
	{
	}


	/**
	* Creates a <code>ULCSpinnerNumberModel</code> with the specified
	* <code>value</code>, <code>minimum</code>/<code>maximum</code>
bounds, and
	* <code>stepSize</code> <code>double</code>s.
	*
	* @param value 		 the current value of the model
	* @param minimum 		 the first number in the sequence
	* @param maximum 		 the last number in the sequence
	* @param stepSize 		 the difference between elements of the sequence
	* @throws		IllegalArgumentException if the value is not between <code>minimum and maximum</code>
	**/
	 public ULCSpinnerNumberModel(double value, double minimum, double maximum, double stepSize)
	{
	}


	/**
	* Constructs a <code>ULCSpinnerNumberModel</code> with no <code>minimum</code>
	* or<code>maximum</code> values,
<code>stepSize</code> equal to one, and an
	* initial value of zero.
	*
	**/
	 public ULCSpinnerNumberModel()
	{
	}


	/**
	* Sets the lower limit for numbers in this sequence. A <code>null</code> value
	* means there is no lower limit. The API user should
ensure that the invariant
	* <code>(minimum &lt;= value &lt= maximum)</code> remains valid.
	*
	* @param minimum 		 the <code>minimum</code> value for the sequence
	* @see		#getMinimum
	**/
	 public void setMinimum(java.lang.Number minimum)
	{
	}


	/**
	* Returns the first number (minimum) in this sequence.
	*
	* @return		the <code>minimum</code> value in the sequence
	* @see		#setMinimum
	**/
	 public java.lang.Number getMinimum()
	{
		return null;
	}


	/**
	* Sets the upper limit (maximum) for numbers in this sequence. A
	* <code>null</code> value means there is no upper limit. The API user
should
	* ensure that the invariant <code>(minimum &lt;= value &lt= maximum)</code>
	* remains valid.
	*
	* @param maximum 		 the <code>maximum</code> value for the sequence
	* @see		#getMaximum
	**/
	 public void setMaximum(java.lang.Number maximum)
	{
	}


	/**
	* Returns the last number (maximum) in the sequence.
	*
	* @return		the <code>maximum</code> value in the sequence
	* @see		#setMaximum
	**/
	 public java.lang.Number getMaximum()
	{
		return null;
	}


	/**
	* Sets the step size by which the date value is incremented or decremented. An
	* <code>IllegalArgumentException</code> is thrown if
<code>stepSize</code> is
	* <code>null</code>.
	*
	* @param stepSize 		 the size of the value change
	* @see		#getStepSize
	**/
	 public void setStepSize(java.lang.Number stepSize)
	{
	}


	/**
	* Returns the step size i.e. the value added or subtracted from the current
	* number when it is incremented or decremented.
	*
	* @return		the value of <code>stepSize</code>
	* @see		#setStepSize
	**/
	 public java.lang.Number getStepSize()
	{
		return null;
	}


	/**
	* Returns the value of the current element of the sequence as <code>Number</code>.
	*
	* @return		the value
	* @see		#setValue
	**/
	 public java.lang.Number getNumber()
	{
		return null;
	}


	/**
	* Returns the value of the current element of the sequence.
	*
	* @return		the value property
	* @see		#setValue
	* @see		#getNumber
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}


	/**
	* Sets the current value for this sequence. An
	* <code>IllegalArgumentException</code> is thrown if <code>value</code>
	* is
<code>null</code> or is not a <code>Number</code>. The API user should
	* ensure that the
<code>(minimum &lt;= value &lt;= maximum)</code> invariant
	* remains true and that the value is part of the sequence i.e. it is
modulo the
	* <code>stepSize</code>.
<p>
This method fires a <code>ValueChangedEvent</code>
	* if the <code>value</code> has changed.
	*
	* @param value 		 the current (non <code>null</code>) <code>Number</code> for this sequence
	* @throws		IllegalArgumentException if <code>value</code> is <code>null</code> or not a <code>Number</code>
	* @see		#getNumber
	* @see		#getValue
	* @see		#addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener)
	**/
	 public void setValue(java.lang.Object value)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateValue(java.lang.Number value)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSpinnerNumberModelDispatcher extends ULCAbstractSpinnerModelDispatcher
{


	/**
	* Updates the model's value.
	*
	* @param value 		 the value to update
	**/
	 public  final void updateValue(java.lang.Number value)
	{
	}


}
}