package com.ulcjava.base.application;


	/**
	* The <code>ULCSplitPane</code> is a special box component containing exactly
	* twocells. A <code>ULCSplitPane</code> can therefore
contain two ULC
	* components. The two components are graphically divided, based on the look and
	* feel implementation. The user can
interactively adjust how the space is
	* distributed among the two components.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCSplitPane</code> component is a layout component providing two
	* cells.It contains exactly two components. These
components can also be layout
	* components. In this way, more components can be added using nesting. The two
	* components can be arranged
either horizontally or vertically.
<li>The
	* available space is split up by a divider (the visualization of the divider
	* depends on the look and feel implementation). The
location of this divider
	* canbe adjusted manually by the user, and programmatically by the ULC
	* application.
<li>The <code>ULCSplitPane</code> component can be configured to
	* continuously redraw the contained components while dragging
	* the
divider.
</ul><b>Examples</b>
<p>
</p>
The following excerpt shows an
	* example of nested split panes. A master-details view shows a tree on the left
	* side and the details about
the selected node are shown on the right side. The
	* right side is again split up (in a vertical way) into an input form and a
	* table view.

<pre>
ULCSplitPane mainSplitPane = new
	* ULCSplitPane();
mainSplitPane.setOrientation(ULCSplitPane.HORIZONTAL_SPLIT);
ma
	* inSplitPane.setLeftComponent(createMasterTree());
ULCSplitPane
	* detailsSplitPane= new ULCSplitPane(
ULCSplitPane.VERTICAL_SPLIT, // vertical
	* alignment
createDetailsInfoForm(), // upper component
createDetailsTable() //
	* lower component
);
mainSplitPane.setRightComponent(detailsSplitPane);
</pre>
	*
	* @ulc.application		
	* @see		ULCBoxPane
	**/
 public class ULCSplitPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* The unknown relative divider location.
	*
	**/
	 public  final  static double UNKNOWN_DIVIDER_LOCATION = 0.0d;

	/**
	* The unknown absolute divider location.
	*
	**/
	 public  final  static int UNKNOWN_DIVIDER_LOCATION_ABSOLUTE = 0;

	/**
	* Vertical split indicates the <code>ULCComponent</code>s are split along the y
	* axis, e.g., two <code>ULCComponent</code>s will
be split one on top of the
	* other.
	*
	**/
	 public  final  static int VERTICAL_SPLIT = 0;

	/**
	* Horizontal split indicates the <code>ULCComponent</code>s are split along the
	* xaxis, e.g., two <code>ULCComponent</code>s will
be split one to the left of
	* the other.
	*
	**/
	 public  final  static int HORIZONTAL_SPLIT = 0;

	/**
	* Used to add the left component of the split pane.
	*
	**/
	 public  final  static java.lang.String LEFT = null;

	/**
	* Used to add the right component of the split pane.
	*
	**/
	 public  final  static java.lang.String RIGHT = null;

	/**
	* Used to add the top component of the split pane.
	*
	**/
	 public  final  static java.lang.String TOP = null;

	/**
	* Used to add the bottom component of the split pane.
	*
	**/
	 public  final  static java.lang.String BOTTOM = null;


	/**
	* Creates a new <code>ULCSplitPane</code> configured to arrange the child
	* components side-by-side horizontally with no continuous
layout. Two labels
	* areused for the left and right for the components.
	*
	**/
	 public ULCSplitPane()
	{
		 super();
	}


	/**
	* Creates a new <code>ULCSplitPane</code> with the specified orientation and no
	* continuous layout.
	*
	* @param orientation 		 <code>HORIZONTAL_SPLIT</code> or <code>VERTICAL_SPLIT</code>
	**/
	 public ULCSplitPane(int orientation)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCSplitPane</code> with the specified orientation and
	* redrawing style. If <code>newContinuousLayout</code>
is true, the components
	* are redrawn continuously as the divider changes position. If
	* <code>newContinuousLayout</code>is false, the
components are redrawn only
	* whenthe divider position stops.
	*
	* @param orientation 		 <code>HORIZONTAL_SPLIT</code> or <code>VERTICAL_SPLIT</code>
	* @param continuousLayout 		 true for the components to redraw continuously, false to wait until the divider position stops
	**/
	 public ULCSplitPane(int orientation, boolean continuousLayout)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCSplitPane</code> with the specified orientation and no
	* continuous layout.
	*
	* @param orientation 		 <code>HORIZONTAL_SPLIT</code> or <code>VERTICAL_SPLIT</code>
	* @param leftComponent 		 the <code>ULCComponent</code> that will appear on the left (horizontally split pane) or at the top (vertically
split pane)
	* @param rightComponent 		 the <code>ULCComponent</code> that will appear on the right (horizontally split pane) or at the bottom
(vertically split pane)
	**/
	 public ULCSplitPane(int orientation, com.ulcjava.base.application.ULCComponent leftComponent, com.ulcjava.base.application.ULCComponent rightComponent)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCSplitPane</code> with the specified orientation and
	* redrawing style, and with the specified components.
	* If
<code>newContinuousLayout</code> is true, the components are redrawn
	* continuously as the divider changes position.
	* If
<code>newContinuousLayout</code>is false, the components are redrawn only
	* when the divider position stops.
	*
	* @param orientation 		 <code>HORIZONTAL_SPLIT</code> or <code>VERTICAL_SPLIT</code>
	* @param continuousLayout 		 true for the components to redraw continuously, false to wait until the divider position stops
	* @param leftComponent 		 the <code>ULCComponent</code> that will appear on the left (horizontally split pane) or at the top (vertically
split pane)
	* @param rightComponent 		 the <code>ULCComponent</code> that will appear on the right (horizontally split pane) or at the bottom
(vertically split pane)
	**/
	 public ULCSplitPane(int orientation, boolean continuousLayout, com.ulcjava.base.application.ULCComponent leftComponent, com.ulcjava.base.application.ULCComponent rightComponent)
	{
		 super();
	}


	/**
	* Adds a component to the container with the specified constraints.
<p>
The
	* constraints have to be one of the following
	* constants:
<p>
<ul>
<li>ULCSplitPane.LEFT
<li>ULCSplitPane.RIGHT
<li>ULCSplitPa
	* ne.TOP
<li>ULCSplitPane.BOTTOM
</ul>
<p>
If the constraints is null, the
	* component will be added to the left
<p>
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints.
	* @return		the component argument.
	* @throws		IllegalArgumentException if the constraint is not a String and is not one of the above values
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Removes the specified component from the pane.
	*
	* @param component 		 the component to be removed
	**/
	 public void remove(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns the location of the divider.
	*
	* @return		a double in the range [0.0 ... 1.0] specifying the location of the divider or {@link #UNKNOWN_DIVIDER_LOCATION}, if the
location is unknown
	**/
	 public double getDividerLocationRelative()
	{
		return 0.0d;
	}


	/**
	* Returns the absolute location of the divider as a Swing UI-specific value
	* (typically a pixel count).
<p>
</p>
Note that the absolute divider location
	* isalways unknown right after invoking {@link #setDividerLocation(int)}. The
	* reason for this
is that the actual location value on the client side cannot
	* beknown, because Swing might adjust it due to layout constraints.
However the
	* correct value will become known as part of the next server round trip. The
	* absolute divider location is also unknown
right after the invocation of
	* {@link#setDividerLocation(double)}.
	*
	* @return		the location of the divider (a value between 1 and {@link Integer#MAX_VALUE}) or {@link #UNKNOWN_DIVIDER_LOCATION_ABSOLUTE},
if the location is unknown
	**/
	 public int getDividerLocation()
	{
		return 0;
	}


	/**
	* Returns the size of the divider.
	*
	* @return		an integer giving the size of the divider in pixels
	**/
	 public int getDividerSize()
	{
		return 0;
	}


	/**
	* Returns the component to the left of (or above) the divider.
	*
	* @return		the <code>ULCComponent</code> displayed in that position
	**/
	 public com.ulcjava.base.application.ULCComponent getLeftComponent()
	{
		return null;
	}


	/**
	* Returns the component above, or to the left of the divider.
	*
	* @return		the <code>Component</code> displayed in that position
	**/
	 public com.ulcjava.base.application.ULCComponent getTopComponent()
	{
		return null;
	}


	/**
	* Returns the component to the right of (or below) the divider.
	*
	* @return		the <code>ULCComponent</code> displayed in that position
	**/
	 public com.ulcjava.base.application.ULCComponent getRightComponent()
	{
		return null;
	}


	/**
	* Returns the component below, or to the right of the divider.
	*
	* @return		the <code>Component</code> displayed in that position
	**/
	 public com.ulcjava.base.application.ULCComponent getBottomComponent()
	{
		return null;
	}


	/**
	* Returns true if the child comopnents are continuously redisplayed and layed
	* outduring user intervention.
	*
	* @return		true if the components are continuously redrawn as the divider changes position
	**/
	 public boolean isContinuousLayout()
	{
		return false;
	}


	/**
	* Returns the resize weight.
	*
	* @return		the resize weight
	**/
	 public double getResizeWeight()
	{
		return 0.0d;
	}


	/**
	* Returns the orientation.
	*
	* @return		an integer giving the orientation
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Returns true, if the split pane provides a quick expand/collapse handle, false
	* otherwise.
	*
	* @return		true, if the split pane provides a quick expand/collapse handle, false otherwise
	* @deprecated		use isOneTouchExpandable instead
	**/
	 public boolean getOneTouchExpandable()
	{
		return false;
	}


	/**
	* Gets the oneTouchExpandable property.
	*
	* @return		true, if the split pane provides a quick expand/collapse handle, false otherwise
	**/
	 public boolean isOneTouchExpandable()
	{
		return false;
	}


	/**
	* Returns the last location the divider was at.
	*
	* @return		int value representing the last divider location
	**/
	 public int getLastDividerLocation()
	{
		return 0;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void updateDividerLocationRelative(double dividerLocation)
	{
	}

	 protected void updateDividerLocation(int dividerLocation)
	{
	}

	 protected void updateLastDividerLocation(int lastDividerLocation)
	{
	}


	/**
	* Sets whether or not the child components are continuously redisplayed and
	* layedout during user intervention.
	*
	* @param continuousLayout 		 a boolean, true if the components are continuously redrawn as the divider changes position
	**/
	 public void setContinuousLayout(boolean continuousLayout)
	{
	}


	/**
	* Specifies how to distribute extra space when the size of the split pane
	* changes. A value of 0, the default, indicates the
right/bottom component gets
	* all the extra space, where as a value of 1 specifies the left/top component
	* gets all the extra space.
	*
	* @param resizeWeight 		 the resize weight
	* @throws		IllegalArgumentException if <code>resizeWeight</code> is < 0 or > 1
	**/
	 public void setResizeWeight(double resizeWeight)
	{
	}


	/**
	* Sets the divider location using an absolute Swing UI-specific value (typically
	* a pixel count),
	*
	* @param dividerLocation 		 - an int specifying a Swing UI-specific value (typically a pixel count)
	**/
	 public void setDividerLocation(int dividerLocation)
	{
	}


	/**
	* Sets the divider location as a percentage of the <code>ULCSplitPane</code>'s
	* size.
	*
	* @param dividerLocation 		 a double value in the range 0.0 (top/left) to 1.0 (bottom/right)
	**/
	 public void setDividerLocation(double dividerLocation)
	{
	}


	/**
	* Sets the size of the divider.
	*
	* @param dividerSize 		 an integer giving the size of the divider in pixels
	**/
	 public void setDividerSize(int dividerSize)
	{
	}


	/**
	* Sets the component to the left of (or above) the divider.
	*
	* @param leftComponent 		 the <code>ULCComponent</code> to display in that position
	**/
	 public void setLeftComponent(com.ulcjava.base.application.ULCComponent leftComponent)
	{
	}


	/**
	* Sets the component above, or to the left of the divider.
	*
	* @param topComponent 		 the <code>ULCComponent</code> to display in that position
	**/
	 public void setTopComponent(com.ulcjava.base.application.ULCComponent topComponent)
	{
	}


	/**
	* Sets the component to the right of (or below) the divider.
	*
	* @param rightComponent 		 the <code>ULCComponent</code> to display in that position
	**/
	 public void setRightComponent(com.ulcjava.base.application.ULCComponent rightComponent)
	{
	}


	/**
	* Sets the component below, or to the right of the divider.
	*
	* @param bottomComponent 		 the <code>ULCComponent</code> to display in that position
	**/
	 public void setBottomComponent(com.ulcjava.base.application.ULCComponent bottomComponent)
	{
	}


	/**
	* Sets the orientation, or how the splitter is divided. The options
	* are:
<ul>
<li>VERTICAL_SPLIT (above/below orientation of
	* components)
<li>HORIZONTAL_SPLIT (left/right orientation of components)
</ul>
	*
	* @param orientation 		 an integer specifying the orientation
	* @throws		IllegalArgumentException if orientation is not one of: HORIZONTAL_SPLIT or VERTICAL_SPLIT.
	**/
	 public void setOrientation(int orientation)
	{
	}


	/**
	* Determines whether the ULCSplitPane provides a handle to quickly
	* expand/collapse the divider.
	*
	* @param oneTouchExpandable 		 true if the split pane provides a quick expand/collapse handle, false otherwise
	**/
	 public void setOneTouchExpandable(boolean oneTouchExpandable)
	{
	}


	/**
	* Lays out the <code>ULCSplitPane</code> according to the preferred size of its
	* children components. As a side effect, the divider
loaction may change.
	*
	**/
	 public void resetToPreferredSizes()
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSplitPaneDispatcher extends ULCContainerDispatcher
{

	 public  final void updateDividerLocationRelative(double dividerLocation)
	{
	}

	 public  final void updateDividerLocation(int absoluteDividerLocation)
	{
	}

	 public  final void updateLastDividerLocation(int lastDividerLocation)
	{
	}


}
}