package com.ulcjava.base.application;


	/**
	* <code>ULCTabbedPane</code> is very similar to <code>ULCCardPane</code> but
	* addsa small tab with a title on every component. The tab
allows to
	* interactively switch the displayed
	* content.
<p>
<p>
<b>Features</b>
<ul>
<li>The <code>ULCTabbedPane</code>
	* component is used to pile (or layer) ULC components on top of each other.
	* Tabsare displayed on
each layer to let the user select one of the layers. The
	* tab placement on a layer is configurable. Tabs can be added, inserted,
	* and
removed.</li>
<li>A tab is identified by its position
	* (index).</li>
<li>All tabs are preloaded in a tabbed pane by default. If you
	* want to lazy load a tab, call
<code>ULCTabbedPane.setPreloadAt(index,
	* false)</code> with the index of the tab. It is important that this method is
	* called AFTER the
tab is added to the tabbed pane and BEFORE the tab has been
	* uploaded. <b>Note: </b> The size of the <code>ULCTabbedPane</code>
	* is
determined by the maximum size of all preloaded tabs. If you lazy load
	* sometabs, you have to take care of the size of
<code>ULCTabbedPane</code>
	* yourself.</li>
<li>An application can install an
	* <code>ISelectionChangedListener</code> that is notified when the currently
	* displayed tab is
switched.</li>
<li><code>ULCTabbedPane</code> offers the
	* possibility to enable and disable single tabs.</li>
<li>The layout of tabs
	* canbe specified with the <code>setTabLayoutPolicy</code>
	* method.
</ul>
<p>
<p><b>Examples</b>
<p>
</p>
The following example shows how
	* a tabbed pane (and its tabs) are constructed. The
	* <code>ISelectionChangedListener</code> simply reports
which tab has been
	* selected.

<pre>
fTabbedPane = new
	* ULCTabbedPane(ULCTabbedPane.TOP);
fTabbedPane.addSelectionChangedListener(new
	* ISelectionChangedListener() {
public void
	* selectionChanged(SelectionChangedEvent event) {
System.out.println(&quot;tab
	* &quot;
+ fTabbedPane.getTitleAt(fTabbedPane.getSelectedIndex())
+ &quot; has
	* been selected!&quot;);
}
});
fTabbedPane.addTab(&quot;Address&quot;,
	* createAddressForm());
fTabbedPane.addTab(&quot;Orders&quot;,
	* createOrdersForm());
</pre>

<p>
</p>
<b>Note:</b> All methods providing an
	* <code>alignment</code> parameter have been deprecated. Use the corresponding
	* methods without the
<code>alignment</code> parameter. To specify the
	* alignment, use
	* <code>BorderedComponentUtilities.createBorderedComponent</code>.
E.g.,
	* insteadof using <code>addTab(String align, String title, ULCComponent
	* component)</code> you should use
<code>addTab(String title, ULCComponent
	* component)</code>:
<p>
</p>

<pre>
ULCComponent component =
	* BorderedComponentUtilities
.createBorderedComponent(new
	* ULCButton(&quot;Buttonin center&quot;),
ULCBoxPane.BOX_CENTER_CENTER,
	* BorderFactory
.createEmptyBorder(5, 5, 5,
	* 5));
tabbedPane.addTab(&quot;tab-title&quot;, component);
</pre>
	*
	* @ulc.application		
	* @see		ULCLazyLoadingContainer
	* @see		ULCCardPane
	**/
 public class ULCTabbedPane extends com.ulcjava.base.application.ULCLazyLoadingContainer implements com.ulcjava.base.shared.IDefaults
{

	/**
	* Wrap tabs in multiple runs when all tabs will not fit within a single run.
	*
	**/
	 public  final  static int WRAP_TAB_LAYOUT = 0;

	/**
	* Show a subset of available tabs and provide means of navigation to hidden tabs
	* when all the tabs will not fit within a single run.
	*
	**/
	 public  final  static int SCROLL_TAB_LAYOUT = 0;


	/**
	* Creates an empty <code>ULCTabbedPane</code>. The default tab placement is TOP.
	*
	* @see		#addTab
	**/
	 public ULCTabbedPane()
	{
	}


	/**
	* Creates an empty <code>ULCTabbedPane</code> with the specified tab placement.
	* Valid tab placements are: TOP, BOTTOM, LEFT, or
RIGHT.
	*
	* @param tabPlacement 		 the placement for the tabs relative to the content
	* @see		#addTab
	**/
	 public ULCTabbedPane(int tabPlacement)
	{
	}


	/**
	* Creates an empty <code>ULCTabbedPane</code> with the specified tab placement
	* and tab layout policy. Valid tab placements are: TOP,
BOTTOM, LEFT, or RIGHT.
	* Valid tab layout policies are: WRAP_TAB_LAYOUT and SCROLL_TAB_LAYOUT.
	*
	* @param tabPlacement 		 the placement for the tabs relative to the content
	* @param tabLayoutPolicy 		 the policy for laying out tabs
	* @see		#addTab
	**/
	 public ULCTabbedPane(int tabPlacement, int tabLayoutPolicy)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected void updateSelectedIndex(int selectedIndex)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> to this
	* tabbed pane.
	*
	* @param title 		 the title to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @see		#insertTab
	* @see		#removeTabAt
	**/
	 public void addTab(java.lang.String title, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a <code>component</code> at the last position of this tabbed pane.
	*
	* @param component 		 the component to be displayed when the tab is selected.
	* @return		the component parameter
	* @see		#insertTab
	* @see		#removeTabAt
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> and an
	* <code>icon</code> to this tabbed pane. Either
<code>title</code> or
	* <code>icon</code> may be <code>null</code>.
	*
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @see		#insertTab
	* @see		#removeTabAt
	**/
	 public void addTab(java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> and an
	* <code>icon</code>, as well as a <code>tip</code> to
this tabbed pane. Either
	* <code>title</code> or <code>icon</code> may be <code>null</code>.
	*
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @param tip 		 the tooltip to be displayed for the tab
	* @see		#insertTab
	* @see		#removeTabAt
	**/
	 public void addTab(java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component, java.lang.String tip)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> to this
	* tabbed pane.
<p>
</p>
The alignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param align 		 the alignment string
	* @param title 		 the title to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @see		#insertTab
	* @see		#removeTabAt
	* @deprecated		Use <code>addTab(String title, ULCComponent component)</code> instead. To specify the alignment, use
<code>BorderedComponentUtilities.createBorderedComponent</code>. See the corresponding note in the
<code>ULCTabbedPane</code> general class API doc.
	**/
	 public void addTab(java.lang.String align, java.lang.String title, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> and an
	* <code>icon</code> to this tabbed pane. Either
<code>title</code> or
	* <code>icon</code> may be <code>null</code>.
<p>
</p>
The alignment can be one
	* of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param align 		 the alignment string
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in this tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @see		#insertTab
	* @see		#removeTabAt
	* @deprecated		Use <code>addTab(String title, ULCIcon icon, ULCComponent component)</code> instead. To specify the alignment, use
<code>BorderedComponentUtilities.createBorderedComponent</code>. See the corresponding note in the
<code>ULCTabbedPane</code> general class API doc.
	**/
	 public void addTab(java.lang.String align, java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Adds a <code>component</code> represented by a <code>title</code> and an
	* <code>icon</code>, as well as a <code>tip</code> to
this tabbed pane. Either
	* <code>title</code> or <code>icon</code> may be
	* <code>null</code>.
<p>
</p>
Thealignment can be one of the following
	* values:
<ul>
<li><code>BOX_EXPAND_EXPAND</code>
<li><code>BOX_EXPAND_TOP</code>
	* <li><code>BOX_EXPAND_CENTER</code>
<li><code>BOX_EXPAND_BOTTOM</code>
<li><code
	* >BOX_LEFT_EXPAND</code>
<li><code>BOX_LEFT_TOP</code>
<li><code>BOX_LEFT_CENTER<
	* /code>
<li><code>BOX_LEFT_BOTTOM</code>
<li><code>BOX_CENTER_EXPAND</code>
<li><
	* code>BOX_CENTER_TOP</code>
<li><code>BOX_CENTER_CENTER</code>
<li><code>BOX_CENT
	* ER_BOTTOM</code>
<li><code>BOX_RIGHT_EXPAND</code>
<li><code>BOX_RIGHT_TOP</code
	* >
<li><code>BOX_RIGHT_CENTER</code>
<li><code>BOX_RIGHT_BOTTOM</code>
</ul>
	*
	* @param align 		 the alignment string
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @param tip 		 the tooltip to be displayed for the tab
	* @see		#insertTab
	* @see		#removeTabAt
	* @deprecated		Use <code>addTab(String title, ULCIcon icon, ULCComponent component, String tip)</code> instead. To specify the
alignment, use <code>BorderedComponentUtilities.createBorderedComponent</code>. See the corresponding note in the
<code>ULCTabbedPane</code> general class API doc.
	**/
	 public void addTab(java.lang.String align, java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component, java.lang.String tip)
	{
	}


	/**
	* Adds an <code>ISelectionChangedListener</code> to this tabbed pane.
	*
	* @param listener 		 the <code>ISelectionChangedListener</code> to add
	* @see		#removeSelectionChangedListener
	**/
	 public void addSelectionChangedListener(com.ulcjava.base.application.event.ISelectionChangedListener listener)
	{
	}


	/**
	* Returns the currently selected component for this tabbed pane or
	* <code>null</code> if no tab is selected.
	*
	* @return		the component corresponding to the selected tab or <code>null</code> if no tab is selected
	* @see		#setSelectedComponent
	**/
	 public com.ulcjava.base.application.ULCComponent getSelectedComponent()
	{
		return null;
	}


	/**
	* Returns the currently selected index for this tabbed pane or -1 if no tab is
	* selected.
	*
	* @return		the index of the selected tab or -1 if no tab is selected
	* @see		#setSelectedIndex
	**/
	 public int getSelectedIndex()
	{
		return 0;
	}


	/**
	* Returns an array of all the <code>ISelectionChangedListener</code>s added to
	* this <code>ULCTabbedPane</code>
	* with
<code>addSelectionChangedListener()</code>.
	*
	* @return		all <code>ISelectionChangedListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ISelectionChangedListener[] getSelectionChangedListeners()
	{
		return null;
	}


	/**
	* Returns the tab placement for this tabbed pane.
	*
	* @return		the tab placement for this tabbed pane
	* @see		#setTabPlacement
	**/
	 public int getTabPlacement()
	{
		return 0;
	}


	/**
	* Sets the tab placement for this tabbed pane. Possible values
	* are:
<ul>
<li>TOP
<li>BOTTOM
<li>LEFT
<li>RIGHT
</ul>
The default value is
	* <code>TOP</code>.
	*
	* @param tabPlacement 		 the placement for the tabs relative to the content
	**/
	 public void setTabPlacement(int tabPlacement)
	{
	}


	/**
	* Sets the <code>tabPlacement</code> property on the server side and
	* synchronizesa changed property value to the client side. Use
this method from
	* constructors in subclasses in order to set the property value without side
	* effects (as {@link #setTabPlacement(int)}
might be overridden in
	* subclasses).
<p>
</p>
{@link #setTabPlacement(int)} delegates to this method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetTabPlacement(int tabPlacement)
	{
	}


	/**
	* Inserts a <code>component</code> at <code>index</code>. The
	* <code>component</code> is represented by a <code>title</code>
and/or an
	* <code>icon</code>. Either <code>title</code> or <code>icon</code> may be
	* <code>null</code>.
	*
	* @param alignment 		 the alignment string
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @param tip 		 the tooltip to be displayed for the tab
	* @param index 		 the position at which the new tab should be inserted
	* @see		#addTab
	* @see		#removeTabAt
	* @deprecated		Use <code>insertTab(String title, ULCIcon icon, ULCComponent component, String tip, int index)</code> instead. To
specify the alignment, use <code>BorderedComponentUtilities.createBorderedComponent</code>. See the corresponding note
in the <code>ULCTabbedPane</code> general class API doc.
	**/
	 public void insertTab(java.lang.String alignment, java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component, java.lang.String tip, int index)
	{
	}


	/**
	* Inserts a <code>component</code> at <code>index</code>. The
	* <code>component</code> is represented by a <code>title</code>
and/or an
	* <code>icon</code>. Either <code>title</code> or <code>icon</code> may be
	* <code>null</code>.
	*
	* @param title 		 the title to be displayed in the tab
	* @param icon 		 the icon to be displayed in the tab
	* @param component 		 the component to be displayed when the tab is selected.
	* @param tip 		 the tooltip to be displayed for the tab
	* @param index 		 the position at which the new tab should be inserted
	* @see		#addTab
	* @see		#removeTabAt
	**/
	 public void insertTab(java.lang.String title, com.ulcjava.base.application.util.ULCIcon icon, com.ulcjava.base.application.ULCComponent component, java.lang.String tip, int index)
	{
	}


	/**
	* Removes the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab to be removed
	* @see		#addTab
	* @see		#insertTab
	**/
	 public void removeTabAt(int index)
	{
	}

	 public void removeAll()
	{
	}

	 public void remove(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Removes an <code>ISelectionChangedListener</code> from this tabbed pane.
	*
	* @param listener 		 the ISelectionChangedListener to remove
	* @see		#addSelectionChangedListener
	**/
	 public void removeSelectionChangedListener(com.ulcjava.base.application.event.ISelectionChangedListener listener)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Returns the number of tabs in this tabbed pane.
	*
	* @return		the number of tabs in this tabbed pane
	**/
	 public int getTabCount()
	{
		return 0;
	}


	/**
	* Returns true if the tab at <code>index</code> is set to be uploaded upon
	* uploadof the tabbed pane, false otherwise.
	*
	* @param index 		 the index of the tab for which the preload attribute is queried
	* @return		true if the tab at <code>index</code> is set to be uploaded upon upload of the tabbed pane, false otherwise
	* @see		#setPreloadAt
	**/
	 public boolean isPreloadAt(int index)
	{
		return false;
	}


	/**
	* Sets if the contents of the tab at <code>index</code> is to be uploaded or not
	* when the tabbed pane is uploaded. By default all
tabs are preloaded, i.e.,
	* they are uploaded when the tabbed pane is uploaded.
<p>
</p>
<b>Note:</b>
	* Setting this value after the widget (the tab at the given index) has been
	* uploaded has no effect.
	*
	* @param index 		 the tab index for which the preload attribute should be set
	* @param preload 		 true if the tab at <code>index</code> should be uploaded upon upload of the tabbed pane, false otherwise
	* @see		#isPreloadAt
	**/
	 public void setPreloadAt(int index, boolean preload)
	{
	}


	/**
	* Returns the title of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the title of the tab at <code>index</code>
	* @see		#setTitleAt
	**/
	 public java.lang.String getTitleAt(int index)
	{
		return null;
	}


	/**
	* Sets the title of the tab at <code>index</code> to <code>title</code>.
	* <code>title</code> can be <code>null</code>.
	*
	* @param index 		 the tab index where the title should be set
	* @param title 		 the title to be displayed in the tab
	* @see		#getTitleAt
	**/
	 public void setTitleAt(int index, java.lang.String title)
	{
	}


	/**
	* Returns the tooltip text of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		a string containing the tooltip text of the tab at <code>index</code>
	* @see		#setToolTipTextAt
	**/
	 public java.lang.String getToolTipTextAt(int index)
	{
		return null;
	}


	/**
	* Sets the tooltip text of the tab at <code>index</code> to
	* <code>toolTipText</code>. <code>toolTipText</code> can be
<code>null</code>.
	*
	* @param index 		 the tab index where the tooltip text should be set
	* @param toolTipText 		 the tooltip text to be displayed for the tab
	* @see		#getToolTipTextAt
	**/
	 public void setToolTipTextAt(int index, java.lang.String toolTipText)
	{
	}


	/**
	* Returns the icon of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the icon of the tab at <code>index</code>
	* @see		#setIconAt
	**/
	 public com.ulcjava.base.application.util.ULCIcon getIconAt(int index)
	{
		return null;
	}


	/**
	* Sets the icon of the tab at <code>index</code> to <code>icon</code>.
	* <code>icon</code> can be <code>null</code>.
	*
	* @param index 		 the tab index where the icon should be set
	* @param icon 		 the icon to be displayed in the tab
	* @see		#getIconAt
	**/
	 public void setIconAt(int index, com.ulcjava.base.application.util.ULCIcon icon)
	{
	}


	/**
	* Returns the disabled icon of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the disabled icon of the tab at <code>index</code>
	* @see		#setDisabledIconAt
	**/
	 public com.ulcjava.base.application.util.ULCIcon getDisabledIconAt(int index)
	{
		return null;
	}


	/**
	* Sets the disabled icon of the tab at <code>index</code> to <code>icon</code>.
	* <code>icon</code> can be <code>null</code>.
	*
	* @param index 		 the tab index where the icon should be set
	* @param icon 		 the disabled icon to be displayed in the tab
	* @see		#getDisabledIconAt
	**/
	 public void setDisabledIconAt(int index, com.ulcjava.base.application.util.ULCIcon icon)
	{
	}


	/**
	* Returns the alignment of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the alignment of the tab at <code>index</code>
	* @see		#setAlignmentAt
	* @deprecated		See the corresponding note in the <code>ULCTabbedPane</code> general class API doc.
	**/
	 public java.lang.String getAlignmentAt(int index)
	{
		return null;
	}


	/**
	* Sets the alignment of the tab at <code>index</code> to <code>alignment</code>.
	*
	* @param index 		 the index of the tab where the alignment should be set
	* @param alignment 		 the alignment of the tab content
	* @see		#getAlignmentAt
	* @deprecated		Use <code>BorderedComponentUtilities.createBordereComponent<code> instead.
See the corresponding note in the <code>ULCTabbedPane</code> general class API doc.
	**/
	 public void setAlignmentAt(int index, java.lang.String alignment)
	{
	}


	/**
	* Returns the enabler of the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the <code>IEnabler</code> of the tab at <code>index</code>
	* @see		#setEnablerAt
	**/
	 public com.ulcjava.base.application.enabler.IEnabler getEnablerAt(int index)
	{
		return null;
	}


	/**
	* Sets the enabler at <code>index</code> to <code>enabler</code>.
	*
	* @param index 		 the tab index where this component is set
	* @param enabler 		 the enabler for the tab
	* @see		#getEnablerAt
	**/
	 public void setEnablerAt(int index, com.ulcjava.base.application.enabler.IEnabler enabler)
	{
	}


	/**
	* Returns the tab background color for the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the <code>Color</code> of the tab background at <code>index</code>
	* @see		#setBackgroundAt
	**/
	 public com.ulcjava.base.application.util.Color getBackgroundAt(int index)
	{
		return null;
	}


	/**
	* Sets the background color for the tab at <code>index</code> to
	* <code>background</code>. If <code>background</code> is
<code>null</code>, the
	* tab's background color will default to the background color of the
	* <code>tabbed pane</code>.
	*
	* @param index 		 the index of the tab where the background should be set
	* @param background 		 the color to be displayed as the tab's background
	* @see		#getBackgroundAt
	**/
	 public void setBackgroundAt(int index, com.ulcjava.base.application.util.Color background)
	{
	}


	/**
	* Returns the tab foreground color for the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the <code>Color</code> of the tab foreground at <code>index</code>
	* @see		#setForegroundAt
	**/
	 public com.ulcjava.base.application.util.Color getForegroundAt(int index)
	{
		return null;
	}


	/**
	* Sets the foreground color at <code>index</code> to <code>foreground</code>
	* which can be If <code>foreground</code> is
<code>null</code>, the tab's
	* foreground color will default to the foreground color of this <code>tabbed
	* pane</code>.
	*
	* @param index 		 the index of the tab where the foreground should be set
	* @param foreground 		 the color to be displayed as the tab's foreground
	* @see		#getForegroundAt
	**/
	 public void setForegroundAt(int index, com.ulcjava.base.application.util.Color foreground)
	{
	}


	/**
	* Returns whether or not the tab at <code>index</code> is currently
	* enabled.
<p>
</p>
<b>Note:</b> if enablers have been specified for the target
	* tab the return value will not be accurate.
	*
	* @param index 		 the index of the tab being queried
	* @return		true if the tab at <code>index</code> is enabled; false otherwise
	* @see		#setEnabledAt
	**/
	 public boolean isEnabledAt(int index)
	{
		return false;
	}


	/**
	* Sets whether or not the tab at <code>index</code> is enabled.
	*
	* @param index 		 the tab index which should be enabled/disabled
	* @param enabled 		 whether or not the tab should be enabled
	* @see		#isEnabledAt
	**/
	 public void setEnabledAt(int index, boolean enabled)
	{
	}


	/**
	* Returns the component at <code>index</code>.
	*
	* @param index 		 the index of the tab being queried
	* @return		the <code>ULCComponent</code> at <code>index</code>
	* @see		#setComponentAt
	**/
	 public com.ulcjava.base.application.ULCComponent getComponentAt(int index)
	{
		return null;
	}


	/**
	* Sets the component at <code>index</code> to <code>component</code>.
	*
	* @param index 		 the tab index where this component is set
	* @param component 		 the component for the tab
	* @see		#getComponentAt
	**/
	 public void setComponentAt(int index, com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Sets the selected index for this tabbed pane.
	*
	* @param selectedIndex 		 the index to be selected
	* @see		#getSelectedIndex
	**/
	 public void setSelectedIndex(int selectedIndex)
	{
	}


	/**
	* Sets the selected component for this tabbed pane. The selected index will
	* automatically be set to the index corresponding to the
specified component.
	*
	* @param component 		 the component to be selected
	* @see		#getSelectedComponent
	**/
	 public void setSelectedComponent(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns the policy used for laying out tabs when all of them will not fit
	* within a single run.
	*
	* @return		int constant for the policy
	* @see		#setTabLayoutPolicy
	* @see		#WRAP_TAB_LAYOUT
	* @see		#SCROLL_TAB_LAYOUT
	**/
	 public int getTabLayoutPolicy()
	{
		return 0;
	}


	/**
	* Sets the tabbedpane's policy for laying out tabs when they will not fit within
	* a single run. Possible values
	* are:
<ul>
<li><code>ULCTabbedPane.WRAP_TAB_LAYOUT</code>
<li><code>ULCTabbedPan
	* e.SCROLL_TAB_LAYOUT</code>
</ul>
<p>
This property's behavior is dependent on
	* the look and feel.
	*
	* @param tabLayoutPolicy 		 the policy used to layout the tabs
	* @exception		IllegalArgumentException if layoutPolicy value isn't one of the above valid values
	* @see		#getTabLayoutPolicy
	**/
	 public void setTabLayoutPolicy(int tabLayoutPolicy)
	{
	}


	/**
	* Sets the <code>tabLayoutPolicy</code> property on the server side and
	* synchronizes a changed property value to the client side. Use
this method
	* fromconstructors in subclasses in order to set the property value without
	* sideeffects (as
{@link #setTabLayoutPolicy(int)} might be overridden in
	* subclasses).
<p>
</p>
{@link #setTabLayoutPolicy(int)} delegates to this
	* method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetTabLayoutPolicy(int tabLayoutPolicy)
	{
	}


	/**
	* Returns the keyboard menmonic for the tab at <code>index</code>.
	*
	* @param index 		 the index of the tab whose mnemonic should be returned
	* @return		int the keycode for the mnemonic or -1 if mnemonic is not specified
	* @see		#setMnemonicAt
	**/
	 public int getMnemonicAt(int index)
	{
		return 0;
	}


	/**
	* Sets the keyboard menmonic for the tab at <code>index</code>.
	*
	* @param index 		 the tab index where the mnemonic should be set
	* @param mnemonic 		 the title to be displayed in the tab
	* @see		#getMnemonicAt
	**/
	 public void setMnemonicAt(int index, int mnemonic)
	{
	}


	/**
	* Returns index of the character that should be decorated by look and feel as a
	* mnemonic.
	*
	* @param tabIndex 		 the index of the tab whose displayed mnemonic index should be returned
	* @return		index corresponding to the mnemonic character
	* @see		#setDisplayedMnemonicIndexAt
	**/
	 public int getDisplayedMnemonicIndexAt(int tabIndex)
	{
		return 0;
	}


	/**
	* Sets the index of the character from the title text that should be decorated
	* bylook and feel as the mnemonic. This property is look
and feel dependent.
	* Usethis method when the default character should not be underlined. A value
	* of-1 indicates one of the
following:
<ul>
<li> there is no mnemonic
<li> the
	* mnemonic character is not part of title text
<li> do not display the
	* mnemonic.</ul>
	*
	* @param tabIndex 		 the index of the tab whose displayed mnemonic index is to be set
	* @param mnemonicIndex 		 index of the char in title text that should be underlined
	* @exception		IllegalArgumentException when <code>index</code> is out of bounds of the title text
	* @see		#getDisplayedMnemonicIndexAt
	**/
	 public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex)
	{
	}


	/**
	* Returns the first tab index that has the specified title. -1 is returned if no
	* tab has this title.
	*
	* @param tabTitle 		 the title to be searched
	* @return		the first tab index that has the specified title, or -1 if no tab has this title
	**/
	 public int indexOfTab(java.lang.String tabTitle)
	{
		return 0;
	}


	/**
	* Returns the first tab index that has the specified icon. -1 is returned if no
	* tab has this icon.
	*
	* @param tabIcon 		 the icon to be searched
	* @return		the first tab index that has the specified icon, or -1 if no tab has this icon
	**/
	 public int indexOfTab(com.ulcjava.base.application.util.ULCIcon tabIcon)
	{
		return 0;
	}


	/**
	* Returns the first tab index that has the specified component. -1 is returned
	* ifno tab has this component.
	*
	* @param tabComponent 		 the component to be searched
	* @return		the first tab index that has the specified component, or -1 if no tab has this component
	**/
	 public int indexOfComponent(com.ulcjava.base.application.ULCComponent tabComponent)
	{
		return 0;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
<p/>
<b>Note:</b> this implementation is still based on the deprecated constraints conversion mechanism for backward
compatibility. In order to install the new {@link com.ulcjava.base.shared.IStreamCoder}-based conversion mechanism
in a subclass of this container, overwrite this method and therein, invoke {@link #defaultInternalConvertFromConstraints(Object)}.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.shared.internal.Anything internalConvertFromConstraints(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTabbedPaneDispatcher extends ULCLazyLoadingContainerDispatcher
{

	 public  final void updateSelectedIndex(int selectedIndex)
	{
	}


}
}