package com.ulcjava.base.application;


	/**
	* A <code>ULCTextArea</code> allows the editing of multiple lines of
	* text.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCTextArea</code>
	* componentinherits all features from <code>ULCTextComponent</code>.
<li>The
	* developer can configure whether lines should be wrapped, and whether line
	* wrapping should be word-wise or character-wise.
<li><code>ULCTextArea</code>
	* allows insertion of text at a given position and replacement of text between
	* astart and end position.
</ul>
<b>Examples</b>
<p>
To create a multi-line
	* textfield, we pass the number of columns and rows to the constructor and
	* configure the line wrapping properties
according to our
	* needs.

<pre>
ULCTextArea textArea = new ULCTextArea(&quot;First line\n&quot;
	* + &quot;Second line&quot;, 10, // rows
3); //
	* columns
textArea.setLineWrap(true);
textArea.setWrapStyleWord(true);
</pre>
	*
	* @ulc.application		
	* @see		ULCTextComponent
	* @see		ULCComponent
	**/
 public class ULCTextArea extends com.ulcjava.base.application.ULCTextComponent
{

	/**
	* Default tab size
	*
	**/
	 public  static int DEFAULT_TAB_SIZE = 0;


	/**
	* Constructs a new text area with initial text set to null and rows/columns set
	* to 0.
	*
	**/
	 public ULCTextArea()
	{
		 super();
	}


	/**
	* Constructs a new text area with the specified text displayed. The number of
	* rows/columns is set to 0.
	*
	* @param text 		 the text to be displayed, or null
	**/
	 public ULCTextArea(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs a new empty text area with the specified number of rows and
	* columns.The initial text is null.
	*
	* @param rows 		 the number of rows >= 0
	* @param columns 		 the number of columns >= 0
	* @throws		IllegalArgumentException if the rows or columns arguments are < 0.
	**/
	 public ULCTextArea(int rows, int columns)
	{
		 super();
	}


	/**
	* Constructs a new text area with the specified text and number of rows and
	* columns.
	*
	* @param text 		 the text to be displayed, or null
	* @param rows 		 the number of rows >= 0
	* @param columns 		 the number of columns >= 0
	* @throws		IllegalArgumentException if the rows or columns arguments are < 0.
	**/
	 public ULCTextArea(java.lang.String text, int rows, int columns)
	{
		 super();
	}


	/**
	* Appends the specified string to the end of this text area. If the text is null
	* or the string is null or empty this method has no
effect.
	*
	* @param str 		 the string to be appended
	**/
	 public void append(java.lang.String str)
	{
	}


	/**
	* Returns the wrapping style used if this text area is wrapping lines. True
	* meansthat lines will be wrapped at word boundaries (e.g.
whitespace),
	* otherwise the text area wraps at character boundaries.
	*
	* @return		true for word wrapping, false for character wrapping
	* @see		#setWrapStyleWord
	**/
	 public boolean getWrapStyleWord()
	{
		return false;
	}


	/**
	* Returns the line-wrapping policy of this text area. True means lines will be
	* wrapped if they do not fit into the length of the text
area, otherwise no
	* wrapping is performed.
	*
	* @return		true for wrapping, false for no wrapping
	* @see		#setLineWrap
	**/
	 public boolean getLineWrap()
	{
		return false;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the line-wrapping policy of this text area. True means lines will be
	* wrapped if they do not fit into the length of the text
area, otherwise no
	* wrapping is performed.
	*
	* @param lineWrap 		 true for wrapping, false for no wrapping
	* @see		#getLineWrap
	**/
	 public void setLineWrap(boolean lineWrap)
	{
	}


	/**
	* Sets the wrapping style used if this text area is wrapping lines. True means
	* that lines will be wrapped at word boundaries (e.g.
whitespace), otherwise
	* thetext area wraps at character boundaries.
	*
	* @param wrapStyleWord 		 true for word wrapping, false for character wrapping
	* @see		#getWrapStyleWord
	**/
	 public void setWrapStyleWord(boolean wrapStyleWord)
	{
	}


	/**
	* Returns the number of columns.
	*
	* @return		the number of columns
	**/
	 public int getColumns()
	{
		return 0;
	}


	/**
	* Sets the number of columns.
	*
	* @param columns 		 the number of columns
	**/
	 public void setColumns(int columns)
	{
	}


	/**
	* Returns the number of rows.
	*
	* @return		the number of rows
	**/
	 public int getRows()
	{
		return 0;
	}


	/**
	* Sets the number of rows.
	*
	* @param rows 		 the number of rows
	**/
	 public void setRows(int rows)
	{
	}


	/**
	* Sets the number of characters in tab.
	*
	* @param tabSize 		 number of characters in tab
	* @see		#getTabSize
	**/
	 public void setTabSize(int tabSize)
	{
	}


	/**
	* Returns the tab size. Since the <code>Document</code> is not available default
	* is set to 8.
	*
	* @return		the number of characters in tab
	**/
	 public int getTabSize()
	{
		return 0;
	}


	/**
	* Inserts the specified text at the specified position.
	*
	* @param text 		 the text to insert
	* @param position 		 the position at which to insert
	* @exception		IllegalArgumentException if position is invalid
	* @see		ULCTextComponent#setText
	* @see		#replaceRange
	**/
	 public void insert(java.lang.String text, int position)
	{
	}


	/**
	* Replaces text from the specified start to end position with the given text. If
	* the given string is null or empty, the string in the
specified range is
	* deleted.
	*
	* @param text 		 the replacement text
	* @param startPosition 		 the start position
	* @param endPosition 		 the end position
	* @exception		IllegalArgumentException if the start-end range is invalid w.r.t. current text
	* @see		#insert
	**/
	 public void replaceRange(java.lang.String text, int startPosition, int endPosition)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTextAreaDispatcher extends ULCTextComponentDispatcher
{


}
}