package com.ulcjava.base.application;


	/**
	* The <code>ULCToggleButton</code> class is the base class for toggle buttons,
	* i.e., radio buttons and check boxes. It comprises the
functionality that is
	* common to these types of buttons.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCToggleButton</code> component inherits all features from
	* <code>ULCAbstractButton</code>.
<li>The application can read and set the
	* selection state of the <code>ULCToggleButtons</code>.
<li>An application can
	* register an <code>IValueChangedListener</code> to be notified about state
	* changes of the toggle button.
</ul>
<b>Examples</b>
<p>
</p>
To set the
	* selection state of a
	* <code>ULCToggleButton</code>:

<pre>
toggleButton.setSelected(true);
</pre>

Th
	* e following example installs an
	* <code>IValueChangedListener</code>.

<pre>
toggleButton.addValueChangedListener
	* (new IValueChangedListener() {
public void valueChanged(ValueChangedEvent
	* event) {
ULCToggleButton button =
	* (ULCToggleButton)event.getSource();
System.out.println(button.isSelected());
}
	* });
</pre>
	*
	* @ulc.application		
	* @see		ULCAbstractButton
	* @see		ULCComponent
	**/
 public class ULCToggleButton extends com.ulcjava.base.application.ULCAbstractButton
{


	/**
	* Creates an unselected toggle button which has no text or image.
	*
	**/
	 public ULCToggleButton()
	{
		 super();
	}


	/**
	* Creates an unselected toggle button with the specified icon but no text.
	*
	* @param icon 		 the image to be displayed on this button
	**/
	 public ULCToggleButton(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a toggle button with the specified image and selection state, but no
	* text.
	*
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, it is initially unselected
	**/
	 public ULCToggleButton(com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected toggle button with the specified text.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	**/
	 public ULCToggleButton(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a toggle button with the specified text and selection state.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCToggleButton(java.lang.String text, boolean selected)
	{
		 super();
	}


	/**
	* Creates an unselected toggle button with the specified text and image.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param icon 		 the image that the button should display
	**/
	 public ULCToggleButton(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a toggle button with the specified text, icon, and selection state.
	*
	* @param text 		 the string to be displayed on this button. May be <code>null</code>.
	* @param icon 		 the image to be displayed on this button
	* @param selected 		 if true, the button is initially selected; otherwise, the button is initially unselected
	**/
	 public ULCToggleButton(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Create a toggle button with the properties defined in the action object. The
	* action is registered as action listener with the toggle
button.
	*
	* @param action 		 the action containing the toggle button properties
	**/
	 public ULCToggleButton(com.ulcjava.base.application.IAction action)
	{
		 super();
	}


	/**
	* Returns the group this button belongs to. Normally used with radio buttons,
	* which are mutually exclusive within their group.
	*
	* @return		a <code>ULCButtonGroup</code> this button belongs to
	**/
	 public com.ulcjava.base.application.ULCButtonGroup getGroup()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Specifies the group this button belongs to -- needed for radio buttons, which
	* are mutually exclusive within their group.
	*
	* @param group 		 the <code>ULCButtonGroup</code> this button belongs to
	**/
	 public void setGroup(com.ulcjava.base.application.ULCButtonGroup group)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCToggleButtonDispatcher extends ULCAbstractButtonDispatcher
{


}
}