package com.ulcjava.base.application;


	/**
	* The <code>ULCToggleMenuItem</code> class is the abstract base class for toggle
	* menu items, i.e., radio button menu items and check box
menu items. It
	* comprises the functionality that is common to these types of menu
	* items.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCToggleMenuItem</code>
	* component inherits all features from
	* <code>ULCMenuItem</code>,
<code>ULCAbstractButton</code> and
	* <code>ULCComponent</code>.
<li>An application can read and set the selection
	* state of the <code>ULCToggleMenuItems</code>.
<li>An application can register
	* an <code>IValueChangedListener</code> to be notified about state changes of
	* the toggle button.
</ul>
<b>Examples</b>
<p>
</p>
To set the selection state
	* of a
	* <code>ULCToggleMenuItem</code>:

<pre>
toggleMenuItem.setSelected(true);
</pre>
	* The following example installs an
	* <code>IValueChangedListener</code>.

<pre>
toggleMenuItem.addValueChangedListen
	* er(new IValueChangedListener() {
public void valueChanged(ValueChangedEvent
	* event) {
System.out.println(&quot;value changed&quot;);
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCMenuItem
	* @see		ULCAbstractButton
	* @see		ULCComponent
	**/
 public  abstract class ULCToggleMenuItem extends com.ulcjava.base.application.ULCMenuItem
{


	/**
	* Constructs a toggle menu item, initially unselected with no text or image.
	*
	**/
	 public ULCToggleMenuItem()
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, initially unselected with no text and with a
	* given image.
	*
	* @param icon 		 the icon to be displayed
	**/
	 public ULCToggleMenuItem(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, in a given state with no text and with a given
	* image.
	*
	* @param icon 		 the icon to be displayed
	* @param selected 		 if true, the menu item will be selected;
	**/
	 public ULCToggleMenuItem(com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, initially unselected with given text.
	*
	* @param text 		 the label to be shown on this item
	**/
	 public ULCToggleMenuItem(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, in a given state with given text.
	*
	* @param text 		 the label to be shown on this item
	* @param selected 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCToggleMenuItem(java.lang.String text, boolean selected)
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, initially unselected with given text and icon.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 the icon to be displayed
	**/
	 public ULCToggleMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs a toggle menu item, with given text, icon and selection state.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 the icon to be displayed
	* @param selected 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCToggleMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean selected)
	{
		 super();
	}


	/**
	* Registers a <code>ValueChangedListener</code> with this menu item.
	*
	* @param l 		 the <code>ValueChangedListener</code> being registered
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener l)
	{
	}


	/**
	* Returns the group that this menu item belongs to. Normally used with radio
	* buttons menu items, which are mutually exclusive within
their group.
	*
	* @return		a ButtonGroup that this menu item belongs to
	**/
	 public com.ulcjava.base.application.ULCButtonGroup getGroup()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Identifies the group this menu item belongs to -- needed for radio button menu
	* items, which are mutually exclusive within their
group.
	*
	* @param group 		 the ButtonGroup this menu item belongs to
	**/
	 public void setGroup(com.ulcjava.base.application.ULCButtonGroup group)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCToggleMenuItemDispatcher extends ULCMenuItemDispatcher
{


}
}