package com.ulcjava.base.application;


	/**
	* The <code>ULCTree</code> component displays a hierarchy of
	* items.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCTree</code> component
	* inherits all features from <code>ULCComponent</code>.
<li>An
	* <code>ITreeModel</code> provides the hierarchy of items that are displayed in
	* the <code>ULCTree</code>.
<li>The application can register
	* <code>ITreeSelectionListeners</code> that are notified when the selection on
	* the ULCTree changes. In
addition, the application can use methods to retrieve
	* and alter the current selection on the tree. The selection mode can be
	* specified as
one of the following: single, contiguous,
	* discontiguous.
<li>Registration of <code>IActionListeners</code> that get
	* called on action events issued by the tree (i.e., double clicks, return
	* key
types).
<li>To be notified about tree nodes being expanded and collapsed,
	* register <code>ITreeExpansionListeners</code> with an
<code>ULCTree</code>.
	* Moreover, nodes can be expanded and collapsed
	* programmatically.
<li><code>ULCTree</code> also offers the possibility to
	* programmatically ensure that a specific node is visible.
<li>The tree height
	* as well as the row height can be changed.
<li>Tree paths can be converted to
	* rows and vice versa.
<li>Custom renderers and editors can be
	* specified.
<li><code>ULCTree</code> offers the following mechanisms for
	* stopping cell editor on focus lost event:
<ul>
<li>If the property
	* <code>ulcTerminateEditOnFocusLost</code> has been set to
	* <code>Boolean.FALSE</code> using the
	* method
<code>putClientProperty("ulcTerminateEditOnFocusLost",
	* Boolean.FALSE)</code>, the editor is NOT stopped on focus lost.
<li>If the
	* property <code>ulcTerminateEditOnFocusLost</code> is
	* <code>Boolean.TRUE</code>(which it is by default), the editor is
	* stopped
whenever it loses focus.
</ul>
</ul>
<b>Examples</b>
<p>
</p>
The
	* following example shows how to set up an ULCTree. At the end of the example
	* anIActionListener is installed that listens for double
clicks.

<pre>
final
	* ULCTree tree = new
	* ULCTree(treeModel);
tree.getSelectionModel().setSelectionMode(
ULCTreeSelection
	* Model.SINGLE_TREE_SELECTION);
tree.setCellRenderer(new
	* CustumTreeCellRenderer());
tree.addActionListener(new IActionListener()
	* {
public void actionPerformed(ActionEvent event) {
TreePath selection =
	* tree.getSelectionPath();
System.out.println(&quot;action on node: &quot; +
	* selection);
}
});
</pre>

The following example defines a custom tree cell
	* renderer that renders non-leafs in bold and uses cyan as selection
	* color.

<pre>
private class CustomTreeCellRenderer extends ULCLabel
	* implementsITreeCellRenderer {
public IRendererComponent
	* getTreeCellRendererComponent(ULCTree tree,
Object value, boolean selected,
	* boolean expanded,
boolean leaf, boolean hasFocus) {
int fontStyle =
	* tree.getFont().getStyle();
if (!leaf) {
fontStyle = Font.BOLD;
}
setFont(new
	* Font(tree.getFont().getName(), fontStyle, tree
.getFont().getSize()));
Color
	* background = tree.getBackground();
if (selected) {
background =
	* Color.cyan;
}
setBackground(background);
return this;
}
}
</pre>

The
	* following example prints out all expanded nodes of a tree
	* model.

<pre>
private void printOutExpansion(final ULCTree tree,
final
	* FileTreeModel treeModel) {
TreePath rootPath = new
	* TreePath(treeModel.getRoot());
Enumeration enum =
	* tree.getExpandedDescendants(rootPath);
while (enum.hasMoreElements())
	* {
TreePath expansionPath =
	* (TreePath)enum.nextElement();
System.out.println(expansionPath);
}
}
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		com.ulcjava.base.application.tree.ITreeModel
	**/
 public class ULCTree extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.server.dnd.IDnDComponent
{

	 protected void requestRendererComponents(int[][] descriptions)
	{
	}

	 protected void requestEditorComponents(int[][] descriptions)
	{
	}

	 public void setEventDeliveryMode(java.lang.String eventCategory, int mode)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Adds a listener for action events. An action event is generated, when user
	* double-clicks or hits enter key on a tree node.
	*
	* @param listener 		 the action listener to add
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns the action command for this tree.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCTree</code> with <code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Removes a listener for action events.
	*
	* @param listener 		 the action listener to remove
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Sets the action command property for this tree.
	*
	* @param actionCommand 		 the action command for the tree
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Creates a new tree with a sample model.
	*
	**/
	 public ULCTree()
	{
		 super();
	}


	/**
	* Creates a new tree.
	*
	* @param model 		 the model for the tree
	**/
	 public ULCTree(com.ulcjava.base.application.tree.ITreeModel model)
	{
		 super();
	}


	/**
	* Creates a new tree with the specified node as root.
	*
	* @param root 		 the root of the new tree
	**/
	 public ULCTree(com.ulcjava.base.application.tree.ITreeNode root)
	{
		 super();
	}


	/**
	* Creates a new tree with the specified children. The root node is not displayed.
	*
	* @param children 		 the children of the new tree
	**/
	 public ULCTree(java.util.List children)
	{
		 super();
	}


	/**
	* Creates a new tree with the specified children. The root node is not displayed.
	*
	* @param children 		 the children of the new tree
	**/
	 public ULCTree(java.util.Map children)
	{
		 super();
	}


	/**
	* Creates a new tree with the specified children. The root node is not displayed.
	*
	* @param children 		 the children of the new tree
	**/
	 public ULCTree(java.lang.Object[] children)
	{
		 super();
	}


	/**
	* Adds the paths in the specified interval to the selection.
	*
	* @param index0 		 a margin of the interval
	* @param index1 		 the other margin of the interval
	**/
	 public void addSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Adds the specified path to the current selection. If the path isn't viewable,
	* it is made viewable.
	*
	* @param path 		 the path to add
	**/
	 public void addSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Adds each path in the array of paths to the current selection. If any of the
	* paths isn't viewable it is made viewable.
	*
	* @param paths 		 the paths to add
	**/
	 public void addSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Adds the path at the specified row to the current selection.
	*
	* @param row 		 an integer specifying the row of the node to add, where 0 is the first row in the display
	**/
	 public void addSelectionRow(int row)
	{
	}


	/**
	* Adds the paths at each of the specified rows to the current selection.
	*
	* @param rows 		 an array of integers specifying the rows to add, where 0 indicates the first row in the display
	**/
	 public void addSelectionRows(int[] rows)
	{
	}


	/**
	* Adds a listener for tree expansion events.
	*
	* @param listener 		 the tree expansion listener to add
	**/
	 public void addTreeExpansionListener(com.ulcjava.base.application.event.ITreeExpansionListener listener)
	{
	}


	/**
	* Adds a listener for tree selection events.
	*
	* @param listener 		 the tree selection listener to add
	**/
	 public void addTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Clears the selection.
	*
	**/
	 public void clearSelection()
	{
	}


	/**
	* Collapses the specified paths including (if specified) all descendant paths.
	* Invisible descendant paths are collapsed as well.
	*
	* @param paths 		 the paths to collapse
	* @param includingDescendants 		 true if all descendant paths should be collapsed as well, false otherwise
	**/
	 public void collapsePaths(com.ulcjava.base.application.tree.TreePath[] paths, boolean includingDescendants)
	{
	}


	/**
	* Collapses all paths including all descendant paths. Invisible descendant paths
	* are collapsed as well.
	*
	**/
	 public void collapseAll()
	{
	}


	/**
	* Collapse the specified path. If the path isn't viewable it is made viewable.
	*
	* @param path 		 the TreePath to collapse
	**/
	 public void collapsePath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Ensures that the node in the specified row is collapsed.
	*
	* @param row 		 an integer specifying a display row, where 0 is the first row in the display
	**/
	 public void collapseRow(int row)
	{
	}


	/**
	* Expands the specified paths including (if specified) all descendant paths. If
	* the paths are not visible they are made visible.
	*
	* @param paths 		 the paths to expand
	* @param includingDescendants 		 true if all descendant paths should be expanded as well, false otherwise
	**/
	 public void expandPaths(com.ulcjava.base.application.tree.TreePath[] paths, boolean includingDescendants)
	{
	}


	/**
	* Expands all paths including all descendant paths.
	*
	**/
	 public void expandAll()
	{
	}


	/**
	* Expands the specified path. If the path isn't visible it is made visible.
	*
	* @param path 		 the TreePath to expand
	**/
	 public void expandPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Ensures that the node in the specified row is expanded and visible.
	*
	* @param row 		 an integer specifying a display row, where 0 is the first row in the display
	**/
	 public void expandRow(int row)
	{
	}


	/**
	* Returns the current tree cell editor, or null if the tree is not
	* editable.
<p>
</p>
<b>Note:</b> Returns null if no custom editor is installed
	* even if the tree is editable.
	*
	* @return		the current tree cell editor, or null if the tree is not editable or no custom editor is installed
	* @see		#setCellEditor
	**/
	 public com.ulcjava.base.application.tree.ITreeCellEditor getCellEditor()
	{
		return null;
	}


	/**
	* Returns the current tree cell renderer.
<p>
</p>
<b>Note:</b> Returns null if
	* no custom renderer is installed.
	*
	* @return		the current tree cell renderer, or null if no custom renderer is installed
	* @see		#setCellRenderer
	**/
	 public com.ulcjava.base.application.tree.ITreeCellRenderer getCellRenderer()
	{
		return null;
	}


	/**
	* Returns an Enumeration of the descendants of <code>path</code> that are
	* currently expanded. If <code>path</code> is not currently
expanded, this will
	* return null. If you expand/collapse nodes while iterating over the returned
	* Enumeration this may not return all
the expanded paths, or may return paths
	* that are no longer expanded.
	*
	* @param parent 		 the parent
	* @return		the enumeration of expanded descendants
	**/
	 public java.util.Enumeration getExpandedDescendants(com.ulcjava.base.application.tree.TreePath parent)
	{
		return null;
	}


	/**
	* Returns true if interrupting the editing stops editing, false if it cancels
	* editing.
	*
	* @return		true if interrupting the editing stops editing, false if it cancels editing
	* @see		#setInvokesStopCellEditing
	**/
	 public boolean getInvokesStopCellEditing()
	{
		return false;
	}


	/**
	* Returns the last path component of the first selected node.
	*
	* @return		the last path component of the first selected node
	**/
	 public java.lang.Object getLastSelectedPathComponent()
	{
		return null;
	}


	/**
	* Returns the tree model.
	*
	* @return		the tree model
	* @see		#setModel
	**/
	 public com.ulcjava.base.application.tree.ITreeModel getModel()
	{
		return null;
	}


	/**
	* Returns the path for the specified row. If the specified row is not visible,
	* null is returned.
	*
	* @param row 		 the row
	* @return		the path for the specified row
	**/
	 public com.ulcjava.base.application.tree.TreePath getPathForRow(int row)
	{
		return null;
	}


	/**
	* Returns the number of rows currently being displayed.
	*
	* @return		the number of rows currently being displayed
	**/
	 public int getRowCount()
	{
		return 0;
	}


	/**
	* Returns the display row of the specified path. If the specified path is not
	* displayed -1 is returned.
	*
	* @param path 		 the path
	* @return		the display row of the specified path
	**/
	 public int getRowForPath(com.ulcjava.base.application.tree.TreePath path)
	{
		return 0;
	}


	/**
	* Returns the row height.
	*
	* @return		the row height
	* @see		#setRowHeight
	**/
	 public int getRowHeight()
	{
		return 0;
	}


	/**
	* Returns the number of rows that are displayed in the display area.
	*
	* @return		the number of rows displayed
	**/
	 public int getVisibleRowCount()
	{
		return 0;
	}


	/**
	* Returns true if the tree scrolls to show previously hidden children, false
	* otherwise.
	*
	* @return		true if the tree scrolls to show previously hidden children, false otherwise
	* @see		#setScrollsOnExpand
	**/
	 public boolean getScrollsOnExpand()
	{
		return false;
	}


	/**
	* Returns the number of selected pahts.
	*
	* @return		the number of selected pahts
	**/
	 public int getSelectionCount()
	{
		return 0;
	}


	/**
	* Returns the model for selections.
	*
	* @return		the model for selections
	**/
	 public com.ulcjava.base.application.tree.ULCTreeSelectionModel getSelectionModel()
	{
		return null;
	}


	/**
	* Returns the first selected path, or null if nothing is selected.
	*
	* @return		the first selected path, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath getSelectionPath()
	{
		return null;
	}


	/**
	* Returns the selected paths, or null if nothing is selected.
	*
	* @return		the selected paths, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath[] getSelectionPaths()
	{
		return null;
	}


	/**
	* Returns the selected rows, or null if nothing is selected.
	*
	* @return		the selected rows, or null if nothing is selected
	**/
	 public int[] getSelectionRows()
	{
		return null;
	}


	/**
	* Returns true if root handles are shown, false otherwise.
	*
	* @return		true if root handles are shown, false otherwise
	* @see		#setShowsRootHandles
	**/
	 public boolean getShowsRootHandles()
	{
		return false;
	}


	/**
	* Returns true if the specified row is collapsed or invisible, false otherwise.
	*
	* @param row 		 the row to be checked if collapsed
	* @return		true if the specified row is collapsed or invisible, false otherwise
	**/
	 public boolean isCollapsed(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified path is collapsed or invisible, false otherwise.
	*
	* @param path 		 the path to be checked if collapsed
	* @return		true if the specified path is collapsed or invisible, false otherwise
	**/
	 public boolean isCollapsed(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if tree is editable, false otherwise.
	*
	* @return		true if tree is editable, false otherwise
	* @see		#setEditable
	**/
	 public boolean isEditable()
	{
		return false;
	}


	/**
	* Returns true if the specified row is expanded and visible, false otherwise.
	*
	* @param row 		 the row to be checked if expanded
	* @return		true if the specified row is expanded and visible, false otherwise
	**/
	 public boolean isExpanded(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified path is expanded and visible, false otherwise.
	*
	* @param path 		 the path to be checked if expanded
	* @return		true if the specified path is expanded and visible, false otherwise
	**/
	 public boolean isExpanded(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if the specified path is selected, false otherwise.
	*
	* @param path 		 the path to be checked if selected
	* @return		true if the specified path is selected, false otherwise
	**/
	 public boolean isPathSelected(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if the root is visible, false otherwise.
	*
	* @return		true if the root is visible, false otherwise
	**/
	 public boolean isRootVisible()
	{
		return false;
	}


	/**
	* Returns true if row with the specified index is selected, false otherwise.
	*
	* @param index 		 the row index to be checked if row selected
	* @return		true if row with the specified index is selected, false otherwise
	**/
	 public boolean isRowSelected(int index)
	{
		return false;
	}


	/**
	* Returns true if nothing is selected, false otherwise.
	*
	* @return		true if nothing is selected, false otherwise
	**/
	 public boolean isSelectionEmpty()
	{
		return false;
	}


	/**
	* Returns true if the specified path is visible, false otherwise.
	*
	* @param path 		 the path to be check if visible
	* @return		true if the specified path is visible, false otherwise
	**/
	 public boolean isVisible(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Initiates editing at the specified node. The edit-attempt fails if the the
	* treeis not editable
	*
	* @param path 		 the <code>TreePath</code> identifying a node
	**/
	 public void startEditingAtPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Makes the specified path visible.
	*
	* @param path 		 the path to make visible
	**/
	 public void makeVisible(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Removes the paths in the specified interval from the selection.
	*
	* @param index0 		 a margin of the interval
	* @param index1 		 the other margin of the interval
	**/
	 public void removeSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Removes the specified path from the current selection.
	*
	* @param path 		 the path to remove
	**/
	 public void removeSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Removes the specified paths from the current selection.
	*
	* @param paths 		 the paths to remove
	**/
	 public void removeSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Removes row with the specified index from the current selection.
	*
	* @param row 		 the row to remove
	**/
	 public void removeSelectionRow(int row)
	{
	}


	/**
	* Removes the specified rows from the current selection.
	*
	* @param rows 		 the rows to remove
	**/
	 public void removeSelectionRows(int[] rows)
	{
	}


	/**
	* Removes a listener for tree expansion events.
	*
	* @param listener 		 the tree expansion listener to remove
	**/
	 public void removeTreeExpansionListener(com.ulcjava.base.application.event.ITreeExpansionListener listener)
	{
	}


	/**
	* Removes a listener for tree selection events.
	*
	* @param listener 		 the tree selection listener to remove
	**/
	 public void removeTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Scrolls so that the specified path is displayed. If the path isn't viewable it
	* is made viewable.
	*
	* @param path 		 the path to display
	**/
	 public void scrollPathToVisible(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Scrolls so that the specified row is displayed. If the row isn't viewable it
	* ismade viewable.
	*
	* @param row 		 the row to display
	**/
	 public void scrollRowToVisible(int row)
	{
	}


	/**
	* Sets the specified tree cell editor.
<p>
</p>
<b>Note:</b> Setting the editor
	* to null installs the default editor.
	*
	* @param editor 		 the tree cell editor to set
	* @see		#getCellEditor
	**/
	 public void setCellEditor(com.ulcjava.base.application.tree.ITreeCellEditor editor)
	{
	}


	/**
	* Sets the specified tree cell renderer.
<p>
</p>
<b>Note:</b> Setting the
	* renderer to null installs the default renderer.
	*
	* @param renderer 		 the tree cell renderer to set
	* @see		#getCellRenderer
	**/
	 public void setCellRenderer(com.ulcjava.base.application.tree.ITreeCellRenderer renderer)
	{
	}


	/**
	* Determines if the tree is editable or not.
	*
	* @param editable 		 true if the tree should be editable, false otherwise
	* @see		#isEditable
	**/
	 public void setEditable(boolean editable)
	{
	}


	/**
	* Determines if editing is stopped or canceled when interrupting.
	*
	* @param invokesStopCellEditing 		 true if the editing should be stopped, false if it should be canceled.
	* @see		#getInvokesStopCellEditing
	**/
	 public void setInvokesStopCellEditing(boolean invokesStopCellEditing)
	{
	}


	/**
	* Sets the tree model.
	*
	* @param model 		 the tree model to set
	* @see		#getModel
	**/
	 public void setModel(com.ulcjava.base.application.tree.ITreeModel model)
	{
	}


	/**
	* Determines if the root is visible or not.
	*
	* @param rootVisible 		 true if the root should be visible, false otherwise
	* @see		#isRootVisible
	**/
	 public void setRootVisible(boolean rootVisible)
	{
	}


	/**
	* Sets the row height.
	*
	* @param rowHeight 		 the row height to set
	* @see		#getRowHeight
	**/
	 public void setRowHeight(int rowHeight)
	{
	}


	/**
	* Sets the number of rows that are to be displayed. This will only work if the
	* reciever is contained in a <code>ULCScrollPane</code>,
and will adjust the
	* preferred size and size of that scrollpane.
	*
	* @param visibleRowCount 		 the number of rows to display
	**/
	 public void setVisibleRowCount(int visibleRowCount)
	{
	}


	/**
	* Determines if the tree scrolls to show previously hidden children, false
	* otherwise.
	*
	* @param scrollsOnExpand 		 true if the tree should scroll to show previously hidden children, false otherwise.
	* @see		#getScrollsOnExpand
	**/
	 public void setScrollsOnExpand(boolean scrollsOnExpand)
	{
	}


	/**
	* Selects the paths in the specified interval.
	*
	* @param index0 		 a margin of the interval
	* @param index1 		 the other margin of the interval
	**/
	 public void setSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Selects the specified path. If the path isn't viewable it is made viewable.
	*
	* @param path 		 the path to select
	**/
	 public void setSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Selects the specified paths. If any of the paths isn't viewable it is made
	* viewable.
	*
	* @param paths 		 the paths to select
	**/
	 public void setSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Selects the node at the specified row in the display.
	*
	* @param row 		 the row to select, where 0 is the first row in the display
	**/
	 public void setSelectionRow(int row)
	{
	}


	/**
	* Selects the nodes corresponding to each of the specified rows in the display.
	*
	* @param rows 		 an array of ints specifying the rows to select, where 0 indicates the first row in the display
	**/
	 public void setSelectionRows(int[] rows)
	{
	}


	/**
	* Determines if root handles are shown or not.
	*
	* @param showsRootHandles 		 true if root handles should be shown, false otherwise
	* @see		#getShowsRootHandles
	**/
	 public void setShowsRootHandles(boolean showsRootHandles)
	{
	}


	/**
	* Returns true if the row height has a fixed size.
	*
	* @return		true if the height of each row is a fixed size
	**/
	 public boolean isFixedRowHeight()
	{
		return false;
	}


	/**
	* Determines whether the tree should be configured for a large model.
	*
	* @param largeModel 		 true if the tree's UI should use a large model
	**/
	 public void setLargeModel(boolean largeModel)
	{
	}


	/**
	* Returns true if the tree should use a large model.
	*
	* @return		true if the tree should use a large model
	* @see		#setLargeModel
	**/
	 public boolean isLargeModel()
	{
		return false;
	}


	/**
	* Returns the first selected row.
	*
	* @return		index of the first selected row
	**/
	 public int getMinSelectionRow()
	{
		return 0;
	}


	/**
	* Returns the last selected row.
	*
	* @return		index of the last selected row
	**/
	 public int getMaxSelectionRow()
	{
		return 0;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}


	/**
	* Returns the transfer handler.
	*
	* @return		the instance of TransferHandler
	**/
	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>ITreeExpansionListener</code>s added to this
	* <code>ULCTree</code> with
<code>addTreeExpansionListener()</code>.
	*
	* @return		all <code>ITreeExpansionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ITreeExpansionListener[] getTreeExpansionListeners()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>ITreeSelectionListener</code>s added to this
	* <code>ULCTree</code> with
<code>addTreeSelectionListener()</code>.
	*
	* @return		all <code>ITreeSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ITreeSelectionListener[] getTreeSelectionListeners()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* Returns the number of mouse clickes needed for the node to expand or collapse.
	*
	* @return		the number of mouse clicks.
	**/
	 public int getToggleClickCount()
	{
		return 0;
	}


	/**
	* Sets the number of mouse clicks needed for a node to expand or collapse. The
	* default is set to two.
	*
	* @param toggleClickCount 		 the number of mouse clicks.
	**/
	 public void setToggleClickCount(int toggleClickCount)
	{
	}

	 protected com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTreeDispatcher extends ULCComponentDispatcher
{

	 public  final void requestRendererComponents(int[][] descriptions)
	{
	}

	 public  final void requestEditorComponents(int[][] descriptions)
	{
	}


}
}