package com.ulcjava.base.application;


	/**
	* <code>ULCWindow</code> provides a window without title bar and e.g. close,
	* iconify buttons and other features associates with
<code>ULCFrame</code>. A
	* possible use are splash screens. The <code>ULCWindow</code> can only be
	* closedor moved programmatically.
It also is the base class for the other
	* window classes (<code>ULCDialog</code>, <code>ULCFrame</code>). It can take
	* another
<code>ULCWindow</code> as a parent
	* window.
<p>
</p>
<b>Features</b>
<ul>
<li>Windows without title bar which can
	* be manipulated only programmatically.</li>
<li>Provides an array with all
	* other windows owned by a given window.</li>
<li>Offers a <code>pack</code>
	* method which initiates the layout of the components according to the
	* preferredsize and layouts of the
contained
	* components.
</ul>
<b>Examples</b>
<p>
</p>
Display information about the
	* number of other windows owned by a given window.

<pre>
final ULCButton
	* windowsButton = new ULCButton(&quot;Open a
	* window&quot;);
windowsButton.addActionListener(new IActionListener() {
public
	* void actionPerformed(ActionEvent event) {
ULCDialog dialog = new
	* ULCDialog(window, &quot;Dialog &quot;
+
	* window.getOwnedWindows().length);
dialog.add(new ULCLabel(&quot;This is
	* dialogno. &quot;
+
	* window.getOwnedWindows().length));
dialog.setVisible(true);}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCDialog
	* @see		ULCFrame
	**/
 public class ULCWindow extends com.ulcjava.base.application.ULCRootPane implements com.ulcjava.base.shared.IWindowConstants
{


	/**
	* Constructs a new initially invisible window.
	*
	* @see		ULCComponent#setVisible
	**/
	 public ULCWindow()
	{
		 super();
	}


	/**
	* Constructs a new window with the specified owner.
	*
	* @param owner 		 the specified owner
	**/
	 public ULCWindow(com.ulcjava.base.application.ULCWindow owner)
	{
		 super();
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Registers the given window listener with this window. If listener is null
	* nothing happens.
	*
	* @param listener 		 the window listener
	**/
	 public void addWindowListener(com.ulcjava.base.application.event.IWindowListener listener)
	{
	}


	/**
	* Registers the given window focus listener with this window
	*
	* @param listener 		 the window focus listener
	**/
	 public void addWindowFocusListener(com.ulcjava.base.application.event.IWindowFocusListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IWindowListener</code>s added to this
	* <code>ULCWindow</code> with
<code>addWindowListener()</code>.
	*
	* @return		all <code>IWindowListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IWindowListener[] getWindowListeners()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IWindowFocusListener</code>s added to this
	* <code>ULCWindow</code> with
<code>addWindowFocusListener()</code>.
	*
	* @return		all <code>IWindowFocusListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IWindowFocusListener[] getWindowFocusListeners()
	{
		return null;
	}


	/**
	* Removes the specified window listener from this window's listeners list. If
	* listener is null, nothing happens.
	*
	* @param listener 		 the window listener
	**/
	 public void removeWindowListener(com.ulcjava.base.application.event.IWindowListener listener)
	{
	}


	/**
	* Removes the specified window focus listener from this window's listeners list.
	* If listener is null, nothing happens.
	*
	* @param listener 		 the window focus listener
	**/
	 public void removeWindowFocusListener(com.ulcjava.base.application.event.IWindowFocusListener listener)
	{
	}

	 public void setLocation(com.ulcjava.base.application.util.Point location)
	{
	}


	/**
	* Sets the location of the window relative to the specified component. If the
	* component is null, the window is centered on the screen.
	*
	* @param component 		 the component to which the window should be displayed relative to or null if the window should be centered on the
screen.
	**/
	 public void setLocationRelativeTo(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Moves and resizes this component. The new location of the top-left corner is
	* specified by <code>x</code> and <code>y</code>, and
the new size is specified
	* by <code>width</code> and <code>height</code>.
	*
	* @param x 		 The new <i>x</i>-coordinate of this component.
	* @param y 		 The new <i>y</i>-coordinate of this component.
	* @param width 		 The new <code>width</code> of this component.
	* @param height 		 The new <code>height</code> of this component.
	**/
	 public void setBounds(int x, int y, int width, int height)
	{
	}


	/**
	* Returns the windows owned by this window in an array.
	*
	* @return		an array of ULCWindow objects
	**/
	 public com.ulcjava.base.application.ULCWindow[] getOwnedWindows()
	{
		return null;
	}


	/**
	* Initiates the layout of the components in this window according to the
	* preferred size and layouts of the contained components.
	*
	**/
	 public void pack()
	{
	}


	/**
	* Checks if the window is displayable. After creating the window, it is
	* initiallynot displayable. It becomes displayable
	* with
<code>setVisible(true)</code>. The window is not displayable anymore
	* after <code>dispose()</code>.
	*
	* @return		the displayable flag
	**/
	 public boolean isDisplayable()
	{
		return false;
	}

	 protected void addNotify()
	{
	}

	 public void setVisible(boolean visible)
	{
	}


	/**
	* If this ULCWindow is visible, brings this ULCWindow to the front and may make
	* it the focused ULCWindow. No action will take place if
this ULCWindow is not
	* visible.
	*
	**/
	 public void toFront()
	{
	}


	/**
	* If this ULCWindow is visible, sends this ULCWindow to the back and may cause
	* itto lose focus or activation if it is the focused or
active ULCWindow. No
	* action will take place is this ULCWindow is not visible.
	*
	**/
	 public void toBack()
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @param preferredSize 		 the preferred size Dimension
	* @throws		UnsupportedOperationException
	**/
	 public void setPreferredSize(com.ulcjava.base.application.util.Dimension preferredSize)throws java.lang.UnsupportedOperationException
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public com.ulcjava.base.application.util.Dimension getPreferredSize()throws java.lang.UnsupportedOperationException
	{
		return null;
	}


	/**
	* This operation is not supported for windows.
	*
	* @param minimumSize 		 the minimum size Dimension
	* @throws		UnsupportedOperationException
	**/
	 public void setMinimumSize(com.ulcjava.base.application.util.Dimension minimumSize)throws java.lang.UnsupportedOperationException
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public void setMaximumSize(com.ulcjava.base.application.util.Dimension maximumSize)throws java.lang.UnsupportedOperationException
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public float getAlignmentX()
	{
		return 0.0f;
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public void setAlignmentX(float alignmentX)
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public float getAlignmentY()
	{
		return 0.0f;
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public void setAlignmentY(float alignmentY)
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @param requestFocusEnabled 		 true if this component should be focusable, false otherwise
	* @throws		UnsupportedOperationException
	**/
	 public void setRequestFocusEnabled(boolean requestFocusEnabled)throws java.lang.UnsupportedOperationException
	{
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public boolean isRequestFocusEnabled()throws java.lang.UnsupportedOperationException
	{
		return false;
	}


	/**
	* Returns <code>true</code> because all Windows must be roots of a focus
	* traversal cycle.
	*
	* @see		ULCComponent#setFocusCycleRoot
	**/
	 public  final boolean isFocusCycleRoot()
	{
		return false;
	}


	/**
	* This operation is not supported for windows.
	*
	* @throws		UnsupportedOperationException
	**/
	 public void revalidate()
	{
	}


	/**
	* Releases all of the native screen resources used by this
	* <code>ULCWindow</code>on the correspondig client side
<code>UIWindow</code>
	* proxy. (A call to this method corresponds to {@link
	* javax.swing.JWindow#dispose()}.)
	*
	**/
	 public void dispose()
	{
	}

	 protected void removeNotify()
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCWindowDispatcher extends ULCRootPaneDispatcher
{


}
}