package com.ulcjava.base.application;


	/**
	* <code>UlcUtilities</code> contains a collection of utility methods for
	* ULC.
<p></p>
<b>Features</b>
<ul>
<li>Find an ancestor by name for a
	* component.</li>
<li>Get the first ancestor of type specified by a class for a
	* component.</li>
<li>Get the root pane and/ or root for a
	* component.</li>
<li>Get the first window ancestor for a
	* component.</li>
<li>Ability to execute a runnable at the end of the server
	* roundtrip.</li>
<li>Check if a component is descending from another
	* one.</li>
</ul>
<b>Examples</b>
<p>
</p>
Retrieve a specific component
	* throughits name:

<pre>
ULCComponent component =
	* UlcUtilities.getAncestorNamed(&quot;upper&quot;,
	* aButton);
component.setBackground(Color.red);
</pre>

Displaying the name of
	* the first ancestor of <code>ULCBoxPane</code>
	* class:

<pre>
aLabel.setText(UlcUtilities.getAncestorOfClass(ULCBoxPane.class,
	* ancestorButton).getName());
</pre>
	*
	* @ulc.application		
	**/
 public class UlcUtilities extends java.lang.Object
{

	 private UlcUtilities()
	{
		 super();
	}


	/**
	* This method adds the specified Runnable instance to a queue which will be
	* processed at the end of the current server round trip
before sending the
	* response to the client.
<p>
</p>
Note: This method is only safe to be called
	* from within the ULC thread. As usual, only ULC objects belonging to the
	* session of the
current thread may be manipulated.
	*
	* @param runnable 		 the Runnable whose run() method should be executed at the end of the current server round trip before sending the
response to the client
	* @throws		IllegalThreadStateException thrown if this method is not called from within a ULC thread
	**/
	 public  static void invokeLater(java.lang.Runnable runnable)
	{
	}


	/**
	* Returns true if the calling thread is a ULC thread. Use this call to ensure
	* that a given task is being executed (or not being) on a
ULC thread.
	*
	* @return		true if called by a ULC thread
	**/
	 public  static boolean isUlcThread()
	{
		return false;
	}


	/**
	* Returns the first ancestor of the provided component with the provided name.
	*
	* @param name 		 the name of the ancestor
	* @param component 		 the component
	* @return		the first ancestor of the provided component with the provided name
	**/
	 public  static com.ulcjava.base.application.ULCContainer getAncestorNamed(java.lang.String name, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the first ancestor of the provided component with the provided class.
	*
	* @param clazz 		 the class of the ancestor
	* @param component 		 the component
	* @return		the first ancestor of the provided component with the provided class
	**/
	 public  static com.ulcjava.base.application.ULCContainer getAncestorOfClass(java.lang.Class clazz, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the window or applet pane for the provided component. Note that this
	* method starts the search with the component, not with
the ancestor.
	*
	* @param component 		 the component
	* @return		the window or applet pane root of the provided component
	**/
	 public  static com.ulcjava.base.application.ULCRootPane getRoot(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the root pane for the provided component. Note that this method starts
	* the search with the component, not with the ancestor.
	*
	* @param component 		 the component
	* @return		the root pane of the provided component
	**/
	 public  static com.ulcjava.base.application.ULCRootPane getRootPane(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the window ancestor of the provided component.
	*
	* @param component 		 the component
	* @return		the window ancestor of the provided component
	**/
	 public  static com.ulcjava.base.application.ULCWindow getWindowAncestor(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the window ancestor of the provided component.
	*
	* @param component 		 the component
	* @return		the window ancestor of the provided component
	**/
	 public  static com.ulcjava.base.application.ULCWindow windowForComponent(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns true if the provided component is a descendant of the provided
	* container, false otherwise. Note that this method returns true
if the
	* providedparameters are equal.
	*
	* @param component 		 the component
	* @param container 		 the container
	* @return		true if the provided component is a descendant of the provided container, false otherwise
	**/
	 public  static boolean isDescendingFrom(com.ulcjava.base.application.ULCComponent component, com.ulcjava.base.application.ULCComponent container)
	{
		return false;
	}


}