package com.ulcjava.base.application.border;


	/**
	* <code>ULCAbstractBorder</code> is the abstract base class for all ULC borders.
	* In addition to providing fancy boundaries to
<code>ULCComponent</code>s, ULC
	* borders can be used to provide titles and empty spaces around
	* <code>ULCComponent</code>s. Borders
take precedence over Insets for providing
	* a specially painted area around the edge of a
	* component.
<p>
</p>
<b>Note:</b>The look and feel implementation of many
	* standard Swing components doesn't work well with user-set borders. Therefore
	* it is
recommended to set the component in a container (e.g.
	* <code>ULCBorderLayoutPane</code>) and set the border on this
	* container.
<p>
</p>
<b>Features</b>
<p>
</p>
<ul>
<li>{@link ULCEmptyBorder}
	* provides a blank border that creates an empty space around a
	* component.
<li>{@link ULCCompoundBorder} combines two borders into a single
	* border. It can be used to nest multiple border objects.
<li>Use the {@link
	* com.ulcjava.base.application.BorderFactory} methods to produce instances of
	* the common border types.
<li>Common border styles include {@link
	* ULCBevelBorder}, {@link ULCEtchedBorder}, {@link ULCLineBorder}, {@link
	* ULCTitledBorder} and
{@link ULCMatteBorder}.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	* @see		ULCEmptyBorder
	* @see		ULCCompoundBorder
	**/
 public  abstract class ULCAbstractBorder extends com.ulcjava.base.application.ULCProxy
{

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCAbstractBorderDispatcher extends ULCProxyDispatcher
{


}
}