package com.ulcjava.base.application.border;


	/**
	* <code>ULCBevelBorder</code> provides a simple two line bevel
	* border.
<p>
</p>
<b>Features</b>
<ul>
<li>Provides two bevel types:
	* <code>RAISED</code> and <code>LOWERED</code>.
<li>Provides for setting of
	* colors for the outer and inner
	* borders.
</ul>
<p>
</p>
<b>Examples</b>

<pre>
ULCBevelBorder raisedbevel =
	* BorderFactory.createRaisedBevelBorder();
ULCBevelBorder loweredbevel =
	* BorderFactory.createLoweredBevelBorder();
ULCBevelBorder coloredbevel =
	* BorderFactory.createBevelBorder(
ULCBevelBorder.RAISED, Color.red,
	* Color.green, Color.blue,
Color.pink);
ULCLabel label = new
	* ULCLabel(&quot;Colored Bevel
	* Border&quot;);
label.setBorder(coloredbevel);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	**/
 public class ULCBevelBorder extends com.ulcjava.base.application.border.ULCAbstractBorder
{

	/**
	* Raised bevel type.
	*
	**/
	 public  final  static int RAISED = 0;

	/**
	* Lowered bevel type.
	*
	**/
	 public  final  static int LOWERED = 0;


	/**
	* Constructs a bevel border with the specified type. Its colors will be derived
	* from the background color of the component around which
the border will be
	* painted.
	*
	* @param bevelType 		 the type of bevel for the border
	**/
	 public ULCBevelBorder(int bevelType)
	{
	}


	/**
	* Constructs a bevel border with the specified type, highlight and shadow colors.
	*
	* @param bevelType 		 the type of bevel for the border
	* @param highlight 		 the color for the bevel highlight
	* @param shadow 		 the color for the bevel shadow
	**/
	 public ULCBevelBorder(int bevelType, com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
	}


	/**
	* Constructs a bevel border with the specified type, highlight shadow colors.
	*
	* @param bevelType 		 the type of bevel for the border
	* @param highlightOuter 		 the color for the bevel outer highlight
	* @param highlightInner 		 the color for the bevel inner highlight
	* @param shadowOuter 		 the color for the bevel outer shadow
	* @param shadowInner 		 the color for the bevel inner shadow
	**/
	 public ULCBevelBorder(int bevelType, com.ulcjava.base.application.util.Color highlightOuter, com.ulcjava.base.application.util.Color highlightInner, com.ulcjava.base.application.util.Color shadowOuter, com.ulcjava.base.application.util.Color shadowInner)
	{
	}


	/**
	* Returns the insets of the border. The new <code>Insets</code> instance has the
	* <code>top</code>, <code>left</code>,
<code>bottom</code> , and
	* <code>right</code> fields set to <code>2</code>.
	*
	* @param c 		 the component for which this border insets value applies
	* @return		<code>Insets</code> object initialized to 2
	**/
	 public com.ulcjava.base.application.util.Insets getBorderInsets(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns whether or not the border is opaque.
	*
	* @return		true
	**/
	 public boolean isBorderOpaque()
	{
		return false;
	}


	/**
	* Returns the outer highlight color of the bevel border when rendered on the
	* specified component. If no highlight color was specified
at instantiation,
	* thehighlight color is derived from the specified component's background color.
	*
	* @param c 		 the component for which the highlight may be derived
	* @return		Color the outer highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightOuterColor(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns the inner highlight color of the bevel border when rendered on the
	* specified component. If no highlight color was specified
at instantiation,
	* thehighlight color is derived from the specified component's background color.
	*
	* @param c 		 the component for which the highlight may be derived
	* @return		Color the inner highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightInnerColor(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns the inner shadow color of the bevel border when rendered on the
	* specified component. If no shadow color was specified at
instantiation, the
	* shadow color is derived from the specified component's background color.
	*
	* @param c 		 the component for which the shadow may be derived
	* @return		Color the inner shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowInnerColor(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns the outer shadow color of the bevel border when rendered on the
	* specified component. If no shadow color was specified at
instantiation, the
	* shadow color is derived from the specified component's background color.
	*
	* @param c 		 the component for which the shadow may be derived
	* @return		Color the outer shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowOuterColor(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns the outer highlight color of the bevel border. Returns null if
	* highlight color was not specified at construction.
	*
	* @return		Color the outer highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightOuterColor()
	{
		return null;
	}


	/**
	* Returns the inner highlight color of the bevel border. Returns null if
	* highlight color was not specified at construction.
	*
	* @return		Color the inner highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightInnerColor()
	{
		return null;
	}


	/**
	* Returns the inner shadow color of the bevel border. Returns null if shadow
	* color was not specified at construction.
	*
	* @return		Color the inner shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowInnerColor()
	{
		return null;
	}


	/**
	* Returns the outer shadow color of the bevel border. Returns null if shadow
	* color was not specified at construction.
	*
	* @return		Color the outer shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowOuterColor()
	{
		return null;
	}


	/**
	* Returns the type of the bevel border.
	*
	* @return		int the bevel type
	**/
	 public int getBevelType()
	{
		return 0;
	}

	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in the deprecated
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)
method.
	*
	* @ulc.extension		
	* @deprecated		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCBevelBorderDispatcher extends ULCAbstractBorderDispatcher
{


}
}