package com.ulcjava.base.application.border;


	/**
	* <code>ULCEtchedBorder</code> provides a simple etched border which can either
	* be etched-in or etched-out. If the highlight/shadow colors
are not specified
	* when the border is created, then these colors will be dynamically derived
	* fromthe background color of the component
around which the border is
	* painted.
<p>
</p>
<b>Features</b>
<ul>
<li>Provides two etch types:
	* <code>RAISED</code> and <code>LOWERED</code>.
<li>Provides for setting of
	* colors for highlight and
	* shadow.
</ul>
<p>
</p>
<b>Examples</b>

<pre>
ULCEtchedBorder raisedetched =
	* BorderFactory
.createEtchedBorder(ULCEtchedBorder.RAISED);
ULCEtchedBorder
	* loweredetched =
	* BorderFactory
.createEtchedBorder(ULCEtchedBorder.LOWERED);
ULCEtchedBorder
	* etchedcolorraised = BorderFactory.createEtchedBorder(
ULCEtchedBorder.RAISED,
	* Color.cyan, Color.orange);
ULCLabel label = new ULCLabel(&quot;Raised Etched
	* Border with Colors&quot;);
label.setBorder(etchedcolorraised);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	**/
 public class ULCEtchedBorder extends com.ulcjava.base.application.border.ULCAbstractBorder
{

	/**
	* Raised etch type.
	*
	**/
	 public  final  static int RAISED = 0;

	/**
	* Lowered etch type.
	*
	**/
	 public  final  static int LOWERED = 0;


	/**
	* Constructs a lowered etched border. Its colors will be derived from the
	* background color of the component passed around which it is
painted.
	*
	**/
	 public ULCEtchedBorder()
	{
	}


	/**
	* Constructs an etched border with the given etch-type. Its colors will be
	* derived from the background color of the component passed
around which it is
	* painted.
	*
	* @param etchType 		 the type of etch to be drawn by the border
	**/
	 public ULCEtchedBorder(int etchType)
	{
	}


	/**
	* Constructs a lowered etched border with the given highlight and shadow colors.
	*
	* @param highlight 		 the color to use for the etched highlight
	* @param shadow 		 the color to use for the etched shadow
	**/
	 public ULCEtchedBorder(com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
	}


	/**
	* Constructs an etched border with the specified etch-type, highlight and shadow
	* colors.
	*
	* @param etchType 		 the type of etch to be drawn by the border
	* @param highlight 		 the color to use for the etched highlight
	* @param shadow 		 the color to use for the etched shadow
	**/
	 public ULCEtchedBorder(int etchType, com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
	}


	/**
	* Returns the insets of the border. The new <code>Insets</code> instance has the
	* <code>top</code>,<code>left</code>,<code>bottom</code>
, and
	* <code>right</code> fields set to <code>2</code>.
	*
	* @param c 		 the component for which this border insets value applies
	* @return		<code>Insets</code> object initialised to 2
	**/
	 public com.ulcjava.base.application.util.Insets getBorderInsets(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns whether or not the border is opaque.
	*
	* @return		true
	**/
	 public boolean isBorderOpaque()
	{
		return false;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Returns which etch-type is set on the etched border.
	*
	* @return		int the etch type
	**/
	 public int getEtchType()
	{
		return 0;
	}


	/**
	* Returns the highlight color of the etched border when rendered on the
	* specifiedcomponent. If no highlight color was specified at
instantiation, the
	* highlight color is derived from the specified component's background color.
	*
	* @param component 		 the component for which the highlight may be derived
	* @return		Color the highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightColor(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the highlight color of the etched border. Will return null if no
	* highlight color was specified at instantiation.
	*
	* @return		Color the highlight color
	**/
	 public com.ulcjava.base.application.util.Color getHighlightColor()
	{
		return null;
	}


	/**
	* Returns the shadow color of the etched border when rendered on the specified
	* component. If no shadow color was specified at
instantiation, the shadow
	* coloris derived from the specified component's background color.
	*
	* @param component 		 the component for which the shadow may be derived
	* @return		Color the shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowColor(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Returns the shadow color of the etched border. Will return null if no shadow
	* color was specified at instantiation.
	*
	* @return		Color the shadow color
	**/
	 public com.ulcjava.base.application.util.Color getShadowColor()
	{
		return null;
	}

	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in the deprecated
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)
method.
	*
	* @ulc.extension		
	* @deprecated		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCEtchedBorderDispatcher extends ULCAbstractBorderDispatcher
{


}
}