package com.ulcjava.base.application.border;


	/**
	* <code>ULCMatteBorder</code> provides a matte-like border of either a solid
	* color or a tiled icon.
<p>
</p>
<b>Features</b>
<ul>
<li>Provides for setting
	* of border color and icon for tiling.
<li>Uses <code>ULCEmptyBorder</code> for
	* insets.
</ul>
<p>
</p>
<b>Examples</b>

<pre>
ULCMatteBorder
	* coloredmatteborder = BorderFactory.createMatteBorder(2, 5,
2, 2,
	* Color.red);
ULCIcon icon = new ULCIcon(imgURL);
ULCMatteBorder
	* iconmatteborder= BorderFactory.createMatteBorder(0, 15, 0,
0, icon);
ULCLabel
	* label = new ULCLabel(&quot;Icon Matte
	* Border&quot;);
label.setBorder(iconmatteborder);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	* @see		ULCEmptyBorder
	**/
 public class ULCMatteBorder extends com.ulcjava.base.application.border.ULCEmptyBorder
{


	/**
	* Constructs a matte border with the given insets and color.
	*
	* @param top 		 the top inset of the border
	* @param left 		 the left inset of the border
	* @param bottom 		 the bottom inset of the border
	* @param right 		 the right inset of the border
	* @param matteColor 		 the color rendered for the border
	**/
	 public ULCMatteBorder(int top, int left, int bottom, int right, com.ulcjava.base.application.util.Color matteColor)
	{
		 super((com.ulcjava.base.application.util.Insets)null);
	}


	/**
	* Constructs a matte border with the given insets and color.
	*
	* @param borderInsets 		 the insets of the border
	* @param matteColor 		 the color rendered for the border
	**/
	 public ULCMatteBorder(com.ulcjava.base.application.util.Insets borderInsets, com.ulcjava.base.application.util.Color matteColor)
	{
		 super((com.ulcjava.base.application.util.Insets)null);
	}


	/**
	* Constructs a matte border with the given insets and tile icon.
	*
	* @param top 		 the top inset of the border
	* @param left 		 the left inset of the border
	* @param bottom 		 the bottom inset of the border
	* @param right 		 the right inset of the border
	* @param tileIcon 		 the icon to be used for tiling the border
	**/
	 public ULCMatteBorder(int top, int left, int bottom, int right, com.ulcjava.base.application.util.ULCIcon tileIcon)
	{
		 super((com.ulcjava.base.application.util.Insets)null);
	}


	/**
	* Constructs a matte border with the given insets and tile icon.
	*
	* @param borderInsets 		 the insets of the border
	* @param tileIcon 		 the icon to be used for tiling the border
	**/
	 public ULCMatteBorder(com.ulcjava.base.application.util.Insets borderInsets, com.ulcjava.base.application.util.ULCIcon tileIcon)
	{
		 super((com.ulcjava.base.application.util.Insets)null);
	}


	/**
	* Constructs a matte border with the given tile icon. The insets will be
	* calculated dynamically based on the size of the tile icon,
where the top and
	* bottom will be equal to the tile icon's height, and the left and right will
	* beequal to the tile icon's width.
	*
	* @param tileIcon 		 the icon to be used for tiling the border
	**/
	 public ULCMatteBorder(com.ulcjava.base.application.util.ULCIcon tileIcon)
	{
		 super((com.ulcjava.base.application.util.Insets)null);
	}


	/**
	* Returns the color used for tiling the border or null if a tile icon is being
	* used.
	*
	* @return		Color the color for tiling border
	**/
	 public com.ulcjava.base.application.util.Color getMatteColor()
	{
		return null;
	}


	/**
	* Returns the icon used for tiling the border or null if a solid color is being
	* used.
	*
	* @return		ULCIcon the icon for tiling border
	**/
	 public com.ulcjava.base.application.util.ULCIcon getTileIcon()
	{
		return null;
	}

	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in the deprecated
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)
method.
	*
	* @ulc.extension		
	* @deprecated		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCMatteBorderDispatcher extends ULCEmptyBorderDispatcher
{


}
}