package com.ulcjava.base.application.border;


	/**
	* <code>ULCSoftBevelBorder</code> provides a raised or lowered bevel with
	* softened corners.
<p>
</p>
<b>Features </b>
<ul>
<li>Provides two bevel
	* types:<code>RAISED</code> and <code>LOWERED</code>.
<li>Provides for setting
	* of colors for the outer and inner borders.
</ul>
<p>
</p>
<b>Examples
	* </b>
<p></p>

<pre>
ULCSoftBevelBorder raisedsoftbevel = new
	* ULCSoftBevelBorder(
ULCSoftBevelBorder.RAISED);
ULCSoftBevelBorder
	* loweredsoftbevel = new
	* ULCSoftBevelBorder(
ULCSoftBevelBorder.LOWERED);
ULCSoftBevelBorder
	* coloredsoftbevel = new ULCSoftBevelBorder(
ULCSoftBevelBorder.RAISED,
	* Color.red, Color.green, Color.blue,
Color.pink);
ULCLabel label = new
	* ULCLabel(&quot;Colored Soft Bevel
	* Border&quot;);
label.setBorder(coloredsoftbevel);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	**/
 public class ULCSoftBevelBorder extends com.ulcjava.base.application.border.ULCBevelBorder
{


	/**
	* Constructs a bevel border with the specified type. Its colors will be derived
	* from the background color of the component around which
the border will be
	* painted.
	*
	* @param bevelType 		 the type of bevel for the border
	**/
	 public ULCSoftBevelBorder(int bevelType)
	{
		 super(0);
	}


	/**
	* Constructs a bevel border with the specified type, highlight and shadow colors.
	*
	* @param bevelType 		 the type of bevel for the border
	* @param highlight 		 the color for the bevel highlight
	* @param shadow 		 the color for the bevel shadow
	**/
	 public ULCSoftBevelBorder(int bevelType, com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
		 super(0);
	}


	/**
	* Constructs a bevel border with the specified type, highlight shadow colors.
	*
	* @param bevelType 		 the type of bevel for the border
	* @param highlightOuter 		 the color for the bevel outer highlight
	* @param highlightInner 		 the color for the bevel inner highlight
	* @param shadowOuter 		 the color for the bevel outer shadow
	* @param shadowInner 		 the color for the bevel inner shadow
	**/
	 public ULCSoftBevelBorder(int bevelType, com.ulcjava.base.application.util.Color highlightOuter, com.ulcjava.base.application.util.Color highlightInner, com.ulcjava.base.application.util.Color shadowOuter, com.ulcjava.base.application.util.Color shadowInner)
	{
		 super(0);
	}


	/**
	* Returns the insets of the border. The new <code>Insets</code> instance has the
	* <code>top</code>, <code>left</code>,<code>bottom</code>,
and
	* <code>right</code> fields set to <code>3</code>.
	*
	* @param c 		 the component for which this border insets value applies
	* @return		<code>Insets</code> object initialized to 3
	**/
	 public com.ulcjava.base.application.util.Insets getBorderInsets(com.ulcjava.base.application.ULCComponent c)
	{
		return null;
	}


	/**
	* Returns whether or not the border is opaque.
	*
	* @return		false
	**/
	 public boolean isBorderOpaque()
	{
		return false;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSoftBevelBorderDispatcher extends ULCBevelBorderDispatcher
{


}
}