package com.ulcjava.base.application.border;


	/**
	* <code>ULCTitledBorder</code> provides an arbitrary border with the addition of
	* a String title in a specified position and
justification. If the border,
	* font,or color property values are not specified in the constuctor or by
	* invoking the appropriate set
methods, the property values will be defined by
	* the current look and feel.
<p>
</p>
<b>Features </b>
<ul>
<li>Provides a
	* titleto a border of a component.
<li>Provides for setting of title color,
	* position and justification.
</ul>
<p>
</p>
<b>Examples
	* </b>
<p>
</p>

<pre>
ULCTitledBorder lineborderwithtitle =
	* BorderFactory.createTitledBorder(
ULCLineBorder.createBlacklineBorder(),
	* &quot;title&quot;);
ULCTitledBorder titledborder =
	* BorderFactory.createTitledBorder(&quot;Title&quot;);
titledborder.setBorder(ULC
	* LineBorder.createBlacklineBorder());
titledborder.setTitleColor(Color.red);
titl
	* edborder.setTitleJustification(ULCTitledBorder.LEFT);
titledborder.setTitlePosit
	* ion(ULCTitledBorder.ABOVE_TOP);
titledborder.setTitleFont(new
	* Font(&quot;serif&quot;, Font.ITALIC, 16));
ULCLabel label = new
	* ULCLabel(&quot;Titled Border&quot;);
label.setBorder(titledborder);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	**/
 public class ULCTitledBorder extends com.ulcjava.base.application.border.ULCAbstractBorder
{

	/**
	* Use the default vertical orientation for the title text.
	*
	**/
	 public  final  static int DEFAULT_POSITION = 0;

	/**
	* Position the title above the border's top line.
	*
	**/
	 public  final  static int ABOVE_TOP = 0;

	/**
	* Position the title in the middle of the border's top line.
	*
	**/
	 public  final  static int TOP = 0;

	/**
	* Position the title below the border's top line.
	*
	**/
	 public  final  static int BELOW_TOP = 0;

	/**
	* Position the title above the border's bottom line.
	*
	**/
	 public  final  static int ABOVE_BOTTOM = 0;

	/**
	* Position the title in the middle of the border's bottom line.
	*
	**/
	 public  final  static int BOTTOM = 0;

	/**
	* Position the title below the border's bottom line.
	*
	**/
	 public  final  static int BELOW_BOTTOM = 0;

	/**
	* Use the default justification for the title text.
	*
	**/
	 public  final  static int DEFAULT_JUSTIFICATION = 0;

	/**
	* Position title text at the left side of the border line.
	*
	**/
	 public  final  static int LEFT = 0;

	/**
	* Position title text in the center of the border line.
	*
	**/
	 public  final  static int CENTER = 0;

	/**
	* Position title text at the right side of the border line.
	*
	**/
	 public  final  static int RIGHT = 0;

	/**
	* Position title text at the left side of the border line for left to right
	* orientation, at the right side of the border line for right
to left
	* orientation.
	*
	**/
	 public  final  static int LEADING = 0;

	/**
	* Position title text at the right side of the border line for left to right
	* orientation, at the left side of the border line for right
to left orientation.
	*
	**/
	 public  final  static int TRAILING = 0;


	/**
	* Constructs a titled border with given title..
	*
	* @param title 		 the title for the border
	**/
	 public ULCTitledBorder(java.lang.String title)
	{
	}


	/**
	* Constructs a titled border with the given border and an empty title.
	*
	* @param border 		 the border
	**/
	 public ULCTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border)
	{
	}


	/**
	* Constructs a titled border with the given border and title.
	*
	* @param border 		 the border
	* @param title 		 the title for the border
	**/
	 public ULCTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title)
	{
	}


	/**
	* Constructs a titled border instance with the given border, title,
	* title-justification, and title-position.
	*
	* @param border 		 the border
	* @param title 		 the title the border should display
	* @param titleJustification 		 the justification for the title
	* @param titlePosition 		 the position for the title
	**/
	 public ULCTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition)
	{
	}


	/**
	* Constructs a titled border with the specified border, title,
	* title-justification, title-position, and title-font.
	*
	* @param border 		 the border
	* @param title 		 the title the border should display
	* @param titleJustification 		 the justification for the title
	* @param titlePosition 		 the position for the title
	* @param titleFont 		 the font for rendering the title
	**/
	 public ULCTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition, com.ulcjava.base.application.util.Font titleFont)
	{
	}


	/**
	* Constructs a titled border with the given border, title, title-justification,
	* title-position, title-font, and title-color.
	*
	* @param border 		 the border
	* @param title 		 the title the border should display
	* @param titleJustification 		 the justification for the title
	* @param titlePosition 		 the position for the title
	* @param titleFont 		 the font of the title
	* @param titleColor 		 the color of the title
	**/
	 public ULCTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition, com.ulcjava.base.application.util.Font titleFont, com.ulcjava.base.application.util.Color titleColor)
	{
	}


	/**
	* Returns the title of the titled border.
	*
	* @return		the title of the border
	**/
	 public java.lang.String getTitle()
	{
		return null;
	}


	/**
	* Returns the border of the titled border.
	*
	* @return		<code>ULCAbstractBorder</code> the border
	**/
	 public com.ulcjava.base.application.border.ULCAbstractBorder getBorder()
	{
		return null;
	}


	/**
	* Returns the title-position of the titled border.
	*
	* @return		<code>int</code> the title-position
	**/
	 public int getTitlePosition()
	{
		return 0;
	}


	/**
	* Returns the title-justification of the titled border.
	*
	* @return		<code>int</code> the title-justification
	**/
	 public int getTitleJustification()
	{
		return 0;
	}


	/**
	* Returns the title-font of the titled border.
	*
	* @return		<code>Font</code> the title-font
	**/
	 public com.ulcjava.base.application.util.Font getTitleFont()
	{
		return null;
	}


	/**
	* Returns the title-color of the titled border.
	*
	* @return		<code>Color</code> the title-color
	**/
	 public com.ulcjava.base.application.util.Color getTitleColor()
	{
		return null;
	}


	/**
	* Sets the title-justification of the titled border.
	*
	* @param titleJustification 		 the justification for the border
	**/
	 public void setTitleJustification(int titleJustification)
	{
	}


	/**
	* Sets the title-position of the titled border.
	*
	* @param titlePosition 		 the position for the border
	**/
	 public void setTitlePosition(int titlePosition)
	{
	}


	/**
	* Sets the title of the titled border.
	*
	* @param title 		 the title for the border
	**/
	 public void setTitle(java.lang.String title)
	{
	}


	/**
	* Sets the border of the titled border.
	*
	* @param border 		 the border
	**/
	 public void setBorder(com.ulcjava.base.application.border.ULCAbstractBorder border)
	{
	}


	/**
	* Sets the title-font of the titled border.
	*
	* @param titleFont 		 the font for the border title
	**/
	 public void setTitleFont(com.ulcjava.base.application.util.Font titleFont)
	{
	}


	/**
	* Sets the title-color of the titled border.
	*
	* @param titleColor 		 the color for the border title
	**/
	 public void setTitleColor(com.ulcjava.base.application.util.Color titleColor)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTitledBorderDispatcher extends ULCAbstractBorderDispatcher
{


}
}